/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestBoundaryChecking {
    private ClassLoader copyClassLoader() {
        ClassLoader curClassLoader = this.getClass().getClassLoader();
        if (curClassLoader instanceof URLClassLoader) {
            return new URLClassLoader(((URLClassLoader)curClassLoader).getURLs(), null);
        }
        return null;
    }

    private boolean getFlagValue(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass("org.apache.arrow.memory.BoundsChecking");
        Field field = clazz.getField("BOUNDS_CHECKING_ENABLED");
        return (Boolean)field.get(null);
    }

    @Test
    public void testDefaultValue() throws Exception {
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean boundsCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertTrue((boolean)boundsCheckingEnabled);
        }
    }

    @Test
    public void testEnableOldProperty() throws Exception {
        String savedOldProperty = System.getProperty("drill.enable_unsafe_memory_access");
        System.setProperty("drill.enable_unsafe_memory_access", "true");
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean boundsCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertFalse((boolean)boundsCheckingEnabled);
        }
        if (savedOldProperty != null) {
            System.setProperty("drill.enable_unsafe_memory_access", savedOldProperty);
        } else {
            System.clearProperty("drill.enable_unsafe_memory_access");
        }
    }

    @Test
    public void testEnableNewProperty() throws Exception {
        String savedNewProperty = System.getProperty("arrow.enable_unsafe_memory_access");
        System.setProperty("arrow.enable_unsafe_memory_access", "true");
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean boundsCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertFalse((boolean)boundsCheckingEnabled);
        }
        if (savedNewProperty != null) {
            System.setProperty("arrow.enable_unsafe_memory_access", savedNewProperty);
        } else {
            System.clearProperty("arrow.enable_unsafe_memory_access");
        }
    }

    @Test
    public void testEnableBothProperties() throws Exception {
        String savedOldProperty = System.getProperty("drill.enable_unsafe_memory_access");
        String savedNewProperty = System.getProperty("arrow.enable_unsafe_memory_access");
        System.setProperty("drill.enable_unsafe_memory_access", "false");
        System.setProperty("arrow.enable_unsafe_memory_access", "true");
        ClassLoader classLoader = this.copyClassLoader();
        if (classLoader != null) {
            boolean boundsCheckingEnabled = this.getFlagValue(classLoader);
            Assert.assertFalse((boolean)boundsCheckingEnabled);
        }
        if (savedOldProperty != null) {
            System.setProperty("drill.enable_unsafe_memory_access", savedOldProperty);
        } else {
            System.clearProperty("drill.enable_unsafe_memory_access");
        }
        if (savedNewProperty != null) {
            System.setProperty("arrow.enable_unsafe_memory_access", savedNewProperty);
        } else {
            System.clearProperty("arrow.enable_unsafe_memory_access");
        }
    }
}

