/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestByteFunctionHelpers {
    private BufferAllocator allocator;
    private static final int SIZE = 100;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testEquals() {
        ArrowBuf buffer1 = this.allocator.buffer(100L);
        ArrowBuf buffer2 = this.allocator.buffer(100L);
        for (int i = 0; i < 100; ++i) {
            buffer1.setByte((long)i, i);
            buffer2.setByte((long)i, i);
        }
        Assert.assertEquals((long)1L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)99L, (ArrowBuf)buffer2, (long)0L, (long)99L));
        Assert.assertEquals((long)1L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)6L, (ArrowBuf)buffer2, (long)0L, (long)6L));
        Assert.assertEquals((long)1L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)2L, (ArrowBuf)buffer2, (long)0L, (long)2L));
        buffer1.setByte(1L, 10);
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)99L, (ArrowBuf)buffer2, (long)0L, (long)99L));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)6L, (ArrowBuf)buffer2, (long)0L, (long)6L));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.equal((ArrowBuf)buffer1, (long)0L, (long)2L, (ArrowBuf)buffer2, (long)0L, (long)2L));
        buffer1.close();
        buffer2.close();
    }

    @Test
    public void testCompare() {
        ArrowBuf buffer1 = this.allocator.buffer(100L);
        ArrowBuf buffer2 = this.allocator.buffer(100L);
        for (int i = 0; i < 100; ++i) {
            buffer1.setByte((long)i, i);
            buffer2.setByte((long)i, i);
        }
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)99L, (ArrowBuf)buffer2, (long)0L, (long)99L));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)6L, (ArrowBuf)buffer2, (long)0L, (long)6L));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)2L, (ArrowBuf)buffer2, (long)0L, (long)2L));
        buffer1.setByte(1L, 0);
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)99L, (ArrowBuf)buffer2, (long)0L, (long)99L));
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)6L, (ArrowBuf)buffer2, (long)0L, (long)6L));
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (long)0L, (long)2L, (ArrowBuf)buffer2, (long)0L, (long)2L));
        buffer1.close();
        buffer2.close();
    }

    @Test
    public void testStringCompare() {
        String[] leftStrings = new String[]{"cat", "cats", "catworld", "dogs", "bags"};
        String[] rightStrings = new String[]{"dog", "dogs", "dogworld", "dog", "sgab"};
        for (int i = 0; i < leftStrings.length; ++i) {
            String leftStr = leftStrings[i];
            String rightStr = rightStrings[i];
            ArrowBuf left = this.allocator.buffer(100L);
            left.setBytes(0L, leftStr.getBytes());
            ArrowBuf right = this.allocator.buffer(100L);
            right.setBytes(0L, rightStr.getBytes());
            Assert.assertEquals((long)(leftStr.compareTo(rightStr) < 0 ? -1L : 1L), (long)ByteFunctionHelpers.compare((ArrowBuf)left, (long)0L, (long)leftStr.length(), (ArrowBuf)right, (long)0L, (long)rightStr.length()));
            left.close();
            right.close();
        }
    }

    @Test
    public void testCompareWithByteArray() {
        ArrowBuf buffer1 = this.allocator.buffer(100L);
        byte[] buffer2 = new byte[100];
        for (int i = 0; i < 100; ++i) {
            buffer1.setByte((long)i, i);
            buffer2[i] = (byte)i;
        }
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)99, (byte[])buffer2, (int)0, (int)99));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)6, (byte[])buffer2, (int)0, (int)6));
        Assert.assertEquals((long)0L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)2, (byte[])buffer2, (int)0, (int)2));
        buffer1.setByte(1L, 0);
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)99, (byte[])buffer2, (int)0, (int)99));
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)6, (byte[])buffer2, (int)0, (int)6));
        Assert.assertEquals((long)-1L, (long)ByteFunctionHelpers.compare((ArrowBuf)buffer1, (int)0, (int)2, (byte[])buffer2, (int)0, (int)2));
        buffer1.close();
    }
}

