/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util.hash;

import java.util.Arrays;
import java.util.Collection;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.memory.util.hash.MurmurHasher;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestArrowBufHasher {
    private final int BUFFER_LENGTH = 1024;
    private BufferAllocator allocator;
    private ArrowBufHasher hasher;

    public TestArrowBufHasher(String name, ArrowBufHasher hasher) {
        this.hasher = hasher;
    }

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testHasher() {
        try (ArrowBuf buf1 = this.allocator.buffer(1024L);
             ArrowBuf buf2 = this.allocator.buffer(1024L);){
            for (int i = 0; i < 256; ++i) {
                buf1.setFloat((long)(i * 4), (float)i / 10.0f);
                buf2.setFloat((long)(i * 4), (float)i / 10.0f);
            }
            this.verifyHashCodesEqual(buf1, 0, 100, buf2, 0, 100);
            this.verifyHashCodesEqual(buf1, 1, 5, buf2, 1, 5);
            this.verifyHashCodesEqual(buf1, 10, 17, buf2, 10, 17);
            this.verifyHashCodesEqual(buf1, 33, 25, buf2, 33, 25);
            this.verifyHashCodesEqual(buf1, 22, 22, buf2, 22, 22);
            this.verifyHashCodesEqual(buf1, 123, 333, buf2, 123, 333);
            this.verifyHashCodesEqual(buf1, 374, 1, buf2, 374, 1);
            this.verifyHashCodesEqual(buf1, 11, 0, buf2, 11, 0);
            this.verifyHashCodesEqual(buf1, 75, 25, buf2, 75, 25);
            this.verifyHashCodesEqual(buf1, 0, 1024, buf2, 0, 1024);
        }
    }

    private void verifyHashCodesEqual(ArrowBuf buf1, int offset1, int length1, ArrowBuf buf2, int offset2, int length2) {
        int hashCode1 = this.hasher.hashCode(buf1, (long)offset1, (long)length1);
        int hashCode2 = this.hasher.hashCode(buf2, (long)offset2, (long)length2);
        Assert.assertEquals((long)hashCode1, (long)hashCode2);
    }

    @Test
    public void testHasherNegative() {
        try (ArrowBuf buf = this.allocator.buffer(1024L);){
            for (int i = 0; i < 256; ++i) {
                buf.setFloat((long)(i * 4), (float)i / 10.0f);
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.hasher.hashCode(buf, 0L, -1L));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.hasher.hashCode(buf, 0L, 1028L));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> this.hasher.hashCode(buf, 500L, 1000L));
        }
    }

    @Parameterized.Parameters(name="hasher = {0}")
    public static Collection<Object[]> getHasher() {
        return Arrays.asList({SimpleHasher.class.getSimpleName(), SimpleHasher.INSTANCE}, {MurmurHasher.class.getSimpleName(), new MurmurHasher()});
    }
}

