/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.SchemaUtility;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaUtil {
    private static Field field(String name, boolean nullable, ArrowType type, Field ... children) {
        return new Field(name, new FieldType(nullable, type, null, null), Arrays.asList(children));
    }

    @Test
    public void testSerializationAndDeserialization() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchemaUtil.field("a", false, (ArrowType)new ArrowType.Null(), new Field[0]), TestSchemaUtil.field("b", true, (ArrowType)new ArrowType.Utf8(), new Field[0]), TestSchemaUtil.field("c", true, (ArrowType)new ArrowType.Binary(), new Field[0])));
        byte[] serialized = SchemaUtility.serialize((Schema)schema);
        Schema deserialized = SchemaUtility.deserialize((byte[])serialized, (BufferAllocator)new RootAllocator(Long.MAX_VALUE));
        Assert.assertEquals((Object)schema, (Object)deserialized);
    }
}

