/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.VectorWithOrdinal;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.apache.arrow.vector.util.Text;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDenseUnionVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testDenseUnionVector() throws Exception {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        try (DenseUnionVector unionVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
            unionVector.allocateNew();
            byte uint4TypeId = unionVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.UINT4.getType()));
            unionVector.setTypeId(0, uint4TypeId);
            unionVector.setSafe(0, uInt4Holder);
            unionVector.setTypeId(2, uint4TypeId);
            unionVector.setSafe(2, uInt4Holder);
            unionVector.setValueCount(4);
            Assert.assertEquals((long)4L, (long)unionVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)unionVector.isNull(0));
            Assert.assertEquals((Object)100, (Object)unionVector.getObject(0));
            Assert.assertNull((Object)unionVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)unionVector.isNull(2));
            Assert.assertEquals((Object)100, (Object)unionVector.getObject(2));
            Assert.assertNull((Object)unionVector.getObject(3));
        }
    }

    @Test
    public void testTransfer() throws Exception {
        try (DenseUnionVector srcVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
            srcVector.allocateNew();
            byte intTypeId = srcVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            srcVector.setTypeId(0, intTypeId);
            srcVector.setSafe(0, TestDenseUnionVector.newIntHolder(5));
            byte bitTypeId = srcVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.BIT.getType()));
            srcVector.setTypeId(1, bitTypeId);
            srcVector.setSafe(1, TestDenseUnionVector.newBitHolder(false));
            srcVector.setTypeId(3, intTypeId);
            srcVector.setSafe(3, TestDenseUnionVector.newIntHolder(10));
            srcVector.setTypeId(5, bitTypeId);
            srcVector.setSafe(5, TestDenseUnionVector.newBitHolder(false));
            srcVector.setValueCount(6);
            try (DenseUnionVector destVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
                TransferPair pair = srcVector.makeTransferPair((ValueVector)destVector);
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                pair.transfer();
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                Assert.assertEquals((long)6L, (long)destVector.getValueCount());
                Assert.assertFalse((boolean)destVector.isNull(0));
                Assert.assertEquals((Object)5, (Object)destVector.getObject(0));
                Assert.assertFalse((boolean)destVector.isNull(1));
                Assert.assertEquals((Object)false, (Object)destVector.getObject(1));
                Assert.assertNull((Object)destVector.getObject(2));
                Assert.assertFalse((boolean)destVector.isNull(3));
                Assert.assertEquals((Object)10, (Object)destVector.getObject(3));
                Assert.assertNull((Object)destVector.getObject(4));
                Assert.assertFalse((boolean)destVector.isNull(5));
                Assert.assertEquals((Object)false, (Object)destVector.getObject(5));
            }
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (DenseUnionVector sourceVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
            sourceVector.allocateNew();
            byte intTypeId = sourceVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            sourceVector.setTypeId(0, intTypeId);
            sourceVector.setSafe(0, TestDenseUnionVector.newIntHolder(5));
            sourceVector.setTypeId(1, intTypeId);
            sourceVector.setSafe(1, TestDenseUnionVector.newIntHolder(10));
            sourceVector.setTypeId(2, intTypeId);
            sourceVector.setSafe(2, TestDenseUnionVector.newIntHolder(15));
            sourceVector.setTypeId(3, intTypeId);
            sourceVector.setSafe(3, TestDenseUnionVector.newIntHolder(20));
            sourceVector.setTypeId(4, intTypeId);
            sourceVector.setSafe(4, TestDenseUnionVector.newIntHolder(25));
            sourceVector.setTypeId(5, intTypeId);
            sourceVector.setSafe(5, TestDenseUnionVector.newIntHolder(30));
            sourceVector.setTypeId(6, intTypeId);
            sourceVector.setSafe(6, TestDenseUnionVector.newIntHolder(35));
            sourceVector.setTypeId(7, intTypeId);
            sourceVector.setSafe(7, TestDenseUnionVector.newIntHolder(40));
            sourceVector.setTypeId(8, intTypeId);
            sourceVector.setSafe(8, TestDenseUnionVector.newIntHolder(45));
            sourceVector.setTypeId(9, intTypeId);
            sourceVector.setSafe(9, TestDenseUnionVector.newIntHolder(50));
            sourceVector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceVector.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(1));
            Assert.assertEquals((Object)10, (Object)sourceVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(2));
            Assert.assertEquals((Object)15, (Object)sourceVector.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(3));
            Assert.assertEquals((Object)20, (Object)sourceVector.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(4));
            Assert.assertEquals((Object)25, (Object)sourceVector.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(5));
            Assert.assertEquals((Object)30, (Object)sourceVector.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(6));
            Assert.assertEquals((Object)35, (Object)sourceVector.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(7));
            Assert.assertEquals((Object)40, (Object)sourceVector.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(8));
            Assert.assertEquals((Object)45, (Object)sourceVector.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(9));
            Assert.assertEquals((Object)50, (Object)sourceVector.getObject(9));
            try (DenseUnionVector toVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
                int[][] transferLengths;
                toVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 3}, {3, 1}, {4, 2}, {6, 1}, {7, 1}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different data at indexes: " + (start + i) + "and " + i), (Object)sourceVector.getObject(start + i), (Object)toVector.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSplitAndTransferWithMixedVectors() throws Exception {
        try (DenseUnionVector sourceVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
            sourceVector.allocateNew();
            byte intTypeId = sourceVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            sourceVector.setTypeId(0, intTypeId);
            sourceVector.setSafe(0, TestDenseUnionVector.newIntHolder(5));
            byte float4TypeId = sourceVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.FLOAT4.getType()));
            sourceVector.setTypeId(1, float4TypeId);
            sourceVector.setSafe(1, TestDenseUnionVector.newFloat4Holder(5.5f));
            sourceVector.setTypeId(2, intTypeId);
            sourceVector.setSafe(2, TestDenseUnionVector.newIntHolder(10));
            sourceVector.setTypeId(3, float4TypeId);
            sourceVector.setSafe(3, TestDenseUnionVector.newFloat4Holder(10.5f));
            sourceVector.setTypeId(4, intTypeId);
            sourceVector.setSafe(4, TestDenseUnionVector.newIntHolder(15));
            sourceVector.setTypeId(5, float4TypeId);
            sourceVector.setSafe(5, TestDenseUnionVector.newFloat4Holder(15.5f));
            sourceVector.setTypeId(6, intTypeId);
            sourceVector.setSafe(6, TestDenseUnionVector.newIntHolder(20));
            sourceVector.setTypeId(7, float4TypeId);
            sourceVector.setSafe(7, TestDenseUnionVector.newFloat4Holder(20.5f));
            sourceVector.setTypeId(8, intTypeId);
            sourceVector.setSafe(8, TestDenseUnionVector.newIntHolder(30));
            sourceVector.setTypeId(9, float4TypeId);
            sourceVector.setSafe(9, TestDenseUnionVector.newFloat4Holder(30.5f));
            sourceVector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceVector.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(1));
            Assert.assertEquals((Object)Float.valueOf(5.5f), (Object)sourceVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(2));
            Assert.assertEquals((Object)10, (Object)sourceVector.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(3));
            Assert.assertEquals((Object)Float.valueOf(10.5f), (Object)sourceVector.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(4));
            Assert.assertEquals((Object)15, (Object)sourceVector.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(5));
            Assert.assertEquals((Object)Float.valueOf(15.5f), (Object)sourceVector.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(6));
            Assert.assertEquals((Object)20, (Object)sourceVector.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(7));
            Assert.assertEquals((Object)Float.valueOf(20.5f), (Object)sourceVector.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(8));
            Assert.assertEquals((Object)30, (Object)sourceVector.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(9));
            Assert.assertEquals((Object)Float.valueOf(30.5f), (Object)sourceVector.getObject(9));
            try (DenseUnionVector toVector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
                int[][] transferLengths;
                toVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
                toVector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.FLOAT4.getType()));
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {2, 1}, {3, 2}, {5, 3}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different values at index: " + i), (Object)sourceVector.getObject(start + i), (Object)toVector.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testGetFieldTypeInfo() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        int[] typeIds = new int[]{0, 1};
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("int", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
        children.add(new Field("varchar", FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null));
        FieldType fieldType = new FieldType(false, (ArrowType)new ArrowType.Union(UnionMode.Dense, typeIds), null, metadata);
        Field field = new Field("union", fieldType, children);
        Types.MinorType minorType = Types.MinorType.DENSEUNION;
        DenseUnionVector vector = (DenseUnionVector)minorType.getNewVector(field, this.allocator, null);
        vector.initializeChildrenFromFields(children);
        Assert.assertEquals((Object)vector.getField(), (Object)field);
        Assert.assertEquals((long)vector.size(), (long)2L);
        VectorWithOrdinal intChild = vector.getChildVectorWithOrdinal("int");
        Assert.assertEquals((long)intChild.ordinal, (long)0L);
        Assert.assertEquals((Object)intChild.vector.getField(), children.get(0));
        VectorWithOrdinal varcharChild = vector.getChildVectorWithOrdinal("varchar");
        Assert.assertEquals((long)varcharChild.ordinal, (long)1L);
        Assert.assertEquals((Object)varcharChild.vector.getField(), children.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBufferAddress() throws Exception {
        try (DenseUnionVector vector = new DenseUnionVector(EMPTY_SCHEMA_PATH, this.allocator, null, null);){
            boolean error = false;
            vector.allocateNew();
            byte intTypeId = vector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            vector.setTypeId(0, intTypeId);
            vector.setSafe(0, TestDenseUnionVector.newIntHolder(5));
            byte float4TypeId = vector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            vector.setTypeId(1, float4TypeId);
            vector.setSafe(1, TestDenseUnionVector.newFloat4Holder(5.5f));
            vector.setTypeId(2, intTypeId);
            vector.setSafe(2, TestDenseUnionVector.newIntHolder(10));
            vector.setTypeId(3, float4TypeId);
            vector.setSafe(3, TestDenseUnionVector.newFloat4Holder(10.5f));
            vector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)vector.getValueCount());
            Assert.assertEquals((Object)false, (Object)vector.isNull(0));
            Assert.assertEquals((Object)5, (Object)vector.getObject(0));
            Assert.assertEquals((Object)false, (Object)vector.isNull(1));
            Assert.assertEquals((Object)Float.valueOf(5.5f), (Object)vector.getObject(1));
            Assert.assertEquals((Object)false, (Object)vector.isNull(2));
            Assert.assertEquals((Object)10, (Object)vector.getObject(2));
            Assert.assertEquals((Object)false, (Object)vector.isNull(3));
            Assert.assertEquals((Object)Float.valueOf(10.5f), (Object)vector.getObject(3));
            List buffers = vector.getFieldBuffers();
            long offsetAddress = vector.getOffsetBufferAddress();
            try {
                vector.getDataBufferAddress();
            }
            catch (UnsupportedOperationException ue) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
            }
            Assert.assertEquals((long)2L, (long)buffers.size());
            Assert.assertEquals((long)offsetAddress, (long)((ArrowBuf)buffers.get(1)).memoryAddress());
        }
    }

    @Test
    public void testMultipleStructs() {
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
        try (StructVector structVector1 = new StructVector("struct1", this.allocator, type, null);
             StructVector structVector2 = new StructVector("struct2", this.allocator, type, null);
             DenseUnionVector unionVector = DenseUnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            IntVector subVector11 = (IntVector)structVector1.addOrGet("sub11", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
            subVector11.allocateNew();
            ValueVectorDataPopulator.setVector(subVector11, 0, 1);
            IntVector subVector12 = (IntVector)structVector1.addOrGet("sub12", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
            subVector12.allocateNew();
            ValueVectorDataPopulator.setVector(subVector12, 0, 10);
            structVector1.setIndexDefined(0);
            structVector1.setIndexDefined(1);
            structVector1.setValueCount(2);
            VarCharVector subVector21 = (VarCharVector)structVector2.addOrGet("sub21", FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), VarCharVector.class);
            subVector21.allocateNew();
            ValueVectorDataPopulator.setVector(subVector21, "a0");
            VarCharVector subVector22 = (VarCharVector)structVector2.addOrGet("sub22", FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), VarCharVector.class);
            subVector22.allocateNew();
            ValueVectorDataPopulator.setVector(subVector22, "b0");
            structVector2.setIndexDefined(0);
            structVector2.setValueCount(1);
            byte typeId1 = unionVector.registerNewTypeId(structVector1.getField());
            byte typeId2 = unionVector.registerNewTypeId(structVector2.getField());
            Assert.assertEquals((long)typeId1, (long)0L);
            Assert.assertEquals((long)typeId2, (long)1L);
            unionVector.addVector(typeId1, (FieldVector)structVector1);
            unionVector.addVector(typeId2, (FieldVector)structVector2);
            while (unionVector.getValueCapacity() < 3) {
                unionVector.reAlloc();
            }
            ArrowBuf offsetBuf = unionVector.getOffsetBuffer();
            unionVector.setTypeId(0, typeId1);
            offsetBuf.setInt(0L, 0);
            unionVector.setTypeId(1, typeId2);
            offsetBuf.setInt(4L, 0);
            unionVector.setTypeId(2, typeId1);
            offsetBuf.setInt(8L, 1);
            unionVector.setValueCount(3);
            JsonStringHashMap value0 = new JsonStringHashMap();
            value0.put("sub11", 0);
            value0.put("sub12", 0);
            Assert.assertEquals((Object)value0, (Object)unionVector.getObject(0));
            JsonStringHashMap value1 = new JsonStringHashMap();
            value1.put("sub21", new Text("a0"));
            value1.put("sub22", new Text("b0"));
            Assert.assertEquals((Object)value1, (Object)unionVector.getObject(1));
            JsonStringHashMap value2 = new JsonStringHashMap();
            value2.put("sub11", 1);
            value2.put("sub12", 10);
            Assert.assertEquals((Object)value2, (Object)unionVector.getObject(2));
        }
    }

    @Test
    public void testMultipleVarChars() {
        try (VarCharVector childVector1 = new VarCharVector("child1", this.allocator);
             VarCharVector childVector2 = new VarCharVector("child2", this.allocator);
             DenseUnionVector unionVector = DenseUnionVector.empty((String)"union", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector(childVector1, "a0", "a4");
            ValueVectorDataPopulator.setVector(childVector2, "b1", "b2");
            byte typeId1 = unionVector.registerNewTypeId(childVector1.getField());
            byte typeId2 = unionVector.registerNewTypeId(childVector2.getField());
            Assert.assertEquals((long)typeId1, (long)0L);
            Assert.assertEquals((long)typeId2, (long)1L);
            while (unionVector.getValueCapacity() < 5) {
                unionVector.reAlloc();
            }
            unionVector.addVector(typeId1, (FieldVector)childVector1);
            unionVector.addVector(typeId2, (FieldVector)childVector2);
            ArrowBuf offsetBuf = unionVector.getOffsetBuffer();
            unionVector.setTypeId(0, typeId1);
            offsetBuf.setInt(0L, 0);
            unionVector.setTypeId(1, typeId2);
            offsetBuf.setInt(4L, 0);
            unionVector.setTypeId(2, typeId2);
            offsetBuf.setInt(8L, 1);
            unionVector.setTypeId(4, typeId1);
            offsetBuf.setInt(16L, 1);
            unionVector.setValueCount(5);
            Assert.assertEquals((Object)new Text("a0"), (Object)unionVector.getObject(0));
            Assert.assertEquals((Object)new Text("b1"), (Object)unionVector.getObject(1));
            Assert.assertEquals((Object)new Text("b2"), (Object)unionVector.getObject(2));
            Assert.assertNull((Object)unionVector.getObject(3));
            Assert.assertEquals((Object)new Text("a4"), (Object)unionVector.getObject(4));
        }
    }

    @Test
    public void testChildVectorValueCounts() {
        NullableIntHolder intHolder = new NullableIntHolder();
        intHolder.isSet = 1;
        NullableBigIntHolder longHolder = new NullableBigIntHolder();
        longHolder.isSet = 1;
        NullableFloat4Holder floatHolder = new NullableFloat4Holder();
        floatHolder.isSet = 1;
        try (DenseUnionVector vector = new DenseUnionVector("vector", this.allocator, null, null);){
            vector.allocateNew();
            while (vector.getValueCapacity() < 6) {
                vector.reAlloc();
            }
            byte intTypeId = vector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.INT.getType()));
            vector.setTypeId(0, intTypeId);
            intHolder.value = 7;
            vector.setSafe(0, intHolder);
            byte longTypeId = vector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.BIGINT.getType()));
            vector.setTypeId(2, longTypeId);
            longHolder.value = 8L;
            vector.setSafe(2, longHolder);
            byte floatTypeId = vector.registerNewTypeId(Field.nullable((String)EMPTY_SCHEMA_PATH, (ArrowType)Types.MinorType.FLOAT4.getType()));
            vector.setTypeId(3, floatTypeId);
            floatHolder.value = 9.0f;
            vector.setSafe(3, floatHolder);
            vector.setTypeId(4, intTypeId);
            intHolder.value = 10;
            vector.setSafe(4, intHolder);
            vector.setTypeId(5, longTypeId);
            longHolder.value = 12L;
            vector.setSafe(5, longHolder);
            vector.setValueCount(6);
            IntVector intVector = (IntVector)vector.getVectorByType(intTypeId);
            Assert.assertEquals((long)2L, (long)intVector.getValueCount());
            Assert.assertEquals((long)7L, (long)intVector.get(0));
            Assert.assertEquals((long)10L, (long)intVector.get(1));
            BigIntVector longVector = (BigIntVector)vector.getVectorByType(longTypeId);
            Assert.assertEquals((long)2L, (long)longVector.getValueCount());
            Assert.assertEquals((long)8L, (long)longVector.get(0));
            Assert.assertEquals((long)12L, (long)longVector.get(1));
            Float4Vector floagVector = (Float4Vector)vector.getVectorByType(floatTypeId);
            Assert.assertEquals((long)1L, (long)floagVector.getValueCount());
            Assert.assertEquals((float)9.0f, (float)floagVector.get(0), (float)0.0f);
        }
    }

    private static NullableIntHolder newIntHolder(int value) {
        NullableIntHolder holder = new NullableIntHolder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }

    private static NullableBitHolder newBitHolder(boolean value) {
        NullableBitHolder holder = new NullableBitHolder();
        holder.isSet = 1;
        holder.value = value ? 1 : 0;
        return holder;
    }

    private static NullableFloat4Holder newFloat4Holder(float value) {
        NullableFloat4Holder holder = new NullableFloat4Holder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }
}

