/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.time.Duration;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.holders.NullableDurationHolder;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDurationVector {
    RootAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() {
        this.allocator.close();
    }

    @Test
    public void testSecBasics() {
        try (DurationVector secVector = TestUtils.newVector(DurationVector.class, "second", (ArrowType)new ArrowType.Duration(TimeUnit.SECOND), (BufferAllocator)this.allocator);){
            secVector.allocateNew();
            secVector.setNull(0);
            secVector.setSafe(1, 1000L);
            secVector.setValueCount(2);
            Assert.assertNull((Object)secVector.getObject(0));
            Assert.assertEquals((Object)Duration.ofSeconds(1000L), (Object)secVector.getObject(1));
            Assert.assertNull((Object)secVector.getAsStringBuilder(0));
            Assert.assertEquals((Object)"PT16M40S", (Object)secVector.getAsStringBuilder(1).toString());
            NullableDurationHolder holder = new NullableDurationHolder();
            secVector.get(0, holder);
            Assert.assertEquals((long)0L, (long)holder.isSet);
            secVector.get(1, holder);
            Assert.assertEquals((long)1L, (long)holder.isSet);
            Assert.assertEquals((long)1000L, (long)holder.value);
        }
    }

    @Test
    public void testMilliBasics() {
        try (DurationVector milliVector = TestUtils.newVector(DurationVector.class, "nanos", (ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND), (BufferAllocator)this.allocator);){
            milliVector.allocateNew();
            milliVector.setNull(0);
            milliVector.setSafe(1, 1000L);
            milliVector.setValueCount(2);
            Assert.assertNull((Object)milliVector.getObject(0));
            Assert.assertEquals((Object)Duration.ofSeconds(1L), (Object)milliVector.getObject(1));
            Assert.assertNull((Object)milliVector.getAsStringBuilder(0));
            Assert.assertEquals((Object)"PT1S", (Object)milliVector.getAsStringBuilder(1).toString());
            NullableDurationHolder holder = new NullableDurationHolder();
            milliVector.get(0, holder);
            Assert.assertEquals((long)0L, (long)holder.isSet);
            milliVector.get(1, holder);
            Assert.assertEquals((long)1L, (long)holder.isSet);
            Assert.assertEquals((long)1000L, (long)holder.value);
        }
    }

    @Test
    public void testMicroBasics() {
        try (DurationVector microVector = TestUtils.newVector(DurationVector.class, "micro", (ArrowType)new ArrowType.Duration(TimeUnit.MICROSECOND), (BufferAllocator)this.allocator);){
            microVector.allocateNew();
            microVector.setNull(0);
            microVector.setSafe(1, 1000L);
            microVector.setValueCount(2);
            Assert.assertNull((Object)microVector.getObject(0));
            Assert.assertEquals((Object)Duration.ofMillis(1L), (Object)microVector.getObject(1));
            Assert.assertNull((Object)microVector.getAsStringBuilder(0));
            Assert.assertEquals((Object)"PT0.001S", (Object)microVector.getAsStringBuilder(1).toString());
            NullableDurationHolder holder = new NullableDurationHolder();
            microVector.get(0, holder);
            Assert.assertEquals((long)0L, (long)holder.isSet);
            microVector.get(1, holder);
            Assert.assertEquals((long)1L, (long)holder.isSet);
            Assert.assertEquals((long)1000L, (long)holder.value);
        }
    }

    @Test
    public void testNanosBasics() {
        try (DurationVector nanoVector = TestUtils.newVector(DurationVector.class, "nanos", (ArrowType)new ArrowType.Duration(TimeUnit.NANOSECOND), (BufferAllocator)this.allocator);){
            nanoVector.allocateNew();
            nanoVector.setNull(0);
            nanoVector.setSafe(1, 1000000L);
            nanoVector.setValueCount(2);
            Assert.assertNull((Object)nanoVector.getObject(0));
            Assert.assertEquals((Object)Duration.ofMillis(1L), (Object)nanoVector.getObject(1));
            Assert.assertNull((Object)nanoVector.getAsStringBuilder(0));
            Assert.assertEquals((Object)"PT0.001S", (Object)nanoVector.getAsStringBuilder(1).toString());
            NullableDurationHolder holder = new NullableDurationHolder();
            nanoVector.get(0, holder);
            Assert.assertEquals((long)0L, (long)holder.isSet);
            nanoVector.get(1, holder);
            Assert.assertEquals((long)1L, (long)holder.isSet);
            Assert.assertEquals((long)1000000L, (long)holder.value);
        }
    }
}

