/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.VectorWithOrdinal;
import org.apache.arrow.vector.complex.impl.UnionWriter;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnionVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testUnionVector() throws Exception {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        try (UnionVector unionVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            unionVector.allocateNew();
            unionVector.setType(0, Types.MinorType.UINT4);
            unionVector.setSafe(0, uInt4Holder);
            unionVector.setType(2, Types.MinorType.UINT4);
            unionVector.setSafe(2, uInt4Holder);
            unionVector.setValueCount(4);
            Assert.assertEquals((long)4L, (long)unionVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)unionVector.isNull(0));
            Assert.assertEquals((Object)100, (Object)unionVector.getObject(0));
            Assert.assertNull((Object)unionVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)unionVector.isNull(2));
            Assert.assertEquals((Object)100, (Object)unionVector.getObject(2));
            Assert.assertNull((Object)unionVector.getObject(3));
        }
    }

    @Test
    public void testUnionVectorMapValue() throws Exception {
        try (UnionVector unionVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            unionVector.allocateNew();
            UnionWriter writer = (UnionWriter)unionVector.getWriter();
            writer.setPosition(0);
            writer.writeNull();
            writer.setPosition(1);
            writer.startMap();
            writer.startEntry();
            writer.key().integer().writeInt(1);
            writer.value().integer().writeInt(2);
            writer.endEntry();
            writer.startEntry();
            writer.key().integer().writeInt(3);
            writer.value().integer().writeInt(4);
            writer.endEntry();
            writer.startEntry();
            writer.key().integer().writeInt(5);
            writer.endEntry();
            writer.endMap();
            unionVector.setValueCount(2);
            Assert.assertEquals((long)2L, (long)unionVector.getValueCount());
            Assert.assertNull((Object)unionVector.getObject(0));
            List resultList = (List)unionVector.getObject(1);
            Assert.assertEquals((long)3L, (long)resultList.size());
            Map resultMap = (Map)resultList.get(0);
            Assert.assertEquals((long)1L, (long)((Integer)resultMap.get("key")).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)resultMap.get("value")).intValue());
            resultMap = (Map)resultList.get(1);
            Assert.assertEquals((long)3L, (long)((Integer)resultMap.get("key")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)resultMap.get("value")).intValue());
            resultMap = (Map)resultList.get(2);
            Assert.assertEquals((long)5L, (long)((Integer)resultMap.get("key")).intValue());
            Assert.assertNull(resultMap.get("value"));
        }
    }

    @Test
    public void testTransfer() throws Exception {
        try (UnionVector srcVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            srcVector.allocateNew();
            srcVector.setType(0, Types.MinorType.INT);
            srcVector.setSafe(0, TestUnionVector.newIntHolder(5));
            srcVector.setType(1, Types.MinorType.BIT);
            srcVector.setSafe(1, TestUnionVector.newBitHolder(false));
            srcVector.setType(3, Types.MinorType.INT);
            srcVector.setSafe(3, TestUnionVector.newIntHolder(10));
            srcVector.setType(5, Types.MinorType.BIT);
            srcVector.setSafe(5, TestUnionVector.newBitHolder(false));
            srcVector.setValueCount(6);
            try (UnionVector destVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                TransferPair pair = srcVector.makeTransferPair((ValueVector)destVector);
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                pair.transfer();
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                Assert.assertEquals((long)6L, (long)destVector.getValueCount());
                Assert.assertFalse((boolean)destVector.isNull(0));
                Assert.assertEquals((Object)5, (Object)destVector.getObject(0));
                Assert.assertFalse((boolean)destVector.isNull(1));
                Assert.assertEquals((Object)false, (Object)destVector.getObject(1));
                Assert.assertNull((Object)destVector.getObject(2));
                Assert.assertFalse((boolean)destVector.isNull(3));
                Assert.assertEquals((Object)10, (Object)destVector.getObject(3));
                Assert.assertNull((Object)destVector.getObject(4));
                Assert.assertFalse((boolean)destVector.isNull(5));
                Assert.assertEquals((Object)false, (Object)destVector.getObject(5));
            }
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (UnionVector sourceVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            sourceVector.allocateNew();
            sourceVector.setType(0, Types.MinorType.INT);
            sourceVector.setSafe(0, TestUnionVector.newIntHolder(5));
            sourceVector.setType(1, Types.MinorType.INT);
            sourceVector.setSafe(1, TestUnionVector.newIntHolder(10));
            sourceVector.setType(2, Types.MinorType.INT);
            sourceVector.setSafe(2, TestUnionVector.newIntHolder(15));
            sourceVector.setType(3, Types.MinorType.INT);
            sourceVector.setSafe(3, TestUnionVector.newIntHolder(20));
            sourceVector.setType(4, Types.MinorType.INT);
            sourceVector.setSafe(4, TestUnionVector.newIntHolder(25));
            sourceVector.setType(5, Types.MinorType.INT);
            sourceVector.setSafe(5, TestUnionVector.newIntHolder(30));
            sourceVector.setType(6, Types.MinorType.INT);
            sourceVector.setSafe(6, TestUnionVector.newIntHolder(35));
            sourceVector.setType(7, Types.MinorType.INT);
            sourceVector.setSafe(7, TestUnionVector.newIntHolder(40));
            sourceVector.setType(8, Types.MinorType.INT);
            sourceVector.setSafe(8, TestUnionVector.newIntHolder(45));
            sourceVector.setType(9, Types.MinorType.INT);
            sourceVector.setSafe(9, TestUnionVector.newIntHolder(50));
            sourceVector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceVector.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(1));
            Assert.assertEquals((Object)10, (Object)sourceVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(2));
            Assert.assertEquals((Object)15, (Object)sourceVector.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(3));
            Assert.assertEquals((Object)20, (Object)sourceVector.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(4));
            Assert.assertEquals((Object)25, (Object)sourceVector.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(5));
            Assert.assertEquals((Object)30, (Object)sourceVector.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(6));
            Assert.assertEquals((Object)35, (Object)sourceVector.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(7));
            Assert.assertEquals((Object)40, (Object)sourceVector.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(8));
            Assert.assertEquals((Object)45, (Object)sourceVector.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(9));
            Assert.assertEquals((Object)50, (Object)sourceVector.getObject(9));
            try (UnionVector toVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 3}, {3, 1}, {4, 2}, {6, 1}, {7, 1}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different data at indexes: " + (start + i) + "and " + i), (Object)sourceVector.getObject(start + i), (Object)toVector.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSplitAndTransferWithMixedVectors() throws Exception {
        try (UnionVector sourceVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            sourceVector.allocateNew();
            sourceVector.setType(0, Types.MinorType.INT);
            sourceVector.setSafe(0, TestUnionVector.newIntHolder(5));
            sourceVector.setType(1, Types.MinorType.FLOAT4);
            sourceVector.setSafe(1, TestUnionVector.newFloat4Holder(5.5f));
            sourceVector.setType(2, Types.MinorType.INT);
            sourceVector.setSafe(2, TestUnionVector.newIntHolder(10));
            sourceVector.setType(3, Types.MinorType.FLOAT4);
            sourceVector.setSafe(3, TestUnionVector.newFloat4Holder(10.5f));
            sourceVector.setType(4, Types.MinorType.INT);
            sourceVector.setSafe(4, TestUnionVector.newIntHolder(15));
            sourceVector.setType(5, Types.MinorType.FLOAT4);
            sourceVector.setSafe(5, TestUnionVector.newFloat4Holder(15.5f));
            sourceVector.setType(6, Types.MinorType.INT);
            sourceVector.setSafe(6, TestUnionVector.newIntHolder(20));
            sourceVector.setType(7, Types.MinorType.FLOAT4);
            sourceVector.setSafe(7, TestUnionVector.newFloat4Holder(20.5f));
            sourceVector.setType(8, Types.MinorType.INT);
            sourceVector.setSafe(8, TestUnionVector.newIntHolder(30));
            sourceVector.setType(9, Types.MinorType.FLOAT4);
            sourceVector.setSafe(9, TestUnionVector.newFloat4Holder(30.5f));
            sourceVector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceVector.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceVector.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(1));
            Assert.assertEquals((Object)Float.valueOf(5.5f), (Object)sourceVector.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(2));
            Assert.assertEquals((Object)10, (Object)sourceVector.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(3));
            Assert.assertEquals((Object)Float.valueOf(10.5f), (Object)sourceVector.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(4));
            Assert.assertEquals((Object)15, (Object)sourceVector.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(5));
            Assert.assertEquals((Object)Float.valueOf(15.5f), (Object)sourceVector.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(6));
            Assert.assertEquals((Object)20, (Object)sourceVector.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(7));
            Assert.assertEquals((Object)Float.valueOf(20.5f), (Object)sourceVector.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(8));
            Assert.assertEquals((Object)30, (Object)sourceVector.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceVector.isNull(9));
            Assert.assertEquals((Object)Float.valueOf(30.5f), (Object)sourceVector.getObject(9));
            try (UnionVector toVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {2, 1}, {3, 2}, {5, 3}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different values at index: " + i), (Object)sourceVector.getObject(start + i), (Object)toVector.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testGetFieldTypeInfo() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        int[] typeIds = new int[]{Types.MinorType.INT.ordinal(), Types.MinorType.VARCHAR.ordinal()};
        ArrayList<Field> children = new ArrayList<Field>();
        children.add(new Field("int", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null));
        children.add(new Field("varchar", FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null));
        FieldType fieldType = new FieldType(false, (ArrowType)new ArrowType.Union(UnionMode.Sparse, typeIds), null, metadata);
        Field field = new Field("union", fieldType, children);
        Types.MinorType minorType = Types.MinorType.UNION;
        UnionVector vector = (UnionVector)minorType.getNewVector(field, this.allocator, null);
        vector.initializeChildrenFromFields(children);
        Assert.assertTrue((boolean)vector.getField().equals((Object)field));
        Assert.assertEquals((long)vector.size(), (long)2L);
        VectorWithOrdinal intChild = vector.getChildVectorWithOrdinal("int");
        Assert.assertEquals((long)intChild.ordinal, (long)0L);
        Assert.assertEquals((Object)intChild.vector.getField(), children.get(0));
        VectorWithOrdinal varcharChild = vector.getChildVectorWithOrdinal("varchar");
        Assert.assertEquals((long)varcharChild.ordinal, (long)1L);
        Assert.assertEquals((Object)varcharChild.vector.getField(), children.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBufferAddress() throws Exception {
        try (UnionVector vector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            boolean error = false;
            vector.allocateNew();
            vector.setType(0, Types.MinorType.INT);
            vector.setSafe(0, TestUnionVector.newIntHolder(5));
            vector.setType(1, Types.MinorType.FLOAT4);
            vector.setSafe(1, TestUnionVector.newFloat4Holder(5.5f));
            vector.setType(2, Types.MinorType.INT);
            vector.setSafe(2, TestUnionVector.newIntHolder(10));
            vector.setType(3, Types.MinorType.FLOAT4);
            vector.setSafe(3, TestUnionVector.newFloat4Holder(10.5f));
            vector.setValueCount(10);
            Assert.assertEquals((long)10L, (long)vector.getValueCount());
            Assert.assertEquals((Object)false, (Object)vector.isNull(0));
            Assert.assertEquals((Object)5, (Object)vector.getObject(0));
            Assert.assertEquals((Object)false, (Object)vector.isNull(1));
            Assert.assertEquals((Object)Float.valueOf(5.5f), (Object)vector.getObject(1));
            Assert.assertEquals((Object)false, (Object)vector.isNull(2));
            Assert.assertEquals((Object)10, (Object)vector.getObject(2));
            Assert.assertEquals((Object)false, (Object)vector.isNull(3));
            Assert.assertEquals((Object)Float.valueOf(10.5f), (Object)vector.getObject(3));
            List buffers = vector.getFieldBuffers();
            try {
                long l = vector.getOffsetBufferAddress();
            }
            catch (UnsupportedOperationException ue) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
                error = false;
            }
            try {
                long ue = vector.getDataBufferAddress();
            }
            catch (UnsupportedOperationException ue) {
                error = true;
            }
            finally {
                Assert.assertTrue((boolean)error);
            }
            Assert.assertEquals((long)1L, (long)buffers.size());
        }
    }

    @Test
    public void testSetGetNull() {
        try (UnionVector srcVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            srcVector.allocateNew();
            NullableIntHolder holder = new NullableIntHolder();
            holder.isSet = 1;
            holder.value = 5;
            srcVector.setType(0, Types.MinorType.INT);
            srcVector.setSafe(0, holder);
            Assert.assertFalse((boolean)srcVector.isNull(0));
            holder.isSet = 0;
            srcVector.setSafe(0, holder);
            Assert.assertNull((Object)srcVector.getObject(0));
        }
    }

    private static NullableIntHolder newIntHolder(int value) {
        NullableIntHolder holder = new NullableIntHolder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }

    private static NullableBitHolder newBitHolder(boolean value) {
        NullableBitHolder holder = new NullableBitHolder();
        holder.isSet = 1;
        holder.value = value ? 1 : 0;
        return holder;
    }

    private static NullableFloat4Holder newFloat4Holder(float value) {
        NullableFloat4Holder holder = new NullableFloat4Holder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }
}

