/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.Arrays;
import java.util.Collections;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.rounding.DefaultRoundingPolicy;
import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorAlloc {
    private BufferAllocator rootAllocator;
    private BufferAllocator policyAllocator;
    private static final int CUSTOM_SEGMENT_SIZE = 200;

    @Before
    public void init() {
        this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
        this.policyAllocator = new RootAllocator(AllocationListener.NOOP, Integer.MAX_VALUE, (RoundingPolicy)new CustomPolicy());
    }

    @After
    public void terminate() throws Exception {
        this.rootAllocator.close();
        this.policyAllocator.close();
    }

    private static Field field(String name, ArrowType type) {
        return new Field(name, new FieldType(true, type, null), Collections.emptyList());
    }

    @Test
    public void testVectorAllocWithField() {
        Schema schema = new Schema(Arrays.asList(TestVectorAlloc.field("TINYINT", Types.MinorType.TINYINT.getType()), TestVectorAlloc.field("SMALLINT", Types.MinorType.SMALLINT.getType()), TestVectorAlloc.field("INT", Types.MinorType.INT.getType()), TestVectorAlloc.field("BIGINT", Types.MinorType.BIGINT.getType()), TestVectorAlloc.field("UINT1", Types.MinorType.UINT1.getType()), TestVectorAlloc.field("UINT2", Types.MinorType.UINT2.getType()), TestVectorAlloc.field("UINT4", Types.MinorType.UINT4.getType()), TestVectorAlloc.field("UINT8", Types.MinorType.UINT8.getType()), TestVectorAlloc.field("FLOAT4", Types.MinorType.FLOAT4.getType()), TestVectorAlloc.field("FLOAT8", Types.MinorType.FLOAT8.getType()), TestVectorAlloc.field("UTF8", Types.MinorType.VARCHAR.getType()), TestVectorAlloc.field("VARBINARY", Types.MinorType.VARBINARY.getType()), TestVectorAlloc.field("BIT", Types.MinorType.BIT.getType()), TestVectorAlloc.field("DECIMAL", (ArrowType)new ArrowType.Decimal(38, 5, 128)), TestVectorAlloc.field("FIXEDSIZEBINARY", (ArrowType)new ArrowType.FixedSizeBinary(50)), TestVectorAlloc.field("DATEDAY", Types.MinorType.DATEDAY.getType()), TestVectorAlloc.field("DATEMILLI", Types.MinorType.DATEMILLI.getType()), TestVectorAlloc.field("TIMESEC", Types.MinorType.TIMESEC.getType()), TestVectorAlloc.field("TIMEMILLI", Types.MinorType.TIMEMILLI.getType()), TestVectorAlloc.field("TIMEMICRO", Types.MinorType.TIMEMICRO.getType()), TestVectorAlloc.field("TIMENANO", Types.MinorType.TIMENANO.getType()), TestVectorAlloc.field("TIMESTAMPSEC", Types.MinorType.TIMESTAMPSEC.getType()), TestVectorAlloc.field("TIMESTAMPMILLI", Types.MinorType.TIMESTAMPMILLI.getType()), TestVectorAlloc.field("TIMESTAMPMICRO", Types.MinorType.TIMESTAMPMICRO.getType()), TestVectorAlloc.field("TIMESTAMPNANO", Types.MinorType.TIMESTAMPNANO.getType()), TestVectorAlloc.field("TIMESTAMPSECTZ", (ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, "PST")), TestVectorAlloc.field("TIMESTAMPMILLITZ", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "PST")), TestVectorAlloc.field("TIMESTAMPMICROTZ", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "PST")), TestVectorAlloc.field("TIMESTAMPNANOTZ", (ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "PST")), TestVectorAlloc.field("INTERVALDAY", Types.MinorType.INTERVALDAY.getType()), TestVectorAlloc.field("INTERVALYEAR", Types.MinorType.INTERVALYEAR.getType()), TestVectorAlloc.field("DURATION", (ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND))));
        try (BufferAllocator allocator = this.rootAllocator.newChildAllocator("child", 0L, Long.MAX_VALUE);){
            for (Field field : schema.getFields()) {
                FieldVector vector = field.createVector(allocator);
                Throwable throwable = null;
                try {
                    Assert.assertEquals((Object)vector.getMinorType(), (Object)Types.getMinorTypeForArrowType((ArrowType)field.getFieldType().getType()));
                    vector.allocateNew();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (vector == null) continue;
                    TestVectorAlloc.$closeResource(throwable, (AutoCloseable)vector);
                }
            }
        }
    }

    @Test
    public void testFixedWidthVectorAllocation() {
        try (IntVector vec1 = new IntVector("vec", this.policyAllocator);
             IntVector vec2 = new IntVector("vec", this.rootAllocator);){
            Assert.assertTrue((boolean)(vec1.getAllocator().getRoundingPolicy() instanceof CustomPolicy));
            vec1.allocateNew(50);
            long totalCapacity = vec1.getValidityBuffer().capacity() + vec1.getDataBuffer().capacity();
            Assert.assertTrue((totalCapacity % 200L == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(vec2.getAllocator().getRoundingPolicy() instanceof DefaultRoundingPolicy));
            vec2.allocateNew(50);
            totalCapacity = vec2.getValidityBuffer().capacity() + vec2.getDataBuffer().capacity();
            Assert.assertEquals((long)(totalCapacity & totalCapacity - 1L), (long)0L);
        }
    }

    @Test
    public void testVariableWidthVectorAllocation() {
        try (VarCharVector vec1 = new VarCharVector("vec", this.policyAllocator);
             VarCharVector vec2 = new VarCharVector("vec", this.rootAllocator);){
            Assert.assertTrue((boolean)(vec1.getAllocator().getRoundingPolicy() instanceof CustomPolicy));
            vec1.allocateNew(50);
            long totalCapacity = vec1.getValidityBuffer().capacity() + vec1.getOffsetBuffer().capacity();
            Assert.assertTrue((totalCapacity % 200L == 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(vec2.getAllocator().getRoundingPolicy() instanceof DefaultRoundingPolicy));
            vec2.allocateNew(50);
            totalCapacity = vec2.getValidityBuffer().capacity() + vec2.getOffsetBuffer().capacity();
            Assert.assertEquals((long)(totalCapacity & totalCapacity - 1L), (long)0L);
        }
    }

    private static class CustomPolicy
    implements RoundingPolicy {
        private CustomPolicy() {
        }

        public long getRoundedSize(long requestSize) {
            return (requestSize + 200L - 1L) / 200L * 200L;
        }
    }
}

