/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.AllocationHelper;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.DataSizeRoundingUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorReAlloc {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFixedType() {
        try (UInt4Vector vector = new UInt4Vector("", this.allocator);){
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= 512 ? 1 : 0) != 0);
            int initialCapacity = vector.getValueCapacity();
            try {
                vector.set(initialCapacity, 0);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            vector.set(initialCapacity, 100);
            Assert.assertEquals((long)100L, (long)vector.get(initialCapacity));
        }
    }

    @Test
    public void testNullableType() {
        try (VarCharVector vector = new VarCharVector("", this.allocator);){
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertTrue((vector.getValueCapacity() >= 512 ? 1 : 0) != 0);
            int initialCapacity = vector.getValueCapacity();
            try {
                vector.set(initialCapacity, "foo".getBytes(StandardCharsets.UTF_8));
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertTrue((vector.getValueCapacity() >= 2 * initialCapacity ? 1 : 0) != 0);
            vector.set(initialCapacity, "foo".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)"foo", (Object)new String(vector.get(initialCapacity), StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testListType() {
        try (ListVector vector = ListVector.empty((String)"", (BufferAllocator)this.allocator);){
            vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            try {
                vector.getInnerValueCountAt(2014);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetBuffer().getInt(8056L));
        }
    }

    @Test
    public void testStructType() {
        try (StructVector vector = StructVector.empty((String)"", (BufferAllocator)this.allocator);){
            vector.addOrGet("", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            try {
                vector.getObject(513);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            Assert.assertNull((Object)vector.getObject(513));
        }
    }

    @Test
    public void testVariableWidthTypeSetNullValues() {
        int i;
        try (VarCharVector v1 = new VarCharVector("var1", this.allocator);){
            v1.setInitialCapacity(512);
            v1.allocateNew();
            int numNullValues1 = v1.getValueCapacity() + 1;
            for (i = 0; i < numNullValues1; ++i) {
                v1.setNull(i);
            }
            Assert.assertTrue((v1.getBufferSizeFor(numNullValues1) > 0 ? 1 : 0) != 0);
        }
        var2_2 = null;
        try (LargeVarCharVector v2 = new LargeVarCharVector("var2", this.allocator);){
            v2.setInitialCapacity(512);
            v2.allocateNew();
            int numNullValues2 = v2.getValueCapacity() + 1;
            for (i = 0; i < numNullValues2; ++i) {
                v2.setNull(i);
            }
            Assert.assertTrue((v2.getBufferSizeFor(numNullValues2) > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testFixedAllocateAfterReAlloc() throws Exception {
        try (IntVector vector = new IntVector("", this.allocator);){
            vector.allocateNewSafe();
            vector.reAlloc();
            int savedValueCapacity = vector.getValueCapacity();
            vector.clear();
            vector.allocateNewSafe();
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testVariableAllocateAfterReAlloc() throws Exception {
        try (VarCharVector vector = new VarCharVector("", this.allocator);){
            vector.allocateNewSafe();
            vector.reAlloc();
            int savedValueCapacity = vector.getValueCapacity();
            long savedValueBufferSize = vector.valueBuffer.capacity();
            vector.clear();
            vector.allocateNewSafe();
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
            Assert.assertEquals((long)vector.valueBuffer.capacity(), (long)savedValueBufferSize);
        }
    }

    @Test
    public void testLargeVariableAllocateAfterReAlloc() throws Exception {
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            vector.allocateNewSafe();
            vector.reAlloc();
            int savedValueCapacity = vector.getValueCapacity();
            long savedValueBufferSize = vector.valueBuffer.capacity();
            vector.clear();
            vector.allocateNewSafe();
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
            Assert.assertEquals((long)vector.valueBuffer.capacity(), (long)savedValueBufferSize);
        }
    }

    @Test
    public void testVarCharAllocateNew() throws Exception {
        int count = 6000;
        try (VarCharVector vector = new VarCharVector("", this.allocator);){
            vector.allocateNew(6000);
            Assert.assertTrue((vector.getValidityBuffer().capacity() >= (long)DataSizeRoundingUtil.divideBy8Ceil((int)6000) ? 1 : 0) != 0);
            Assert.assertTrue((vector.getOffsetBuffer().capacity() >= 24004L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLargeVarCharAllocateNew() throws Exception {
        int count = 6000;
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            vector.allocateNew(6000);
            Assert.assertTrue((vector.getValidityBuffer().capacity() >= (long)DataSizeRoundingUtil.divideBy8Ceil((int)6000) ? 1 : 0) != 0);
            Assert.assertTrue((vector.getOffsetBuffer().capacity() >= 48008L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVarCharAllocateNewUsingHelper() throws Exception {
        int count = 6000;
        try (VarCharVector vector = new VarCharVector("", this.allocator);){
            AllocationHelper.allocateNew((ValueVector)vector, (int)6000);
            Assert.assertTrue((vector.getValidityBuffer().capacity() >= (long)DataSizeRoundingUtil.divideBy8Ceil((int)6000) ? 1 : 0) != 0);
            Assert.assertTrue((vector.getOffsetBuffer().capacity() >= 24004L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLargeVarCharAllocateNewUsingHelper() throws Exception {
        int count = 6000;
        try (LargeVarCharVector vector = new LargeVarCharVector("", this.allocator);){
            AllocationHelper.allocateNew((ValueVector)vector, (int)6000);
            Assert.assertTrue((vector.getValidityBuffer().capacity() >= (long)DataSizeRoundingUtil.divideBy8Ceil((int)6000) ? 1 : 0) != 0);
            Assert.assertTrue((vector.getOffsetBuffer().capacity() >= 48008L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFixedRepeatedClearAndSet() throws Exception {
        try (IntVector vector = new IntVector("", this.allocator);){
            vector.allocateNewSafe();
            vector.clear();
            vector.setSafe(0, 10);
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                vector.setSafe(0, 10);
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testVariableRepeatedClearAndSet() throws Exception {
        try (VarCharVector vector = new VarCharVector("", this.allocator);){
            vector.allocateNewSafe();
            vector.clear();
            vector.setSafe(0, "hello world".getBytes());
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                vector.setSafe(0, "hello world".getBytes());
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testRepeatedValueVectorClearAndSet() throws Exception {
        try (ListVector vector = new ListVector("", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null);){
            vector.allocateNewSafe();
            UnionListWriter writer = vector.getWriter();
            vector.clear();
            writer.setPosition(0);
            writer.startList();
            writer.writeInt(0);
            writer.endList();
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                writer.setPosition(0);
                writer.startList();
                writer.writeInt(i);
                writer.endList();
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testStructVectorClearAndSet() throws Exception {
        try (StructVector vector = StructVector.empty((String)"v", (BufferAllocator)this.allocator);){
            vector.allocateNewSafe();
            NullableStructWriter writer = vector.getWriter();
            vector.clear();
            writer.setPosition(0);
            writer.start();
            writer.integer("int").writeInt(0);
            writer.end();
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                writer.setPosition(0);
                writer.start();
                writer.integer("int").writeInt(i);
                writer.end();
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testFixedSizeListVectorClearAndSet() {
        try (FixedSizeListVector vector = new FixedSizeListVector("", this.allocator, FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), null);){
            vector.allocateNewSafe();
            UnionFixedSizeListWriter writer = vector.getWriter();
            vector.clear();
            writer.setPosition(0);
            writer.startList();
            writer.writeInt(0);
            writer.writeInt(1);
            writer.endList();
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                writer.setPosition(0);
                writer.startList();
                writer.writeInt(i);
                writer.writeInt(i + 1);
                writer.endList();
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testUnionVectorClearAndSet() {
        try (UnionVector vector = new UnionVector("", this.allocator, null);){
            vector.allocateNewSafe();
            NullableIntHolder holder = new NullableIntHolder();
            holder.isSet = 1;
            holder.value = 1;
            vector.clear();
            vector.setType(0, Types.MinorType.INT);
            vector.setSafe(0, holder);
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                vector.setType(0, Types.MinorType.INT);
                vector.setSafe(0, holder);
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }

    @Test
    public void testDenseUnionVectorClearAndSet() {
        try (DenseUnionVector vector = new DenseUnionVector("", this.allocator, null, null);){
            vector.allocateNewSafe();
            NullableIntHolder holder = new NullableIntHolder();
            holder.isSet = 1;
            holder.value = 1;
            byte intTypeId = vector.registerNewTypeId(Field.nullable((String)"", (ArrowType)Types.MinorType.INT.getType()));
            vector.clear();
            vector.setTypeId(0, intTypeId);
            vector.setSafe(0, holder);
            int savedValueCapacity = vector.getValueCapacity();
            for (int i = 0; i < 1024; ++i) {
                vector.clear();
                vector.setTypeId(0, intTypeId);
                vector.setSafe(0, holder);
            }
            Assert.assertEquals((long)vector.getValueCapacity(), (long)savedValueCapacity);
        }
    }
}

