/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorReset {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    private void resetVectorAndVerify(ValueVector vector, ArrowBuf[] bufs) {
        int i;
        long[] sizeBefore = new long[bufs.length];
        for (i = 0; i < bufs.length; ++i) {
            sizeBefore[i] = bufs[i].capacity();
        }
        vector.reset();
        for (i = 0; i < bufs.length; ++i) {
            Assert.assertEquals((long)sizeBefore[i], (long)bufs[i].capacity());
            this.verifyBufferZeroed(bufs[i]);
        }
        Assert.assertEquals((long)0L, (long)vector.getValueCount());
    }

    private void verifyBufferZeroed(ArrowBuf buf) {
        int i = 0;
        while ((long)i < buf.capacity()) {
            Assert.assertTrue((0 == buf.getByte((long)i) ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testFixedTypeReset() {
        try (UInt4Vector vector = new UInt4Vector("UInt4", this.allocator);){
            vector.allocateNewSafe();
            vector.setNull(0);
            vector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)vector, vector.getBuffers(false));
        }
    }

    @Test
    public void testVariableTypeReset() {
        try (VarCharVector vector = new VarCharVector("VarChar", this.allocator);){
            vector.allocateNewSafe();
            vector.set(0, "a".getBytes(StandardCharsets.UTF_8));
            vector.setLastSet(0);
            vector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)vector, vector.getBuffers(false));
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
        }
    }

    @Test
    public void testLargeVariableTypeReset() {
        try (LargeVarCharVector vector = new LargeVarCharVector("LargeVarChar", this.allocator);){
            vector.allocateNewSafe();
            vector.set(0, "a".getBytes(StandardCharsets.UTF_8));
            vector.setLastSet(0);
            vector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)vector, vector.getBuffers(false));
            Assert.assertEquals((long)-1L, (long)vector.getLastSet());
        }
    }

    @Test
    public void testListTypeReset() {
        try (ListVector variableList = new ListVector("VarList", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null);
             FixedSizeListVector fixedList = new FixedSizeListVector("FixedList", this.allocator, FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), null);){
            variableList.allocateNewSafe();
            variableList.startNewValue(0);
            variableList.endValue(0, 0);
            variableList.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)variableList, variableList.getBuffers(false));
            Assert.assertEquals((long)-1L, (long)variableList.getLastSet());
            fixedList.allocateNewSafe();
            fixedList.setNull(0);
            fixedList.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)fixedList, fixedList.getBuffers(false));
        }
    }

    @Test
    public void testStructTypeReset() {
        try (NonNullableStructVector nonNullableStructVector = new NonNullableStructVector("Struct", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null);
             StructVector structVector = new StructVector("NullableStruct", this.allocator, FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null);){
            nonNullableStructVector.allocateNewSafe();
            IntVector structChild = (IntVector)nonNullableStructVector.addOrGet("child", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            structChild.setNull(0);
            nonNullableStructVector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)nonNullableStructVector, nonNullableStructVector.getBuffers(false));
            structVector.allocateNewSafe();
            structVector.setNull(0);
            structVector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)structVector, structVector.getBuffers(false));
        }
    }

    @Test
    public void testUnionTypeReset() {
        try (UnionVector vector = new UnionVector("Union", this.allocator, null);
             IntVector dataVector = new IntVector("Int", this.allocator);){
            vector.getBufferSize();
            vector.allocateNewSafe();
            dataVector.allocateNewSafe();
            vector.addVector((FieldVector)dataVector);
            dataVector.setNull(0);
            vector.setValueCount(1);
            this.resetVectorAndVerify((ValueVector)vector, vector.getBuffers(false));
        }
    }
}

