/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.compare;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.compare.TypeEqualsVisitor;
import org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTypeEqualsVisitor {
    private BufferAllocator allocator;
    private static final Charset utf8Charset = Charset.forName("UTF-8");
    private static final byte[] STR1 = "AAAAA1".getBytes(utf8Charset);
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes(utf8Charset);
    private static final byte[] STR3 = "CCCC3".getBytes(utf8Charset);

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testTypeEqualsWithName() {
        try (IntVector right = new IntVector("int", this.allocator);
             IntVector left1 = new IntVector("int", this.allocator);
             IntVector left2 = new IntVector("int2", this.allocator);){
            TypeEqualsVisitor visitor = new TypeEqualsVisitor((ValueVector)right);
            Assert.assertTrue((boolean)visitor.equals((ValueVector)left1));
            Assert.assertFalse((boolean)visitor.equals((ValueVector)left2));
        }
    }

    @Test
    public void testTypeEqualsWithMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        FieldType typeWithoutMeta = new FieldType(true, (ArrowType)new ArrowType.Int(32, true), null, null);
        FieldType typeWithMeta = new FieldType(true, (ArrowType)new ArrowType.Int(32, true), null, metadata);
        try (IntVector right = (IntVector)typeWithoutMeta.createNewSingleVector("int", this.allocator, null);
             IntVector left1 = (IntVector)typeWithoutMeta.createNewSingleVector("int", this.allocator, null);
             IntVector left2 = (IntVector)typeWithMeta.createNewSingleVector("int", this.allocator, null);){
            TypeEqualsVisitor visitor = new TypeEqualsVisitor((ValueVector)right);
            Assert.assertTrue((boolean)visitor.equals((ValueVector)left1));
            Assert.assertFalse((boolean)visitor.equals((ValueVector)left2));
        }
    }

    @Test
    public void testListTypeEquals() {
        try (ListVector right = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector left1 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);
             ListVector left2 = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            right.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Utf8()));
            left1.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.Utf8()));
            left2.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.FixedSizeBinary(2)));
            TypeEqualsVisitor visitor = new TypeEqualsVisitor((ValueVector)right);
            Assert.assertTrue((boolean)visitor.equals((ValueVector)left1));
            Assert.assertFalse((boolean)visitor.equals((ValueVector)left2));
        }
    }

    @Test
    public void testStructTypeEquals() {
        try (StructVector right = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector left1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);
             StructVector left2 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            right.addOrGet("child", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            left1.addOrGet("child", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            left2.addOrGet("child2", FieldType.nullable((ArrowType)new ArrowType.Utf8()), VarCharVector.class);
            TypeEqualsVisitor visitor = new TypeEqualsVisitor((ValueVector)right);
            Assert.assertTrue((boolean)visitor.equals((ValueVector)left1));
            Assert.assertFalse((boolean)visitor.equals((ValueVector)left2));
        }
    }

    @Test
    public void testUnionTypeEquals() {
        try (UnionVector right = new UnionVector("union", this.allocator, null);
             UnionVector left1 = new UnionVector("union", this.allocator, null);
             UnionVector left2 = new UnionVector("union", this.allocator, null);){
            right.addVector((FieldVector)new IntVector("int", this.allocator));
            left1.addVector((FieldVector)new IntVector("int", this.allocator));
            left2.addVector((FieldVector)new BigIntVector("bigint", this.allocator));
            TypeEqualsVisitor visitor = new TypeEqualsVisitor((ValueVector)right);
            Assert.assertTrue((boolean)visitor.equals((ValueVector)left1));
            Assert.assertFalse((boolean)visitor.equals((ValueVector)left2));
        }
    }

    @Test
    public void testDenseUnionTypeEquals() {
        try (DenseUnionVector vector1 = new DenseUnionVector("vector1", this.allocator, null, null);
             DenseUnionVector vector2 = new DenseUnionVector("vector2", this.allocator, null, null);){
            vector1.allocateNew();
            vector2.allocateNew();
            byte intTypeId = vector1.registerNewTypeId(Field.nullable((String)"int", (ArrowType)Types.MinorType.INT.getType()));
            byte longTypeId = vector1.registerNewTypeId(Field.nullable((String)"long", (ArrowType)Types.MinorType.BIGINT.getType()));
            byte floatTypeId = vector1.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            byte doubleTypeId = vector1.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector1.addVector(floatTypeId, (FieldVector)new Float4Vector("", this.allocator));
            vector1.addVector(longTypeId, (FieldVector)new BigIntVector("", this.allocator));
            vector1.addVector(intTypeId, (FieldVector)new IntVector("", this.allocator));
            vector1.addVector(doubleTypeId, (FieldVector)new Float8Vector("", this.allocator));
            intTypeId = vector2.registerNewTypeId(Field.nullable((String)"int", (ArrowType)Types.MinorType.INT.getType()));
            longTypeId = vector2.registerNewTypeId(Field.nullable((String)"long", (ArrowType)Types.MinorType.BIGINT.getType()));
            floatTypeId = vector2.registerNewTypeId(Field.nullable((String)"float", (ArrowType)Types.MinorType.FLOAT4.getType()));
            doubleTypeId = vector2.registerNewTypeId(Field.nullable((String)"double", (ArrowType)Types.MinorType.FLOAT8.getType()));
            vector2.addVector(intTypeId, (FieldVector)new IntVector("", this.allocator));
            vector2.addVector(floatTypeId, (FieldVector)new Float4Vector("", this.allocator));
            vector2.addVector(doubleTypeId, (FieldVector)new Float8Vector("", this.allocator));
            vector2.addVector(longTypeId, (FieldVector)new BigIntVector("", this.allocator));
            TypeEqualsVisitor typeVisitor = new TypeEqualsVisitor((ValueVector)vector2, false, true);
            Assert.assertTrue((boolean)typeVisitor.equals((ValueVector)vector1));
            typeVisitor = new TypeEqualsVisitor((ValueVector)vector2, true, true);
            Assert.assertFalse((boolean)typeVisitor.equals((ValueVector)vector1));
        }
    }
}

