/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractStructVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.PromotableWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPromotableWriter {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testPromoteToUnion() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.setPosition(0);
            writer.bit("A").writeBit(0);
            writer.setPosition(1);
            writer.bit("A").writeBit(1);
            writer.decimal("dec", 10, 10);
            writer.setPosition(2);
            writer.integer("A").writeInt(10);
            writer.setPosition(4);
            writer.integer("A").writeInt(100);
            writer.end();
            container.setValueCount(5);
            UnionVector uv = (UnionVector)v.getChild("A", UnionVector.class);
            Assert.assertFalse((String)"0 shouldn't be null", (boolean)uv.isNull(0));
            Assert.assertEquals((Object)false, (Object)uv.getObject(0));
            Assert.assertFalse((String)"1 shouldn't be null", (boolean)uv.isNull(1));
            Assert.assertEquals((Object)true, (Object)uv.getObject(1));
            Assert.assertFalse((String)"2 shouldn't be null", (boolean)uv.isNull(2));
            Assert.assertEquals((Object)10, (Object)uv.getObject(2));
            Assert.assertNull((String)"3 should be null", (Object)uv.getObject(3));
            Assert.assertFalse((String)"4 shouldn't be null", (boolean)uv.isNull(4));
            Assert.assertEquals((Object)100, (Object)uv.getObject(4));
            container.clear();
            container.allocateNew();
            ComplexWriterImpl newWriter = new ComplexWriterImpl(EMPTY_SCHEMA_PATH, container);
            BaseWriter.StructWriter newStructWriter = newWriter.rootAsStruct();
            newStructWriter.start();
            newStructWriter.setPosition(2);
            newStructWriter.integer("A").writeInt(10);
            Field childField1 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0);
            Field childField2 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(1);
            Assert.assertEquals((String)("Child field should be union type: " + childField1.getName()), (Object)ArrowType.ArrowTypeID.Union, (Object)childField1.getType().getTypeID());
            Assert.assertEquals((String)("Child field should be decimal type: " + childField2.getName()), (Object)ArrowType.ArrowTypeID.Decimal, (Object)childField2.getType().getTypeID());
        }
    }

    @Test
    public void testNoPromoteToUnionWithNull() throws Exception {
        try (NonNullableStructVector container = NonNullableStructVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             StructVector v = container.addOrGetStruct("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractStructVector)container);){
            container.allocateNew();
            writer.start();
            writer.list("list").startList();
            writer.list("list").endList();
            writer.end();
            FieldType childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            ListVector lv = ListVector.empty((String)"name", (BufferAllocator)this.allocator);
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.NULL.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.NULL.getType());
            writer.start();
            writer.list("list").startList();
            writer.list("list").float4().writeFloat4(1.36f);
            writer.list("list").endList();
            writer.end();
            container.setValueCount(2);
            childTypeOfListInContainer = ((Field)((Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0)).getChildren().get(0)).getFieldType();
            lv.addOrGetVector(childTypeOfListInContainer);
            Assert.assertEquals((Object)childTypeOfListInContainer.getType(), (Object)Types.MinorType.FLOAT4.getType());
            Assert.assertEquals((Object)((FieldVector)lv.getChildrenFromFields().get(0)).getMinorType().getType(), (Object)Types.MinorType.FLOAT4.getType());
            lv.close();
        }
    }
}

