/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionMapReader;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.DateMilliWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.TimeMilliWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import org.apache.arrow.vector.complex.writer.TimeStampNanoWriter;
import org.apache.arrow.vector.complex.writer.UInt1Writer;
import org.apache.arrow.vector.complex.writer.UInt2Writer;
import org.apache.arrow.vector.complex.writer.UInt4Writer;
import org.apache.arrow.vector.complex.writer.UInt8Writer;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFileTest.class);
    protected static final int COUNT = 10;
    protected BufferAllocator allocator;
    private static short[] uint1Values = new short[]{0, 255, 1, 128, 2};
    private static char[] uint2Values = new char[]{'\u0000', '\uffff', '\u0001', '\ufffe', '\u0002'};
    private static long[] uint4Values = new long[]{0L, 0x80000000L, 1L, 0xFFFFFFFEL, 2L};
    private static BigInteger[] uint8Values = new BigInteger[]{BigInteger.valueOf(0L), BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)), BigInteger.valueOf(2L), BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(1L)), BigInteger.valueOf(2L)};

    @Before
    public void init() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    protected void writeData(int count, StructVector parent) {
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        IntWriter intWriter = rootWriter.integer("int");
        UInt1Writer uint1Writer = rootWriter.uInt1("uint1");
        UInt2Writer uint2Writer = rootWriter.uInt2("uint2");
        UInt4Writer uint4Writer = rootWriter.uInt4("uint4");
        UInt8Writer uint8Writer = rootWriter.uInt8("uint8");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        Float4Writer float4Writer = rootWriter.float4("float");
        for (int i = 0; i < count; ++i) {
            intWriter.setPosition(i);
            intWriter.writeInt(i);
            uint1Writer.setPosition(i);
            uint1Writer.setPosition(i);
            uint1Writer.writeUInt1((byte)uint1Values[i % uint1Values.length]);
            uint2Writer.setPosition(i);
            uint2Writer.writeUInt2(uint2Values[i % uint2Values.length]);
            uint4Writer.setPosition(i);
            uint4Writer.writeUInt4((int)uint4Values[i % uint4Values.length]);
            uint8Writer.setPosition(i);
            uint8Writer.writeUInt8(uint8Values[i % uint8Values.length].longValue());
            bigIntWriter.setPosition(i);
            bigIntWriter.writeBigInt((long)i);
            float4Writer.setPosition(i);
            float4Writer.writeFloat4(i == 0 ? Float.NaN : (float)i);
        }
        writer.setValueCount(count);
    }

    protected void validateContent(int count, VectorSchemaRoot root) {
        for (int i = 0; i < count; ++i) {
            Assert.assertEquals((Object)i, (Object)root.getVector("int").getObject(i));
            Assert.assertEquals((Object)uint1Values[i % uint1Values.length], (Object)((UInt1Vector)root.getVector("uint1")).getObjectNoOverflow(i));
            Assert.assertEquals((String)("Failed for index: " + i), (Object)Character.valueOf(uint2Values[i % uint2Values.length]), (Object)Character.valueOf(((UInt2Vector)root.getVector("uint2")).get(i)));
            Assert.assertEquals((String)("Failed for index: " + i), (Object)uint4Values[i % uint4Values.length], (Object)((UInt4Vector)root.getVector("uint4")).getObjectNoOverflow(i));
            Assert.assertEquals((String)("Failed for index: " + i), (Object)uint8Values[i % uint8Values.length], (Object)((UInt8Vector)root.getVector("uint8")).getObjectNoOverflow(i));
            Assert.assertEquals((Object)i, (Object)root.getVector("bigInt").getObject(i));
            Assert.assertEquals((Object)Float.valueOf(i == 0 ? Float.NaN : (float)i), (Object)root.getVector("float").getObject(i));
        }
    }

    protected void writeComplexData(int count, StructVector parent) {
        ArrowBuf varchar = this.allocator.buffer(3L);
        varchar.readerIndex(0L);
        varchar.setByte(0L, 97);
        varchar.setByte(1L, 98);
        varchar.setByte(2L, 99);
        varchar.writerIndex(3L);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        IntWriter intWriter = rootWriter.integer("int");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        BaseWriter.ListWriter listWriter = rootWriter.list("list");
        BaseWriter.StructWriter structWriter = rootWriter.struct("struct");
        for (int i = 0; i < count; ++i) {
            if (i % 5 != 3) {
                intWriter.setPosition(i);
                intWriter.writeInt(i);
            }
            bigIntWriter.setPosition(i);
            bigIntWriter.writeBigInt((long)i);
            listWriter.setPosition(i);
            listWriter.startList();
            for (int j = 0; j < i % 3; ++j) {
                listWriter.varChar().writeVarChar(0, 3, varchar);
            }
            listWriter.endList();
            structWriter.setPosition(i);
            structWriter.start();
            structWriter.timeStampMilli("timestamp").writeTimeStampMilli((long)i);
            structWriter.end();
        }
        writer.setValueCount(count);
        varchar.getReferenceManager().release();
    }

    public void printVectors(List<FieldVector> vectors) {
        for (FieldVector vector : vectors) {
            LOGGER.debug(vector.getField().getName());
            int valueCount = vector.getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                LOGGER.debug(String.valueOf(vector.getObject(i)));
            }
        }
    }

    protected void validateComplexContent(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        this.printVectors(root.getFieldVectors());
        for (int i = 0; i < count; ++i) {
            Object intVal = root.getVector("int").getObject(i);
            if (i % 5 != 3) {
                Assert.assertEquals((Object)i, (Object)intVal);
            } else {
                Assert.assertNull((Object)intVal);
            }
            Assert.assertEquals((Object)i, (Object)root.getVector("bigInt").getObject(i));
            Assert.assertEquals((long)(i % 3), (long)((List)root.getVector("list").getObject(i)).size());
            NullableTimeStampMilliHolder h = new NullableTimeStampMilliHolder();
            FieldReader structReader = root.getVector("struct").getReader();
            structReader.setPosition(i);
            structReader.reader("timestamp").read(h);
            Assert.assertEquals((long)i, (long)h.value);
        }
    }

    private LocalDateTime makeDateTimeFromCount(int i) {
        return LocalDateTime.of(2000 + i, 1 + i, 1 + i, i, i, i, i * 100000000 + i);
    }

    protected void writeDateTimeData(int count, StructVector parent) {
        Assert.assertTrue((count < 100 ? 1 : 0) != 0);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        DateMilliWriter dateWriter = rootWriter.dateMilli("date");
        TimeMilliWriter timeWriter = rootWriter.timeMilli("time");
        TimeStampMilliWriter timeStampMilliWriter = rootWriter.timeStampMilli("timestamp-milli");
        TimeStampMilliTZWriter timeStampMilliTZWriter = rootWriter.timeStampMilliTZ("timestamp-milliTZ", "Europe/Paris");
        TimeStampNanoWriter timeStampNanoWriter = rootWriter.timeStampNano("timestamp-nano");
        for (int i = 0; i < count; ++i) {
            LocalDateTime dt = this.makeDateTimeFromCount(i);
            dateWriter.setPosition(i);
            long dateLong = dt.toLocalDate().atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
            dateWriter.writeDateMilli(dateLong);
            timeWriter.setPosition(i);
            int milliOfDay = (int)TimeUnit.NANOSECONDS.toMillis(dt.toLocalTime().toNanoOfDay());
            timeWriter.writeTimeMilli(milliOfDay);
            timeStampMilliWriter.setPosition(i);
            timeStampMilliWriter.writeTimeStampMilli(dt.toInstant(ZoneOffset.UTC).toEpochMilli());
            timeStampMilliTZWriter.setPosition(i);
            timeStampMilliTZWriter.writeTimeStampMilliTZ(dt.atZone(ZoneId.of("Europe/Paris")).toInstant().toEpochMilli());
            timeStampNanoWriter.setPosition(i);
            long tsNanos = dt.toInstant(ZoneOffset.UTC).toEpochMilli() * 1000000L + (long)i;
            timeStampNanoWriter.writeTimeStampNano(tsNanos);
        }
        writer.setValueCount(count);
    }

    protected void validateDateTimeContent(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        this.printVectors(root.getFieldVectors());
        for (int i = 0; i < count; ++i) {
            LocalDateTime dt = this.makeDateTimeFromCount(i);
            LocalDateTime dtMilli = dt.minusNanos(i);
            LocalDateTime dateVal = ((DateMilliVector)root.getVector("date")).getObject(i);
            LocalDateTime dateExpected = dt.toLocalDate().atStartOfDay();
            Assert.assertEquals((Object)dateExpected, (Object)dateVal);
            LocalTime timeVal = ((TimeMilliVector)root.getVector("time")).getObject(i).toLocalTime();
            Assert.assertEquals((Object)dtMilli.toLocalTime(), (Object)timeVal);
            Object timestampMilliVal = root.getVector("timestamp-milli").getObject(i);
            Assert.assertEquals((Object)dtMilli, (Object)timestampMilliVal);
            Object timestampMilliTZVal = root.getVector("timestamp-milliTZ").getObject(i);
            Assert.assertEquals((Object)dt.atZone(ZoneId.of("Europe/Paris")).toInstant().toEpochMilli(), (Object)timestampMilliTZVal);
            Object timestampNanoVal = root.getVector("timestamp-nano").getObject(i);
            Assert.assertEquals((Object)dt, (Object)timestampNanoVal);
        }
    }

    protected VectorSchemaRoot writeFlatDictionaryData(BufferAllocator bufferAllocator, DictionaryProvider.MapDictionaryProvider provider) {
        VarCharVector dictionary1Vector = TestUtils.newVarCharVector("D1", bufferAllocator);
        dictionary1Vector.allocateNewSafe();
        dictionary1Vector.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        dictionary1Vector.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        dictionary1Vector.set(2, "baz".getBytes(StandardCharsets.UTF_8));
        dictionary1Vector.setValueCount(3);
        Dictionary dictionary1 = new Dictionary((FieldVector)dictionary1Vector, new DictionaryEncoding(1L, false, null));
        provider.put(dictionary1);
        VarCharVector dictionary2Vector = TestUtils.newVarCharVector("D2", bufferAllocator);
        dictionary2Vector.allocateNewSafe();
        dictionary2Vector.set(0, "micro".getBytes(StandardCharsets.UTF_8));
        dictionary2Vector.set(1, "small".getBytes(StandardCharsets.UTF_8));
        dictionary2Vector.set(2, "large".getBytes(StandardCharsets.UTF_8));
        dictionary2Vector.setValueCount(3);
        Dictionary dictionary2 = new Dictionary((FieldVector)dictionary2Vector, new DictionaryEncoding(2L, false, null));
        provider.put(dictionary2);
        VarCharVector vector1A = TestUtils.newVarCharVector("varcharA", bufferAllocator);
        vector1A.allocateNewSafe();
        vector1A.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        vector1A.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        vector1A.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        vector1A.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        vector1A.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        vector1A.setValueCount(6);
        FieldVector encodedVector1A = (FieldVector)DictionaryEncoder.encode((ValueVector)vector1A, (Dictionary)dictionary1);
        vector1A.close();
        IntVector encodedVector1B = new IntVector("varcharB", bufferAllocator);
        encodedVector1B.allocateNewSafe();
        encodedVector1B.set(0, 2);
        encodedVector1B.set(1, 1);
        encodedVector1B.set(2, 2);
        encodedVector1B.set(4, 1);
        encodedVector1B.set(5, 0);
        encodedVector1B.setValueCount(6);
        VarCharVector vector2 = TestUtils.newVarCharVector("sizes", bufferAllocator);
        vector2.allocateNewSafe();
        vector2.set(1, "large".getBytes(StandardCharsets.UTF_8));
        vector2.set(2, "small".getBytes(StandardCharsets.UTF_8));
        vector2.set(3, "small".getBytes(StandardCharsets.UTF_8));
        vector2.set(4, "large".getBytes(StandardCharsets.UTF_8));
        vector2.setValueCount(6);
        FieldVector encodedVector2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector2, (Dictionary)dictionary2);
        vector2.close();
        List<Field> fields = Arrays.asList(encodedVector1A.getField(), encodedVector1B.getField(), encodedVector2.getField());
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVector1A, encodedVector1B, encodedVector2});
        return new VectorSchemaRoot(fields, vectors, encodedVector1A.getValueCount());
    }

    protected void validateFlatDictionary(VectorSchemaRoot root, DictionaryProvider provider) {
        FieldVector vector1A = root.getVector("varcharA");
        Assert.assertNotNull((Object)vector1A);
        DictionaryEncoding encoding1A = vector1A.getField().getDictionary();
        Assert.assertNotNull((Object)encoding1A);
        Assert.assertEquals((long)1L, (long)encoding1A.getId());
        Assert.assertEquals((long)6L, (long)vector1A.getValueCount());
        Assert.assertEquals((Object)0, (Object)vector1A.getObject(0));
        Assert.assertEquals((Object)1, (Object)vector1A.getObject(1));
        Assert.assertEquals(null, (Object)vector1A.getObject(2));
        Assert.assertEquals((Object)2, (Object)vector1A.getObject(3));
        Assert.assertEquals((Object)1, (Object)vector1A.getObject(4));
        Assert.assertEquals((Object)2, (Object)vector1A.getObject(5));
        FieldVector vector1B = root.getVector("varcharB");
        Assert.assertNotNull((Object)vector1B);
        DictionaryEncoding encoding1B = vector1A.getField().getDictionary();
        Assert.assertNotNull((Object)encoding1B);
        Assert.assertTrue((boolean)encoding1A.equals((Object)encoding1B));
        Assert.assertEquals((long)1L, (long)encoding1B.getId());
        Assert.assertEquals((long)6L, (long)vector1B.getValueCount());
        Assert.assertEquals((Object)2, (Object)vector1B.getObject(0));
        Assert.assertEquals((Object)1, (Object)vector1B.getObject(1));
        Assert.assertEquals((Object)2, (Object)vector1B.getObject(2));
        Assert.assertEquals(null, (Object)vector1B.getObject(3));
        Assert.assertEquals((Object)1, (Object)vector1B.getObject(4));
        Assert.assertEquals((Object)0, (Object)vector1B.getObject(5));
        FieldVector vector2 = root.getVector("sizes");
        Assert.assertNotNull((Object)vector2);
        DictionaryEncoding encoding2 = vector2.getField().getDictionary();
        Assert.assertNotNull((Object)encoding2);
        Assert.assertEquals((long)2L, (long)encoding2.getId());
        Assert.assertEquals((long)6L, (long)vector2.getValueCount());
        Assert.assertEquals(null, (Object)vector2.getObject(0));
        Assert.assertEquals((Object)2, (Object)vector2.getObject(1));
        Assert.assertEquals((Object)1, (Object)vector2.getObject(2));
        Assert.assertEquals((Object)1, (Object)vector2.getObject(3));
        Assert.assertEquals((Object)2, (Object)vector2.getObject(4));
        Assert.assertEquals(null, (Object)vector2.getObject(5));
        Dictionary dictionary1 = provider.lookup(1L);
        Assert.assertNotNull((Object)dictionary1);
        VarCharVector dictionaryVector = (VarCharVector)dictionary1.getVector();
        Assert.assertEquals((long)3L, (long)dictionaryVector.getValueCount());
        Assert.assertEquals((Object)new Text("foo"), (Object)dictionaryVector.getObject(0));
        Assert.assertEquals((Object)new Text("bar"), (Object)dictionaryVector.getObject(1));
        Assert.assertEquals((Object)new Text("baz"), (Object)dictionaryVector.getObject(2));
        Dictionary dictionary2 = provider.lookup(2L);
        Assert.assertNotNull((Object)dictionary2);
        dictionaryVector = (VarCharVector)dictionary2.getVector();
        Assert.assertEquals((long)3L, (long)dictionaryVector.getValueCount());
        Assert.assertEquals((Object)new Text("micro"), (Object)dictionaryVector.getObject(0));
        Assert.assertEquals((Object)new Text("small"), (Object)dictionaryVector.getObject(1));
        Assert.assertEquals((Object)new Text("large"), (Object)dictionaryVector.getObject(2));
    }

    protected VectorSchemaRoot writeNestedDictionaryData(BufferAllocator bufferAllocator, DictionaryProvider.MapDictionaryProvider provider) {
        VarCharVector dictionaryVector = TestUtils.newVarCharVector("D2", bufferAllocator);
        dictionaryVector.allocateNewSafe();
        dictionaryVector.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        dictionaryVector.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        dictionaryVector.setValueCount(2);
        Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(2L, false, null));
        provider.put(dictionary);
        ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)bufferAllocator);
        DictionaryEncoding encoding = dictionary.getEncoding();
        listVector.addOrGetVector(new FieldType(true, (ArrowType)encoding.getIndexType(), encoding));
        listVector.allocateNew();
        UnionListWriter listWriter = new UnionListWriter(listVector);
        listWriter.startList();
        listWriter.writeInt(0);
        listWriter.writeInt(1);
        listWriter.endList();
        listWriter.startList();
        listWriter.writeInt(0);
        listWriter.endList();
        listWriter.startList();
        listWriter.writeInt(1);
        listWriter.endList();
        listWriter.setValueCount(3);
        List fields = Collections2.asImmutableList((Object[])new Field[]{listVector.getField()});
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{listVector});
        return new VectorSchemaRoot(fields, vectors, 3);
    }

    protected void validateNestedDictionary(VectorSchemaRoot root, DictionaryProvider provider) {
        FieldVector vector = (FieldVector)root.getFieldVectors().get(0);
        Assert.assertNotNull((Object)vector);
        Assert.assertNull((Object)vector.getField().getDictionary());
        Field nestedField = (Field)vector.getField().getChildren().get(0);
        DictionaryEncoding encoding = nestedField.getDictionary();
        Assert.assertNotNull((Object)encoding);
        Assert.assertEquals((long)2L, (long)encoding.getId());
        Assert.assertEquals((Object)new ArrowType.Int(32, true), (Object)encoding.getIndexType());
        Assert.assertEquals((long)3L, (long)vector.getValueCount());
        Assert.assertEquals(Arrays.asList(0, 1), (Object)vector.getObject(0));
        Assert.assertEquals(Arrays.asList(0), (Object)vector.getObject(1));
        Assert.assertEquals(Arrays.asList(1), (Object)vector.getObject(2));
        Dictionary dictionary = provider.lookup(2L);
        Assert.assertNotNull((Object)dictionary);
        VarCharVector dictionaryVector = (VarCharVector)dictionary.getVector();
        Assert.assertEquals((long)2L, (long)dictionaryVector.getValueCount());
        Assert.assertEquals((Object)new Text("foo"), (Object)dictionaryVector.getObject(0));
        Assert.assertEquals((Object)new Text("bar"), (Object)dictionaryVector.getObject(1));
    }

    protected VectorSchemaRoot writeDecimalData(BufferAllocator bufferAllocator) {
        DecimalVector decimalVector1 = new DecimalVector("decimal1", bufferAllocator, 10, 3);
        DecimalVector decimalVector2 = new DecimalVector("decimal2", bufferAllocator, 4, 2);
        DecimalVector decimalVector3 = new DecimalVector("decimal3", bufferAllocator, 16, 8);
        int count = 10;
        decimalVector1.allocateNew(count);
        decimalVector2.allocateNew(count);
        decimalVector3.allocateNew(count);
        for (int i = 0; i < count; ++i) {
            decimalVector1.setSafe(i, new BigDecimal(BigInteger.valueOf(i), 3));
            decimalVector2.setSafe(i, new BigDecimal(BigInteger.valueOf(i * 1024), 2));
            decimalVector3.setSafe(i, new BigDecimal(BigInteger.valueOf((long)i * 1111111111111111L), 8));
        }
        decimalVector1.setValueCount(count);
        decimalVector2.setValueCount(count);
        decimalVector3.setValueCount(count);
        List fields = Collections2.asImmutableList((Object[])new Field[]{decimalVector1.getField(), decimalVector2.getField(), decimalVector3.getField()});
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{decimalVector1, decimalVector2, decimalVector3});
        return new VectorSchemaRoot(fields, vectors, count);
    }

    protected void validateDecimalData(VectorSchemaRoot root) {
        DecimalVector decimalVector1 = (DecimalVector)root.getVector("decimal1");
        DecimalVector decimalVector2 = (DecimalVector)root.getVector("decimal2");
        DecimalVector decimalVector3 = (DecimalVector)root.getVector("decimal3");
        int count = 10;
        Assert.assertEquals((long)count, (long)root.getRowCount());
        for (int i = 0; i < count; ++i) {
            BigDecimal readValue = decimalVector1.getObject(i);
            ArrowType.Decimal type = (ArrowType.Decimal)decimalVector1.getField().getType();
            BigDecimal genValue = new BigDecimal(BigInteger.valueOf(i), type.getScale());
            Assert.assertEquals((Object)genValue, (Object)readValue);
            readValue = decimalVector2.getObject(i);
            type = (ArrowType.Decimal)decimalVector2.getField().getType();
            genValue = new BigDecimal(BigInteger.valueOf(i * 1024), type.getScale());
            Assert.assertEquals((Object)genValue, (Object)readValue);
            readValue = decimalVector3.getObject(i);
            type = (ArrowType.Decimal)decimalVector3.getField().getType();
            genValue = new BigDecimal(BigInteger.valueOf((long)i * 1111111111111111L), type.getScale());
            Assert.assertEquals((Object)genValue, (Object)readValue);
        }
    }

    protected VectorSchemaRoot writeNullData(int valueCount) {
        NullVector nullVector1 = new NullVector();
        NullVector nullVector2 = new NullVector();
        nullVector1.setValueCount(valueCount);
        nullVector2.setValueCount(valueCount);
        List fields = Collections2.asImmutableList((Object[])new Field[]{nullVector1.getField(), nullVector2.getField()});
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{nullVector1, nullVector2});
        return new VectorSchemaRoot(fields, vectors, valueCount);
    }

    protected void validateNullData(VectorSchemaRoot root, int valueCount) {
        NullVector vector1 = (NullVector)root.getFieldVectors().get(0);
        NullVector vector2 = (NullVector)root.getFieldVectors().get(1);
        Assert.assertEquals((long)valueCount, (long)vector1.getValueCount());
        Assert.assertEquals((long)valueCount, (long)vector2.getValueCount());
    }

    public void validateUnionData(int count, VectorSchemaRoot root) {
        FieldReader unionReader = root.getVector("union").getReader();
        block6: for (int i = 0; i < count; ++i) {
            unionReader.setPosition(i);
            switch (i % 4) {
                case 0: {
                    Assert.assertEquals((long)i, (long)unionReader.readInteger().intValue());
                    continue block6;
                }
                case 1: {
                    Assert.assertEquals((long)i, (long)unionReader.readLong());
                    continue block6;
                }
                case 2: {
                    Assert.assertEquals((long)(i % 3), (long)unionReader.size());
                    continue block6;
                }
                case 3: {
                    NullableTimeStampMilliHolder h = new NullableTimeStampMilliHolder();
                    unionReader.reader("timestamp").read(h);
                    Assert.assertEquals((long)i, (long)h.value);
                    continue block6;
                }
                default: {
                    assert (false) : "Unexpected value in switch statement: " + i;
                    continue block6;
                }
            }
        }
    }

    public void writeUnionData(int count, StructVector parent) {
        ArrowBuf varchar = this.allocator.buffer(3L);
        varchar.readerIndex(0L);
        varchar.setByte(0L, 97);
        varchar.setByte(1L, 98);
        varchar.setByte(2L, 99);
        varchar.writerIndex(3L);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        IntWriter intWriter = rootWriter.integer("union");
        BigIntWriter bigIntWriter = rootWriter.bigInt("union");
        BaseWriter.ListWriter listWriter = rootWriter.list("union");
        BaseWriter.StructWriter structWriter = rootWriter.struct("union");
        block6: for (int i = 0; i < count; ++i) {
            switch (i % 4) {
                case 0: {
                    intWriter.setPosition(i);
                    intWriter.writeInt(i);
                    continue block6;
                }
                case 1: {
                    bigIntWriter.setPosition(i);
                    bigIntWriter.writeBigInt((long)i);
                    continue block6;
                }
                case 2: {
                    listWriter.setPosition(i);
                    listWriter.startList();
                    for (int j = 0; j < i % 3; ++j) {
                        listWriter.varChar().writeVarChar(0, 3, varchar);
                    }
                    listWriter.endList();
                    continue block6;
                }
                case 3: {
                    structWriter.setPosition(i);
                    structWriter.start();
                    structWriter.timeStampMilli("timestamp").writeTimeStampMilli((long)i);
                    structWriter.end();
                    continue block6;
                }
                default: {
                    assert (false) : "Unexpected value in switch statement: " + i;
                    continue block6;
                }
            }
        }
        writer.setValueCount(count);
        varchar.getReferenceManager().release();
    }

    protected void writeVarBinaryData(int count, StructVector parent) {
        Assert.assertTrue((count < 100 ? 1 : 0) != 0);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
        BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
        BaseWriter.ListWriter listWriter = rootWriter.list("list");
        ArrowBuf varbin = this.allocator.buffer((long)count);
        for (int i = 0; i < count; ++i) {
            varbin.setByte((long)i, i);
            listWriter.setPosition(i);
            listWriter.startList();
            for (int j = 0; j < i % 3; ++j) {
                listWriter.varBinary().writeVarBinary(0, i + 1, varbin);
            }
            listWriter.endList();
        }
        writer.setValueCount(count);
        varbin.getReferenceManager().release();
    }

    protected void validateVarBinary(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        ListVector listVector = (ListVector)root.getVector("list");
        byte[] expectedArray = new byte[count];
        int numVarBinaryValues = 0;
        for (int i = 0; i < count; ++i) {
            expectedArray[i] = (byte)i;
            List objList = listVector.getObject(i);
            if (i % 3 == 0) {
                Assert.assertTrue((boolean)objList.isEmpty());
                continue;
            }
            byte[] expected = Arrays.copyOfRange(expectedArray, 0, i + 1);
            for (int j = 0; j < i % 3; ++j) {
                byte[] result = (byte[])objList.get(j);
                Assert.assertArrayEquals((byte[])result, (byte[])expected);
                ++numVarBinaryValues;
            }
        }
        Assert.assertEquals((long)listVector.getLastSet(), (long)(count - 1));
        VarBinaryVector binaryVector = (VarBinaryVector)listVector.getChildrenFromFields().get(0);
        Assert.assertEquals((long)binaryVector.getLastSet(), (long)(numVarBinaryValues - 1));
    }

    protected void writeBatchData(ArrowWriter writer, IntVector vector, VectorSchemaRoot root) throws IOException {
        writer.start();
        vector.setNull(0);
        vector.setSafe(1, 1);
        vector.setSafe(2, 2);
        vector.setNull(3);
        vector.setSafe(4, 1);
        vector.setValueCount(5);
        root.setRowCount(5);
        writer.writeBatch();
        vector.setNull(0);
        vector.setSafe(1, 1);
        vector.setSafe(2, 2);
        vector.setValueCount(3);
        root.setRowCount(3);
        writer.writeBatch();
        writer.end();
    }

    protected void validateBatchData(ArrowReader reader, IntVector vector) throws IOException {
        reader.loadNextBatch();
        Assert.assertEquals((long)vector.getValueCount(), (long)5L);
        Assert.assertTrue((boolean)vector.isNull(0));
        Assert.assertEquals((long)vector.get(1), (long)1L);
        Assert.assertEquals((long)vector.get(2), (long)2L);
        Assert.assertTrue((boolean)vector.isNull(3));
        Assert.assertEquals((long)vector.get(4), (long)1L);
        reader.loadNextBatch();
        Assert.assertEquals((long)vector.getValueCount(), (long)3L);
        Assert.assertTrue((boolean)vector.isNull(0));
        Assert.assertEquals((long)vector.get(1), (long)1L);
        Assert.assertEquals((long)vector.get(2), (long)2L);
    }

    protected VectorSchemaRoot writeMapData(BufferAllocator bufferAllocator) {
        MapVector mapVector = MapVector.empty((String)"map", (BufferAllocator)bufferAllocator, (boolean)false);
        MapVector sortedMapVector = MapVector.empty((String)"mapSorted", (BufferAllocator)bufferAllocator, (boolean)true);
        mapVector.allocateNew();
        sortedMapVector.allocateNew();
        UnionMapWriter mapWriter = mapVector.getWriter();
        UnionMapWriter sortedMapWriter = sortedMapVector.getWriter();
        int count = 10;
        for (int i = 0; i < 10; ++i) {
            int j;
            if (i != 1) {
                mapWriter.setPosition(i);
                mapWriter.startMap();
                if (i != 3) {
                    for (j = 0; j < i + 1; ++j) {
                        mapWriter.startEntry();
                        mapWriter.key().bigInt().writeBigInt((long)j);
                        if (i != 5) {
                            mapWriter.value().integer().writeInt(j);
                        }
                        mapWriter.endEntry();
                    }
                }
                mapWriter.endMap();
            }
            sortedMapWriter.setPosition(i);
            sortedMapWriter.startMap();
            for (j = 0; j < i + 1; ++j) {
                sortedMapWriter.startEntry();
                sortedMapWriter.key().bigInt().writeBigInt((long)j);
                sortedMapWriter.value().integer().writeInt(j);
                sortedMapWriter.endEntry();
            }
            sortedMapWriter.endMap();
        }
        mapWriter.setValueCount(10);
        sortedMapWriter.setValueCount(10);
        List fields = Collections2.asImmutableList((Object[])new Field[]{mapVector.getField(), sortedMapVector.getField()});
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{mapVector, sortedMapVector});
        return new VectorSchemaRoot(fields, vectors, 10);
    }

    protected void validateMapData(VectorSchemaRoot root) {
        MapVector mapVector = (MapVector)root.getVector("map");
        MapVector sortedMapVector = (MapVector)root.getVector("mapSorted");
        int count = 10;
        Assert.assertEquals((long)10L, (long)root.getRowCount());
        UnionMapReader mapReader = new UnionMapReader(mapVector);
        UnionMapReader sortedMapReader = new UnionMapReader(sortedMapVector);
        for (int i = 0; i < 10; ++i) {
            int j;
            mapReader.setPosition(i);
            if (i == 1) {
                Assert.assertFalse((boolean)mapReader.isSet());
            } else if (i == 3) {
                JsonStringArrayList result = (JsonStringArrayList)mapReader.readObject();
                Assert.assertTrue((boolean)result.isEmpty());
            } else {
                for (j = 0; j < i + 1; ++j) {
                    mapReader.next();
                    Assert.assertEquals((long)j, (long)mapReader.key().readLong());
                    if (i == 5) {
                        Assert.assertFalse((boolean)mapReader.value().isSet());
                        continue;
                    }
                    Assert.assertEquals((long)j, (long)mapReader.value().readInteger().intValue());
                }
            }
            sortedMapReader.setPosition(i);
            for (j = 0; j < i + 1; ++j) {
                sortedMapReader.next();
                Assert.assertEquals((long)j, (long)sortedMapReader.key().readLong());
                Assert.assertEquals((long)j, (long)sortedMapReader.value().readInteger().intValue());
            }
        }
    }

    protected VectorSchemaRoot writeListAsMapData(BufferAllocator bufferAllocator) {
        ListVector mapEntryList = ListVector.empty((String)"entryList", (BufferAllocator)bufferAllocator);
        FieldType mapEntryType = new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
        StructVector mapEntryData = new StructVector("entryData", bufferAllocator, mapEntryType, null);
        mapEntryData.addOrGet("myKey", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), BigIntVector.class);
        mapEntryData.addOrGet("myValue", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
        mapEntryList.initializeChildrenFromFields(Collections2.asImmutableList((Object[])new Field[]{mapEntryData.getField()}));
        UnionListWriter entryWriter = mapEntryList.getWriter();
        entryWriter.allocate();
        int count = 10;
        for (int i = 0; i < 10; ++i) {
            entryWriter.setPosition(i);
            entryWriter.startList();
            for (int j = 0; j < i + 1; ++j) {
                entryWriter.struct().start();
                entryWriter.struct().bigInt("myKey").writeBigInt((long)j);
                entryWriter.struct().integer("myValue").writeInt(j);
                entryWriter.struct().end();
            }
            entryWriter.endList();
        }
        entryWriter.setValueCount(10);
        MapVector mapVector = MapVector.empty((String)"map", (BufferAllocator)bufferAllocator, (boolean)false);
        mapEntryList.makeTransferPair((ValueVector)mapVector).transfer();
        List fields = Collections2.asImmutableList((Object[])new Field[]{mapVector.getField()});
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{mapVector});
        return new VectorSchemaRoot(fields, vectors, 10);
    }

    protected void validateListAsMapData(VectorSchemaRoot root) {
        MapVector sortedMapVector = (MapVector)root.getVector("map");
        int count = 10;
        Assert.assertEquals((long)10L, (long)root.getRowCount());
        UnionMapReader sortedMapReader = new UnionMapReader(sortedMapVector);
        sortedMapReader.setKeyValueNames("myKey", "myValue");
        for (int i = 0; i < 10; ++i) {
            sortedMapReader.setPosition(i);
            for (int j = 0; j < i + 1; ++j) {
                sortedMapReader.next();
                Assert.assertEquals((long)j, (long)sortedMapReader.key().readLong());
                Assert.assertEquals((long)j, (long)sortedMapReader.value().readInteger().intValue());
            }
        }
    }
}

