/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.arrow.flatbuf.Footer;
import org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.apache.arrow.vector.ipc.message.ArrowFooter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestArrowFooter {
    @Test
    public void test() {
        Schema schema = new Schema(Arrays.asList(new Field("a", FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), Collections.emptyList())));
        ArrowFooter footer = new ArrowFooter(schema, Collections.emptyList(), Collections.emptyList());
        ArrowFooter newFooter = this.roundTrip(footer);
        Assert.assertEquals((Object)footer, (Object)newFooter);
        ArrayList<ArrowBlock> ids = new ArrayList<ArrowBlock>();
        ids.add(new ArrowBlock(0L, 1, 2L));
        ids.add(new ArrowBlock(4L, 5, 6L));
        footer = new ArrowFooter(schema, ids, ids);
        Assert.assertEquals((Object)footer, (Object)this.roundTrip(footer));
    }

    private ArrowFooter roundTrip(ArrowFooter footer) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int i = footer.writeTo(builder);
        builder.finish(i);
        ByteBuffer dataBuffer = builder.dataBuffer();
        ArrowFooter newFooter = new ArrowFooter(Footer.getRootAsFooter((ByteBuffer)dataBuffer));
        return newFooter;
    }
}

