/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import com.google.flatbuffers.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.arrow.flatbuf.FieldNode;
import org.apache.arrow.flatbuf.Message;
import org.apache.arrow.flatbuf.RecordBatch;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Collections2;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.compare.TypeEqualsVisitor;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowBlock;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.apache.arrow.vector.util.DictionaryUtility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestArrowReaderWriter {
    private BufferAllocator allocator;
    private VarCharVector dictionaryVector1;
    private VarCharVector dictionaryVector2;
    private VarCharVector dictionaryVector3;
    private StructVector dictionaryVector4;
    private Dictionary dictionary1;
    private Dictionary dictionary2;
    private Dictionary dictionary3;
    private Dictionary dictionary4;
    private Schema schema;
    private Schema encodedSchema;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.dictionaryVector1 = TestUtils.newVarCharVector("D1", this.allocator);
        ValueVectorDataPopulator.setVector(this.dictionaryVector1, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8), "baz".getBytes(StandardCharsets.UTF_8)});
        this.dictionaryVector2 = TestUtils.newVarCharVector("D2", this.allocator);
        ValueVectorDataPopulator.setVector(this.dictionaryVector2, (byte[][])new byte[][]{"aa".getBytes(StandardCharsets.UTF_8), "bb".getBytes(StandardCharsets.UTF_8), "cc".getBytes(StandardCharsets.UTF_8)});
        this.dictionaryVector3 = TestUtils.newVarCharVector("D3", this.allocator);
        ValueVectorDataPopulator.setVector(this.dictionaryVector3, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8), "baz".getBytes(StandardCharsets.UTF_8), "aa".getBytes(StandardCharsets.UTF_8), "bb".getBytes(StandardCharsets.UTF_8), "cc".getBytes(StandardCharsets.UTF_8)});
        this.dictionaryVector4 = TestUtils.newVector(StructVector.class, "D4", Types.MinorType.STRUCT, this.allocator);
        HashMap<String, List<Integer>> dictionaryValues4 = new HashMap<String, List<Integer>>();
        dictionaryValues4.put("a", Arrays.asList(1, 2, 3));
        dictionaryValues4.put("b", Arrays.asList(4, 5, 6));
        ValueVectorDataPopulator.setVector(this.dictionaryVector4, dictionaryValues4);
        this.dictionary1 = new Dictionary((FieldVector)this.dictionaryVector1, new DictionaryEncoding(1L, false, null));
        this.dictionary2 = new Dictionary((FieldVector)this.dictionaryVector2, new DictionaryEncoding(2L, false, null));
        this.dictionary3 = new Dictionary((FieldVector)this.dictionaryVector3, new DictionaryEncoding(1L, false, null));
        this.dictionary4 = new Dictionary((FieldVector)this.dictionaryVector4, new DictionaryEncoding(3L, false, null));
    }

    @After
    public void terminate() throws Exception {
        this.dictionaryVector1.close();
        this.dictionaryVector2.close();
        this.dictionaryVector3.close();
        this.dictionaryVector4.close();
        this.allocator.close();
    }

    ArrowBuf buf(byte[] bytes) {
        ArrowBuf buffer = this.allocator.buffer((long)bytes.length);
        buffer.writeBytes(bytes);
        return buffer;
    }

    byte[] array(ArrowBuf buf) {
        byte[] bytes = new byte[LargeMemoryUtil.checkedCastToInt((long)buf.readableBytes())];
        buf.readBytes(bytes);
        return bytes;
    }

    @Test
    public void test() throws IOException {
        Schema schema = new Schema(Arrays.asList(new Field("testField", FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), Collections.emptyList())));
        ArrowType type = ((Field)schema.getFields().get(0)).getType();
        FieldVector vector = TestUtils.newVector(FieldVector.class, "testField", type, this.allocator);
        vector.initializeChildrenFromFields(((Field)schema.getFields().get(0)).getChildren());
        byte[] validity = new byte[]{-1, 0};
        byte[] values = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), Arrays.asList(vector), 16);
             ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));){
            ArrowBuf validityb = this.buf(validity);
            ArrowBuf valuesb = this.buf(values);
            ArrowRecordBatch batch = new ArrowRecordBatch(16, Arrays.asList(new ArrowFieldNode(16L, 8L)), Arrays.asList(validityb, valuesb));
            VectorLoader loader = new VectorLoader(root);
            loader.load(batch);
            writer.writeBatch();
            validityb.close();
            valuesb.close();
            batch.close();
        }
        byte[] byteArray = out.toByteArray();
        try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(byteArray));
             ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((Object)schema, (Object)readSchema);
            List recordBatches = reader.getRecordBlocks();
            Assert.assertEquals((long)1L, (long)recordBatches.size());
            reader.loadNextBatch();
            VectorUnloader unloader = new VectorUnloader(reader.getVectorSchemaRoot());
            ArrowRecordBatch recordBatch = unloader.getRecordBatch();
            List nodes = recordBatch.getNodes();
            Assert.assertEquals((long)1L, (long)nodes.size());
            ArrowFieldNode node = (ArrowFieldNode)nodes.get(0);
            Assert.assertEquals((long)16L, (long)node.getLength());
            Assert.assertEquals((long)8L, (long)node.getNullCount());
            List buffers = recordBatch.getBuffers();
            Assert.assertEquals((long)2L, (long)buffers.size());
            Assert.assertArrayEquals((byte[])validity, (byte[])this.array((ArrowBuf)buffers.get(0)));
            Assert.assertArrayEquals((byte[])values, (byte[])this.array((ArrowBuf)buffers.get(1)));
            ByteBuffer headerBuffer = ByteBuffer.allocate(((ArrowBlock)recordBatches.get(0)).getMetadataLength());
            headerBuffer.put(byteArray, (int)((ArrowBlock)recordBatches.get(0)).getOffset(), headerBuffer.capacity());
            headerBuffer.position(8);
            Message messageFB = Message.getRootAsMessage((ByteBuffer)headerBuffer);
            RecordBatch recordBatchFB = (RecordBatch)messageFB.header((Table)new RecordBatch());
            Assert.assertEquals((long)2L, (long)recordBatchFB.buffersLength());
            Assert.assertEquals((long)1L, (long)recordBatchFB.nodesLength());
            FieldNode nodeFB = recordBatchFB.nodes(0);
            Assert.assertEquals((long)16L, (long)nodeFB.length());
            Assert.assertEquals((long)8L, (long)nodeFB.nullCount());
            recordBatch.close();
        }
    }

    @Test
    public void testWriteReadNullVector() throws IOException {
        int valueCount = 3;
        NullVector nullVector = new NullVector();
        nullVector.setValueCount(valueCount);
        Schema schema = new Schema(Arrays.asList(nullVector.getField()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), Arrays.asList(nullVector), valueCount);
             ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));){
            ArrowRecordBatch batch = new ArrowRecordBatch(valueCount, Arrays.asList(new ArrowFieldNode((long)valueCount, 0L)), Collections.emptyList());
            VectorLoader loader = new VectorLoader(root);
            loader.load(batch);
            writer.writeBatch();
        }
        byte[] byteArray = out.toByteArray();
        try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(byteArray));
             ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((Object)schema, (Object)readSchema);
            List recordBatches = reader.getRecordBlocks();
            Assert.assertEquals((long)1L, (long)recordBatches.size());
            Assert.assertTrue((boolean)reader.loadNextBatch());
            Assert.assertEquals((long)1L, (long)reader.getVectorSchemaRoot().getFieldVectors().size());
            NullVector readNullVector = (NullVector)reader.getVectorSchemaRoot().getFieldVectors().get(0);
            Assert.assertEquals((long)valueCount, (long)readNullVector.getValueCount());
        }
    }

    @Test
    public void testWriteReadWithDictionaries() throws IOException {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        VarCharVector vector1 = TestUtils.newVarCharVector("varchar1", this.allocator);
        vector1.allocateNewSafe();
        vector1.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        vector1.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        vector1.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        vector1.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        vector1.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        vector1.setValueCount(6);
        FieldVector encodedVector1 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector1, (Dictionary)this.dictionary1);
        vector1.close();
        VarCharVector vector2 = TestUtils.newVarCharVector("varchar2", this.allocator);
        vector2.allocateNewSafe();
        vector2.set(0, "bar".getBytes(StandardCharsets.UTF_8));
        vector2.set(1, "baz".getBytes(StandardCharsets.UTF_8));
        vector2.set(2, "foo".getBytes(StandardCharsets.UTF_8));
        vector2.set(3, "foo".getBytes(StandardCharsets.UTF_8));
        vector2.set(4, "foo".getBytes(StandardCharsets.UTF_8));
        vector2.set(5, "bar".getBytes(StandardCharsets.UTF_8));
        vector2.setValueCount(6);
        FieldVector encodedVector2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector2, (Dictionary)this.dictionary1);
        vector2.close();
        List<Field> fields = Arrays.asList(encodedVector1.getField(), encodedVector2.getField());
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVector1, encodedVector2});
        try (VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, encodedVector1.getValueCount());
             ByteArrayOutputStream out = new ByteArrayOutputStream();
             ArrowFileWriter writer = new ArrowFileWriter(root, (DictionaryProvider)provider, Channels.newChannel(out));){
            writer.start();
            writer.writeBatch();
            writer.end();
            try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(out.toByteArray()));
                 ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
                Schema readSchema = reader.getVectorSchemaRoot().getSchema();
                Assert.assertEquals((Object)root.getSchema(), (Object)readSchema);
                Assert.assertEquals((long)1L, (long)reader.getDictionaryBlocks().size());
                Assert.assertEquals((long)1L, (long)reader.getRecordBlocks().size());
                reader.loadNextBatch();
                Assert.assertEquals((long)2L, (long)reader.getVectorSchemaRoot().getFieldVectors().size());
            }
        }
    }

    @Test
    public void testWriteReadWithStructDictionaries() throws IOException {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary4);
        try (StructVector vector = TestUtils.newVector(StructVector.class, "D4", Types.MinorType.STRUCT, this.allocator);){
            HashMap<String, List<Integer>> values = new HashMap<String, List<Integer>>();
            values.put("a", Arrays.asList(1, 3, 2, 3, 2, 1, 1));
            values.put("b", Arrays.asList(4, 6, 5, 6, 5, 4, 4));
            ValueVectorDataPopulator.setVector(vector, values);
            FieldVector encodedVector = (FieldVector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)this.dictionary4);
            List<Field> fields = Arrays.asList(encodedVector.getField());
            List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVector});
            try (VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, encodedVector.getValueCount());
                 ByteArrayOutputStream out = new ByteArrayOutputStream();
                 ArrowFileWriter writer = new ArrowFileWriter(root, (DictionaryProvider)provider, Channels.newChannel(out));){
                writer.start();
                writer.writeBatch();
                writer.end();
                try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(out.toByteArray()));
                     ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
                    VectorSchemaRoot readRoot = reader.getVectorSchemaRoot();
                    Schema readSchema = readRoot.getSchema();
                    Assert.assertEquals((Object)root.getSchema(), (Object)readSchema);
                    Assert.assertEquals((long)1L, (long)reader.getDictionaryBlocks().size());
                    Assert.assertEquals((long)1L, (long)reader.getRecordBlocks().size());
                    reader.loadNextBatch();
                    Assert.assertEquals((long)1L, (long)readRoot.getFieldVectors().size());
                    Assert.assertEquals((long)1L, (long)reader.getDictionaryVectors().size());
                    FieldVector readEncoded = readRoot.getVector(0);
                    Assert.assertEquals((long)encodedVector.getValueCount(), (long)readEncoded.getValueCount());
                    Assert.assertTrue((boolean)new RangeEqualsVisitor((ValueVector)encodedVector, (ValueVector)readEncoded).rangeEquals(new Range(0, 0, encodedVector.getValueCount())));
                    Map readDictionaryMap = reader.getDictionaryVectors();
                    Dictionary readDictionary = (Dictionary)readDictionaryMap.get(readEncoded.getField().getDictionary().getId());
                    Assert.assertNotNull((Object)readDictionary);
                    FieldVector readDictionaryVector = readDictionary.getVector();
                    Assert.assertEquals((long)this.dictionaryVector4.getValueCount(), (long)readDictionaryVector.getValueCount());
                    BiFunction<ValueVector, ValueVector, Boolean> typeComparatorIgnoreName = (v1, v2) -> new TypeEqualsVisitor(v1, false, true).equals(v2);
                    Assert.assertTrue((String)"Dictionary vectors are not equal", (boolean)new RangeEqualsVisitor((ValueVector)this.dictionaryVector4, (ValueVector)readDictionaryVector, typeComparatorIgnoreName).rangeEquals(new Range(0, 0, this.dictionaryVector4.getValueCount())));
                    try (ValueVector readVector = DictionaryEncoder.decode((ValueVector)readEncoded, (Dictionary)readDictionary);){
                        Assert.assertEquals((long)vector.getValueCount(), (long)readVector.getValueCount());
                        Assert.assertTrue((String)"Decoded vectors are not equal", (boolean)new RangeEqualsVisitor((ValueVector)vector, readVector, typeComparatorIgnoreName).rangeEquals(new Range(0, 0, vector.getValueCount())));
                    }
                }
            }
        }
    }

    @Test
    public void testEmptyStreamInFileIPC() throws IOException {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        VarCharVector vector = TestUtils.newVarCharVector("varchar", this.allocator);
        vector.allocateNewSafe();
        vector.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        vector.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        vector.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        vector.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        vector.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        vector.setValueCount(6);
        FieldVector encodedVector1A = (FieldVector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)this.dictionary1);
        vector.close();
        List<Field> fields = Arrays.asList(encodedVector1A.getField());
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVector1A});
        try (VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, encodedVector1A.getValueCount());
             ByteArrayOutputStream out = new ByteArrayOutputStream();
             ArrowFileWriter writer = new ArrowFileWriter(root, (DictionaryProvider)provider, Channels.newChannel(out));){
            writer.start();
            writer.end();
            try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(out.toByteArray()));
                 ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
                Schema readSchema = reader.getVectorSchemaRoot().getSchema();
                Assert.assertEquals((Object)root.getSchema(), (Object)readSchema);
                Assert.assertEquals((long)1L, (long)reader.getDictionaryVectors().size());
                Assert.assertEquals((long)0L, (long)reader.getDictionaryBlocks().size());
                Assert.assertEquals((long)0L, (long)reader.getRecordBlocks().size());
            }
        }
    }

    @Test
    public void testEmptyStreamInStreamingIPC() throws IOException {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        VarCharVector vector = TestUtils.newVarCharVector("varchar", this.allocator);
        vector.allocateNewSafe();
        vector.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        vector.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        vector.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        vector.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        vector.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        vector.setValueCount(6);
        FieldVector encodedVector = (FieldVector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)this.dictionary1);
        vector.close();
        List<Field> fields = Arrays.asList(encodedVector.getField());
        try (VectorSchemaRoot root = new VectorSchemaRoot(fields, Arrays.asList(encodedVector), encodedVector.getValueCount());
             ByteArrayOutputStream out = new ByteArrayOutputStream();
             ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, Channels.newChannel(out));){
            writer.start();
            writer.end();
            try (ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(out.toByteArray()), this.allocator);){
                Schema readSchema = reader.getVectorSchemaRoot().getSchema();
                Assert.assertEquals((Object)root.getSchema(), (Object)readSchema);
                Assert.assertEquals((long)1L, (long)reader.getDictionaryVectors().size());
                Assert.assertFalse((boolean)reader.loadNextBatch());
            }
        }
    }

    @Test
    public void testDictionaryReplacement() throws Exception {
        VarCharVector vector1 = TestUtils.newVarCharVector("varchar1", this.allocator);
        ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8), "baz".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8)});
        FieldVector encodedVector1 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector1, (Dictionary)this.dictionary1);
        VarCharVector vector2 = TestUtils.newVarCharVector("varchar2", this.allocator);
        ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "foo".getBytes(StandardCharsets.UTF_8), "foo".getBytes(StandardCharsets.UTF_8), "foo".getBytes(StandardCharsets.UTF_8)});
        FieldVector encodedVector2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector2, (Dictionary)this.dictionary1);
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        ArrayList<Field> schemaFields = new ArrayList<Field>();
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVector1.getField(), (DictionaryProvider)provider, new HashSet()));
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVector2.getField(), (DictionaryProvider)provider, new HashSet()));
        Schema schema = new Schema(schemaFields);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WriteChannel out = new WriteChannel(Channels.newChannel(outStream));
        MessageSerializer.serialize((WriteChannel)out, (Schema)schema);
        ArrayList<AutoCloseable> closeableList = new ArrayList<AutoCloseable>();
        this.serializeDictionaryBatch(out, this.dictionary3, false, closeableList);
        this.serializeDictionaryBatch(out, this.dictionary1, false, closeableList);
        this.serializeRecordBatch(out, Arrays.asList(encodedVector1, encodedVector2), closeableList);
        out.writeIntLittleEndian(0);
        try (ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(outStream.toByteArray()), this.allocator);){
            Assert.assertEquals((long)1L, (long)reader.getDictionaryVectors().size());
            Assert.assertTrue((boolean)reader.loadNextBatch());
            FieldVector dictionaryVector = ((Dictionary)reader.getDictionaryVectors().get(1L)).getVector();
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)dictionaryVector, (ValueVector)this.dictionaryVector1, null));
            Assert.assertFalse((boolean)reader.loadNextBatch());
        }
        vector1.close();
        vector2.close();
        AutoCloseables.close(closeableList);
    }

    @Test
    public void testDeltaDictionary() throws Exception {
        VarCharVector vector1 = TestUtils.newVarCharVector("varchar1", this.allocator);
        ValueVectorDataPopulator.setVector(vector1, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8), "baz".getBytes(StandardCharsets.UTF_8), "bar".getBytes(StandardCharsets.UTF_8)});
        FieldVector encodedVector1 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector1, (Dictionary)this.dictionary1);
        VarCharVector vector2 = TestUtils.newVarCharVector("varchar2", this.allocator);
        ValueVectorDataPopulator.setVector(vector2, (byte[][])new byte[][]{"foo".getBytes(StandardCharsets.UTF_8), "aa".getBytes(StandardCharsets.UTF_8), "bb".getBytes(StandardCharsets.UTF_8), "cc".getBytes(StandardCharsets.UTF_8)});
        FieldVector encodedVector2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector2, (Dictionary)this.dictionary3);
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        provider.put(this.dictionary3);
        ArrayList<Field> schemaFields = new ArrayList<Field>();
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVector1.getField(), (DictionaryProvider)provider, new HashSet()));
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVector2.getField(), (DictionaryProvider)provider, new HashSet()));
        Schema schema = new Schema(schemaFields);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WriteChannel out = new WriteChannel(Channels.newChannel(outStream));
        MessageSerializer.serialize((WriteChannel)out, (Schema)schema);
        ArrayList<AutoCloseable> closeableList = new ArrayList<AutoCloseable>();
        this.serializeDictionaryBatch(out, this.dictionary1, false, closeableList);
        Dictionary deltaDictionary = new Dictionary((FieldVector)this.dictionaryVector2, new DictionaryEncoding(1L, false, null));
        this.serializeDictionaryBatch(out, deltaDictionary, true, closeableList);
        deltaDictionary.getVector().close();
        this.serializeRecordBatch(out, Arrays.asList(encodedVector1, encodedVector2), closeableList);
        out.writeIntLittleEndian(0);
        try (ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(outStream.toByteArray()), this.allocator);){
            Assert.assertEquals((long)1L, (long)reader.getDictionaryVectors().size());
            Assert.assertTrue((boolean)reader.loadNextBatch());
            FieldVector dictionaryVector = ((Dictionary)reader.getDictionaryVectors().get(1L)).getVector();
            Assert.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)dictionaryVector, (ValueVector)this.dictionaryVector3, null));
            Assert.assertFalse((boolean)reader.loadNextBatch());
        }
        vector1.close();
        vector2.close();
        AutoCloseables.close(closeableList);
    }

    private void serializeDictionaryBatch(WriteChannel out, Dictionary dictionary, boolean isDelta, List<AutoCloseable> closeables) throws IOException {
        FieldVector dictVector = dictionary.getVector();
        VectorSchemaRoot root = new VectorSchemaRoot(Collections.singletonList(dictVector.getField()), Collections.singletonList(dictVector), dictVector.getValueCount());
        ArrowDictionaryBatch batch = new ArrowDictionaryBatch(dictionary.getEncoding().getId(), new VectorUnloader(root).getRecordBatch(), isDelta);
        MessageSerializer.serialize((WriteChannel)out, (ArrowDictionaryBatch)batch);
        closeables.add((AutoCloseable)batch);
        closeables.add((AutoCloseable)root);
    }

    private void serializeRecordBatch(WriteChannel out, List<FieldVector> vectors, List<AutoCloseable> closeables) throws IOException {
        List fields = vectors.stream().map(v -> v.getField()).collect(Collectors.toList());
        VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vectors.get(0).getValueCount());
        VectorUnloader unloader = new VectorUnloader(root);
        ArrowRecordBatch batch = unloader.getRecordBatch();
        MessageSerializer.serialize((WriteChannel)out, (ArrowRecordBatch)batch);
        closeables.add((AutoCloseable)batch);
        closeables.add((AutoCloseable)root);
    }

    @Test
    public void testReadInterleavedData() throws IOException {
        List<ArrowRecordBatch> batches = this.createRecordBatches();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WriteChannel out = new WriteChannel(Channels.newChannel(outStream));
        MessageSerializer.serialize((WriteChannel)out, (Schema)this.schema);
        FieldVector dictVector1 = this.dictionary1.getVector();
        VectorSchemaRoot dictRoot1 = new VectorSchemaRoot(Collections.singletonList(dictVector1.getField()), Collections.singletonList(dictVector1), dictVector1.getValueCount());
        ArrowDictionaryBatch dictionaryBatch1 = new ArrowDictionaryBatch(1L, new VectorUnloader(dictRoot1).getRecordBatch());
        MessageSerializer.serialize((WriteChannel)out, (ArrowDictionaryBatch)dictionaryBatch1);
        dictionaryBatch1.close();
        dictRoot1.close();
        MessageSerializer.serialize((WriteChannel)out, (ArrowRecordBatch)batches.get(0));
        FieldVector dictVector2 = this.dictionary2.getVector();
        VectorSchemaRoot dictRoot2 = new VectorSchemaRoot(Collections.singletonList(dictVector2.getField()), Collections.singletonList(dictVector2), dictVector2.getValueCount());
        ArrowDictionaryBatch dictionaryBatch2 = new ArrowDictionaryBatch(2L, new VectorUnloader(dictRoot2).getRecordBatch());
        MessageSerializer.serialize((WriteChannel)out, (ArrowDictionaryBatch)dictionaryBatch2);
        dictionaryBatch2.close();
        dictRoot2.close();
        MessageSerializer.serialize((WriteChannel)out, (ArrowRecordBatch)batches.get(1));
        out.writeIntLittleEndian(0);
        try (ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(outStream.toByteArray()), this.allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((Object)this.encodedSchema, (Object)readSchema);
            Assert.assertEquals((long)2L, (long)reader.getDictionaryVectors().size());
            Assert.assertTrue((boolean)reader.loadNextBatch());
            Assert.assertTrue((boolean)reader.loadNextBatch());
            Assert.assertFalse((boolean)reader.loadNextBatch());
        }
        batches.forEach(batch -> batch.close());
    }

    private List<ArrowRecordBatch> createRecordBatches() {
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        provider.put(this.dictionary1);
        provider.put(this.dictionary2);
        VarCharVector vectorA1 = TestUtils.newVarCharVector("varcharA1", this.allocator);
        vectorA1.allocateNewSafe();
        vectorA1.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        vectorA1.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        vectorA1.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        vectorA1.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        vectorA1.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        vectorA1.setValueCount(6);
        VarCharVector vectorA2 = TestUtils.newVarCharVector("varcharA2", this.allocator);
        vectorA2.setValueCount(6);
        FieldVector encodedVectorA1 = (FieldVector)DictionaryEncoder.encode((ValueVector)vectorA1, (Dictionary)this.dictionary1);
        vectorA1.close();
        FieldVector encodedVectorA2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vectorA1, (Dictionary)this.dictionary2);
        vectorA2.close();
        List<Field> fields = Arrays.asList(encodedVectorA1.getField(), encodedVectorA2.getField());
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVectorA1, encodedVectorA2});
        VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, encodedVectorA1.getValueCount());
        VectorUnloader unloader = new VectorUnloader(root);
        batches.add(unloader.getRecordBatch());
        root.close();
        VarCharVector vectorB1 = TestUtils.newVarCharVector("varcharB1", this.allocator);
        vectorB1.setValueCount(6);
        VarCharVector vectorB2 = TestUtils.newVarCharVector("varcharB2", this.allocator);
        vectorB2.allocateNew();
        vectorB2.setValueCount(6);
        vectorB2.set(0, "aa".getBytes(StandardCharsets.UTF_8));
        vectorB2.set(1, "aa".getBytes(StandardCharsets.UTF_8));
        vectorB2.set(3, "bb".getBytes(StandardCharsets.UTF_8));
        vectorB2.set(4, "bb".getBytes(StandardCharsets.UTF_8));
        vectorB2.set(5, "cc".getBytes(StandardCharsets.UTF_8));
        vectorB2.setValueCount(6);
        FieldVector encodedVectorB1 = (FieldVector)DictionaryEncoder.encode((ValueVector)vectorB1, (Dictionary)this.dictionary1);
        vectorB1.close();
        FieldVector encodedVectorB2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vectorB2, (Dictionary)this.dictionary2);
        vectorB2.close();
        List<Field> fieldsB = Arrays.asList(encodedVectorB1.getField(), encodedVectorB2.getField());
        List vectorsB = Collections2.asImmutableList((Object[])new FieldVector[]{encodedVectorB1, encodedVectorB2});
        VectorSchemaRoot rootB = new VectorSchemaRoot(fieldsB, vectorsB, 6);
        VectorUnloader unloaderB = new VectorUnloader(rootB);
        batches.add(unloaderB.getRecordBatch());
        rootB.close();
        ArrayList<Field> schemaFields = new ArrayList<Field>();
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVectorA1.getField(), (DictionaryProvider)provider, new HashSet()));
        schemaFields.add(DictionaryUtility.toMessageFormat((Field)encodedVectorA2.getField(), (DictionaryProvider)provider, new HashSet()));
        this.schema = new Schema(schemaFields);
        this.encodedSchema = new Schema(Arrays.asList(encodedVectorA1.getField(), encodedVectorA2.getField()));
        return batches;
    }

    @Test
    public void testLegacyIpcBackwardsCompatibility() throws Exception {
        Schema schema = new Schema(Arrays.asList(Field.nullable((String)"field", (ArrowType)new ArrowType.Int(32, true))));
        IntVector vector = new IntVector("vector", this.allocator);
        int valueCount = 2;
        vector.setValueCount(2);
        vector.setSafe(0, 1);
        vector.setSafe(1, 2);
        ArrowRecordBatch batch = new ArrowRecordBatch(2, Arrays.asList(new ArrowFieldNode(2L, 0L)), Arrays.asList(vector.getValidityBuffer(), vector.getDataBuffer()));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WriteChannel out = new WriteChannel(Channels.newChannel(outStream));
        IpcOption option = new IpcOption(true, MetadataVersion.DEFAULT);
        MessageSerializer.serialize((WriteChannel)out, (Schema)schema, (IpcOption)option);
        MessageSerializer.serialize((WriteChannel)out, (ArrowRecordBatch)batch);
        ReadChannel in = new ReadChannel(Channels.newChannel(new ByteArrayInputStream(outStream.toByteArray())));
        Schema readSchema = MessageSerializer.deserializeSchema((ReadChannel)in);
        Assert.assertEquals((Object)schema, (Object)readSchema);
        ArrowRecordBatch readBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)in, (BufferAllocator)this.allocator);
        Assert.assertEquals((long)batch.getLength(), (long)readBatch.getLength());
        Assert.assertEquals((long)batch.computeBodyLength(), (long)readBatch.computeBodyLength());
        readBatch.close();
        option = IpcOption.DEFAULT;
        MessageSerializer.serialize((WriteChannel)out, (Schema)schema, (IpcOption)option);
        MessageSerializer.serialize((WriteChannel)out, (ArrowRecordBatch)batch);
        ReadChannel in2 = new ReadChannel(Channels.newChannel(new ByteArrayInputStream(outStream.toByteArray())));
        Schema readSchema2 = MessageSerializer.deserializeSchema((ReadChannel)in2);
        Assert.assertEquals((Object)schema, (Object)readSchema2);
        ArrowRecordBatch readBatch2 = MessageSerializer.deserializeRecordBatch((ReadChannel)in2, (BufferAllocator)this.allocator);
        Assert.assertEquals((long)batch.getLength(), (long)readBatch2.getLength());
        Assert.assertEquals((long)batch.computeBodyLength(), (long)readBatch2.computeBodyLength());
        readBatch2.close();
        batch.close();
        vector.close();
    }

    @Test
    public void testChannelReadFully() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        buf.putInt(200);
        buf.rewind();
        try (ReadChannel channel = new ReadChannel(Channels.newChannel(new ByteArrayInputStream(buf.array())));
             ArrowBuf arrBuf = this.allocator.buffer(8L);){
            arrBuf.setInt(0L, 100);
            arrBuf.writerIndex(4L);
            Assert.assertEquals((long)4L, (long)arrBuf.writerIndex());
            long n = channel.readFully(arrBuf, 4L);
            Assert.assertEquals((long)4L, (long)n);
            Assert.assertEquals((long)8L, (long)arrBuf.writerIndex());
            Assert.assertEquals((long)100L, (long)arrBuf.getInt(0L));
            Assert.assertEquals((long)200L, (long)arrBuf.getInt(4L));
        }
    }

    @Test
    public void testChannelReadFullyEos() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        buf.putInt(10);
        buf.rewind();
        try (ReadChannel channel = new ReadChannel(Channels.newChannel(new ByteArrayInputStream(buf.array())));
             ArrowBuf arrBuf = this.allocator.buffer(8L);){
            int n = channel.readFully(arrBuf.nioBuffer(0L, 8));
            Assert.assertEquals((long)4L, (long)n);
            Assert.assertEquals((long)4L, (long)channel.bytesRead());
            Assert.assertEquals((long)10L, (long)arrBuf.getInt(0L));
        }
    }

    @Test
    public void testCustomMetaData() throws IOException {
        VarCharVector vector = TestUtils.newVarCharVector("varchar1", this.allocator);
        List<Field> fields = Arrays.asList(vector.getField());
        List vectors = Collections2.asImmutableList((Object[])new FieldVector[]{vector});
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        metadata.put("key2", "value2");
        try (VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector.getValueCount());
             ByteArrayOutputStream out = new ByteArrayOutputStream();
             ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out), metadata);){
            writer.start();
            writer.end();
            try (SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(out.toByteArray()));
                 ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
                reader.getVectorSchemaRoot();
                Map readMeta = reader.getMetaData();
                Assert.assertEquals((long)2L, (long)readMeta.size());
                Assert.assertEquals((Object)"value1", readMeta.get("key1"));
                Assert.assertEquals((Object)"value2", readMeta.get("key2"));
            }
        }
    }
}

