/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.File;
import java.io.IOException;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.NonNullableStructVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.BaseFileTest;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.JsonFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJSONFile
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestJSONFile.class);

    @Test
    public void testNoBatches() throws IOException {
        Throwable throwable;
        File file = new File("target/no_batches.json");
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                ComplexWriterImpl writer = new ComplexWriterImpl("root", (NonNullableStructVector)parent);
                BaseWriter.StructWriter rootWriter = writer.rootAsStruct();
                rootWriter.integer("int");
                rootWriter.uInt1("uint1");
                rootWriter.bigInt("bigInt");
                rootWriter.float4("float");
                JsonFileWriter jsonWriter = new JsonFileWriter(file, JsonFileWriter.config().pretty(true));
                jsonWriter.start(new VectorSchemaRoot(parent.getChild("root")).getSchema(), null);
                jsonWriter.close();
            }
            catch (Throwable writer) {
                throwable = writer;
                throw writer;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var3_3 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteRead() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest.json");
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeData(count, parent);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateContent(count, root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteReadComplexJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_complex.json");
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeComplexData(count, parent);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateComplexContent(count, root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteComplexJSON() throws IOException {
        File file = new File("target/mytest_write_complex.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeComplexData(count, parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateComplexContent(root.getRowCount(), root);
            this.writeJSON(file, root, null);
        }
    }

    public void writeJSON(File file, VectorSchemaRoot root, DictionaryProvider provider) throws IOException {
        JsonFileWriter writer = new JsonFileWriter(file, JsonFileWriter.config().pretty(true));
        writer.start(root.getSchema(), provider);
        writer.write(root);
        writer.close();
    }

    @Test
    public void testWriteReadUnionJSON() throws IOException {
        File file = new File("target/mytest_write_union.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeUnionData(count, parent);
            this.printVectors(parent.getChildrenFromFields());
            try (VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));){
                this.validateUnionData(count, root);
                this.writeJSON(file, root, null);
                try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
                    JsonFileReader reader = new JsonFileReader(file, readerAllocator);
                    Schema schema = reader.start();
                    LOGGER.debug("reading schema: " + schema);
                    try (VectorSchemaRoot rootFromJson = reader.read();){
                        this.validateUnionData(count, rootFromJson);
                        Validator.compareVectorSchemaRoot((VectorSchemaRoot)root, (VectorSchemaRoot)rootFromJson);
                    }
                }
            }
        }
    }

    @Test
    public void testWriteReadDateTimeJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_datetime.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeDateTimeData(count, parent);
                this.printVectors(parent.getChildrenFromFields());
                VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
                this.validateDateTimeContent(count, root);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable root) {
                throwable = root;
                throw root;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateDateTimeContent(count, root);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteReadDictionaryJSON() throws IOException {
        Object object;
        File file = new File("target/mytest_dictionary.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root = this.writeFlatDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateFlatDictionary(root, (DictionaryProvider)provider);
                this.writeJSON(file, root, (DictionaryProvider)provider);
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            object = null;
            try {
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateFlatDictionary(root, (DictionaryProvider)reader);
                }
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    TestJSONFile.$closeResource(object, (AutoCloseable)reader);
                    throw throwable2;
                }
            }
            TestJSONFile.$closeResource((Throwable)object, (AutoCloseable)reader);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadNestedDictionaryJSON() throws IOException {
        Object object;
        File file = new File("target/mytest_dict_nested.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root = this.writeNestedDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateNestedDictionary(root, (DictionaryProvider)provider);
                this.writeJSON(file, root, (DictionaryProvider)provider);
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            object = null;
            try {
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateNestedDictionary(root, (DictionaryProvider)reader);
                }
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    TestJSONFile.$closeResource(object, (AutoCloseable)reader);
                    throw throwable2;
                }
            }
            TestJSONFile.$closeResource((Throwable)object, (AutoCloseable)reader);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadDecimalJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_decimal.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeDecimalData(vectorAllocator);){
                this.printVectors(root.getFieldVectors());
                this.validateDecimalData(root);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateDecimalData(root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testSetStructLength() throws IOException {
        File file = new File("../../docs/source/format/integration_json_examples/struct.json");
        if (!file.exists()) {
            file = new File("../docs/source/format/integration_json_examples/struct.json");
        }
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
             JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                FieldVector vector = root.getVector("struct_nullable");
                Assert.assertEquals((long)7L, (long)vector.getValueCount());
            }
        }
    }

    @Test
    public void testWriteReadVarBinJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_varbin.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (StructVector parent = StructVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeVarBinaryData(count, parent);
                VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
                this.validateVarBinary(count, root);
                this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
            }
            catch (Throwable root) {
                throwable = root;
                throw root;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateVarBinary(count, root);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteReadMapJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_map.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeMapData(vectorAllocator);){
                this.printVectors(root.getFieldVectors());
                this.validateMapData(root);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateMapData(root);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testWriteReadNullJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_null.json");
        int valueCount = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (VectorSchemaRoot root = this.writeNullData(valueCount);){
                this.printVectors(root.getFieldVectors());
                this.validateNullData(root, valueCount);
                this.writeJSON(file, root, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (JsonFileReader reader = new JsonFileReader(file, readerAllocator);){
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateNullData(root, valueCount);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var4_4 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void testNoOverFlowWithUINT() {
        try (UInt8Vector uInt8Vector = new UInt8Vector("uint8", this.allocator);
             UInt4Vector uInt4Vector = new UInt4Vector("uint4", this.allocator);
             UInt1Vector uInt1Vector = new UInt1Vector("uint1", this.allocator);){
            long[] longValues = new long[]{Long.MIN_VALUE, Long.MAX_VALUE, -1L};
            uInt8Vector.allocateNew(3);
            uInt8Vector.setValueCount(3);
            for (int i = 0; i < longValues.length; ++i) {
                uInt8Vector.set(i, longValues[i]);
                long readValue = uInt8Vector.getObjectNoOverflow(i).longValue();
                Assert.assertEquals((long)readValue, (long)longValues[i]);
            }
            int[] intValues = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, -1};
            uInt4Vector.allocateNew(3);
            uInt4Vector.setValueCount(3);
            for (int i = 0; i < intValues.length; ++i) {
                uInt4Vector.set(i, intValues[i]);
                int actualValue = (int)UInt4Vector.getNoOverflow((ArrowBuf)uInt4Vector.getDataBuffer(), (int)i);
                Assert.assertEquals((long)intValues[i], (long)actualValue);
            }
            byte[] byteValues = new byte[]{-128, 127, -1};
            uInt1Vector.allocateNew(3);
            uInt1Vector.setValueCount(3);
            for (int i = 0; i < byteValues.length; ++i) {
                uInt1Vector.set(i, byteValues[i]);
                byte actualValue = (byte)UInt1Vector.getNoOverflow((ArrowBuf)uInt1Vector.getDataBuffer(), (int)i);
                Assert.assertEquals((long)byteValues[i], (long)actualValue);
            }
        }
    }
}

