/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.util.DecimalUtility;
import org.junit.Assert;
import org.junit.Test;

public class DecimalUtilityTest {
    private static final BigInteger[] MAX_BIG_INT = new BigInteger[]{BigInteger.valueOf(10L).pow(38).subtract(BigInteger.ONE), BigInteger.valueOf(10L).pow(76)};
    private static final BigInteger[] MIN_BIG_INT = new BigInteger[]{MAX_BIG_INT[0].multiply(BigInteger.valueOf(-1L)), MAX_BIG_INT[1].multiply(BigInteger.valueOf(-1L))};

    @Test
    public void testSetLongInDecimalArrowBuf() {
        int[] byteLengths = new int[]{16, 32};
        for (int x = 0; x < 2; ++x) {
            try (RootAllocator allocator = new RootAllocator(128L);
                 ArrowBuf buf = allocator.buffer((long)byteLengths[x]);){
                int[] intValues;
                for (int val : intValues = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, 0}) {
                    buf.clear();
                    DecimalUtility.writeLongToArrowBuf((long)val, (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    BigDecimal actual = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    BigDecimal expected = BigDecimal.valueOf(val);
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
                continue;
            }
        }
    }

    @Test
    public void testSetByteArrayInDecimalArrowBuf() {
        int[] byteLengths = new int[]{16, 32};
        for (int x = 0; x < 2; ++x) {
            try (RootAllocator allocator = new RootAllocator(128L);
                 ArrowBuf buf = allocator.buffer((long)byteLengths[x]);){
                BigInteger[] decimals;
                BigDecimal expected;
                BigDecimal actual;
                long[] longValues;
                int[] intValues;
                for (int val : intValues = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, 0}) {
                    buf.clear();
                    DecimalUtility.writeByteArrayToArrowBuf((byte[])BigInteger.valueOf(val).toByteArray(), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    BigDecimal actual2 = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    BigDecimal expected2 = BigDecimal.valueOf(val);
                    Assert.assertEquals((Object)expected2, (Object)actual2);
                }
                for (long val : longValues = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE}) {
                    buf.clear();
                    DecimalUtility.writeByteArrayToArrowBuf((byte[])BigInteger.valueOf(val).toByteArray(), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    actual = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    expected = BigDecimal.valueOf(val);
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
                for (BigInteger val : decimals = new BigInteger[]{MAX_BIG_INT[x], new BigInteger("0"), MIN_BIG_INT[x]}) {
                    buf.clear();
                    DecimalUtility.writeByteArrayToArrowBuf((byte[])val.toByteArray(), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    actual = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    expected = new BigDecimal(val);
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
                continue;
            }
        }
    }

    @Test
    public void testSetBigDecimalInDecimalArrowBuf() {
        int[] byteLengths = new int[]{16, 32};
        for (int x = 0; x < 2; ++x) {
            try (RootAllocator allocator = new RootAllocator(128L);
                 ArrowBuf buf = allocator.buffer((long)byteLengths[x]);){
                BigInteger[] decimals;
                BigDecimal expected;
                BigDecimal actual;
                long[] longValues;
                int[] intValues;
                for (int val : intValues = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, 0}) {
                    buf.clear();
                    DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)BigDecimal.valueOf(val), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    BigDecimal actual2 = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    BigDecimal expected2 = BigDecimal.valueOf(val);
                    Assert.assertEquals((Object)expected2, (Object)actual2);
                }
                for (long val : longValues = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE}) {
                    buf.clear();
                    DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)BigDecimal.valueOf(val), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    actual = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    expected = BigDecimal.valueOf(val);
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
                for (BigInteger val : decimals = new BigInteger[]{MAX_BIG_INT[x], new BigInteger("0"), MIN_BIG_INT[x]}) {
                    buf.clear();
                    DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)new BigDecimal(val), (ArrowBuf)buf, (int)0, (int)byteLengths[x]);
                    actual = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)buf, (int)0, (int)0, (int)byteLengths[x]);
                    expected = new BigDecimal(val);
                    Assert.assertEquals((Object)expected, (Object)actual);
                }
                continue;
            }
        }
    }
}

