/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestCircularReferences {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final String __PARANAMER_DATA = "";

    @BeforeClass
    public static void addReferenceTypes() {
        LogicalTypes.register((String)"referenceable", (LogicalTypes.LogicalTypeFactory)new LogicalTypes.LogicalTypeFactory(){

            public LogicalType fromSchema(Schema schema) {
                return new Referenceable(schema);
            }
        });
        LogicalTypes.register((String)"reference", (LogicalTypes.LogicalTypeFactory)new LogicalTypes.LogicalTypeFactory(){

            public LogicalType fromSchema(Schema schema) {
                return new Reference(schema);
            }
        });
    }

    @Test
    public void test() throws IOException {
        ReferenceManager manager = new ReferenceManager();
        GenericData model = new GenericData();
        model.addLogicalTypeConversion((Conversion)manager.getTracker());
        model.addLogicalTypeConversion((Conversion)manager.getHandler());
        Schema parentSchema = Schema.createRecord((String)"Parent", null, null, (boolean)false);
        Schema parentRefSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG), parentSchema});
        Reference parentRef = new Reference("parent");
        ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
        childFields.add(new Schema.Field("c", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        childFields.add(new Schema.Field("parent", parentRefSchema, null, null));
        Schema childSchema = parentRef.addToSchema(Schema.createRecord((String)"Child", null, null, (boolean)false, childFields));
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        parentFields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, null));
        parentFields.add(new Schema.Field("p", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        parentFields.add(new Schema.Field("child", childSchema, null, null));
        parentSchema.setFields(parentFields);
        Referenceable idRef = new Referenceable("id");
        Schema schema = idRef.addToSchema(parentSchema);
        System.out.println("Schema: " + schema.toString(true));
        GenericData.Record parent = new GenericData.Record(schema);
        parent.put("id", (Object)1L);
        parent.put("p", (Object)"parent data!");
        GenericData.Record child = new GenericData.Record(childSchema);
        child.put("c", (Object)"child data!");
        child.put("parent", (Object)parent);
        parent.put("child", (Object)child);
        File data = this.write(model, schema, parent);
        List records = this.read(model, schema, data);
        GenericData.Record actual = (GenericData.Record)records.get(0);
        Assert.assertEquals((String)"Should correctly read back the parent id", (Object)1L, (Object)actual.get("id"));
        Assert.assertEquals((String)"Should correctly read back the parent data", (Object)new Utf8("parent data!"), (Object)actual.get("p"));
        GenericData.Record actualChild = (GenericData.Record)actual.get("child");
        Assert.assertEquals((String)"Should correctly read back the child data", (Object)new Utf8("child data!"), (Object)actualChild.get("c"));
        Object childParent = actualChild.get("parent");
        Assert.assertTrue((String)"Should have a parent Record object", (boolean)(childParent instanceof GenericData.Record));
        GenericData.Record childParentRecord = (GenericData.Record)actualChild.get("parent");
        Assert.assertEquals((String)"Should have the right parent id", (Object)1L, (Object)childParentRecord.get("id"));
        Assert.assertEquals((String)"Should have the right parent data", (Object)new Utf8("parent data!"), (Object)childParentRecord.get("p"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> List<D> read(GenericData model, Schema schema, File file) throws IOException {
        DatumReader<D> reader = this.newReader(model, schema);
        ArrayList data = new ArrayList();
        DataFileReader fileReader = null;
        try {
            fileReader = new DataFileReader(file, reader);
            for (Object datum : fileReader) {
                data.add(datum);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return data;
    }

    private <D> DatumReader<D> newReader(GenericData model, Schema schema) {
        return model.createDatumReader(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        File file = this.temp.newFile();
        DatumWriter writer = model.createDatumWriter(schema);
        DataFileWriter fileWriter = new DataFileWriter(writer);
        try {
            fileWriter.create(schema, file);
            for (D datum : data) {
                fileWriter.append(datum);
            }
        }
        finally {
            fileWriter.close();
        }
        return file;
    }

    public static class ReferenceManager {
        private final Map<Long, Object> references = new HashMap<Long, Object>();
        private final Map<Object, Long> ids = new IdentityHashMap<Object, Long>();
        private final Map<Long, List<Callback>> callbacksById = new HashMap<Long, List<Callback>>();
        private final ReferenceableTracker tracker = new ReferenceableTracker();
        private final ReferenceHandler handler = new ReferenceHandler();
        public static final String __PARANAMER_DATA = "";

        public ReferenceableTracker getTracker() {
            return this.tracker;
        }

        public ReferenceHandler getHandler() {
            return this.handler;
        }

        private static class HijackingIndexedRecord
        implements IndexedRecord {
            private final IndexedRecord wrapped;
            private final int index;
            private final Object data;
            public static final String __PARANAMER_DATA = "<init> org.apache.avro.generic.IndexedRecord,int,java.lang.Object wrapped,index,data \nget int i \nput int,java.lang.Object i,v \n";

            public HijackingIndexedRecord(IndexedRecord wrapped, int index, Object data) {
                this.wrapped = wrapped;
                this.index = index;
                this.data = data;
            }

            public void put(int i, Object v) {
                throw new RuntimeException("[BUG] This is a read-only class.");
            }

            public Object get(int i) {
                if (i == this.index) {
                    return this.data;
                }
                return this.wrapped.get(i);
            }

            public Schema getSchema() {
                return this.wrapped.getSchema();
            }
        }

        public class ReferenceHandler
        extends Conversion<IndexedRecord> {
            public static final String __PARANAMER_DATA = "fromRecord org.apache.avro.generic.IndexedRecord,Schema,LogicalType record,schema,type \ntoRecord org.apache.avro.generic.IndexedRecord,Schema,LogicalType record,schema,type \n";

            public Class<IndexedRecord> getConvertedType() {
                return GenericData.Record.class;
            }

            public String getLogicalTypeName() {
                return "reference";
            }

            public IndexedRecord fromRecord(final IndexedRecord record, Schema schema, LogicalType type) {
                final Schema.Field refField = schema.getField(((Reference)type).getRefFieldName());
                Long id = (Long)record.get(refField.pos());
                if (id != null) {
                    if (ReferenceManager.this.references.containsKey(id)) {
                        record.put(refField.pos(), ReferenceManager.this.references.get(id));
                    } else {
                        ArrayList<1> callbacks = (ArrayList<1>)ReferenceManager.this.callbacksById.get(id);
                        if (callbacks == null) {
                            callbacks = new ArrayList<1>();
                            ReferenceManager.this.callbacksById.put(id, callbacks);
                        }
                        callbacks.add(new Callback(){

                            @Override
                            public void set(Object referenceable) {
                                record.put(refField.pos(), referenceable);
                            }
                        });
                    }
                }
                return record;
            }

            public IndexedRecord toRecord(IndexedRecord record, Schema schema, LogicalType type) {
                Schema.Field refField = schema.getField(((Reference)type).getRefFieldName());
                IndexedRecord referenced = (IndexedRecord)record.get(refField.pos());
                if (referenced == null) {
                    return record;
                }
                return new HijackingIndexedRecord(record, refField.pos(), ReferenceManager.this.ids.get(referenced));
            }
        }

        public class ReferenceableTracker
        extends Conversion<IndexedRecord> {
            public static final String __PARANAMER_DATA = "fromRecord org.apache.avro.generic.IndexedRecord,Schema,LogicalType value,schema,type \ntoRecord org.apache.avro.generic.IndexedRecord,Schema,LogicalType value,schema,type \n";

            public Class<IndexedRecord> getConvertedType() {
                return GenericData.Record.class;
            }

            public String getLogicalTypeName() {
                return "referenceable";
            }

            public IndexedRecord fromRecord(IndexedRecord value, Schema schema, LogicalType type) {
                long id = this.getId(value, schema);
                ReferenceManager.this.references.put(id, value);
                List callbacks = (List)ReferenceManager.this.callbacksById.get(id);
                for (Callback callback : callbacks) {
                    callback.set(value);
                }
                return value;
            }

            public IndexedRecord toRecord(IndexedRecord value, Schema schema, LogicalType type) {
                long id = this.getId(value, schema);
                ReferenceManager.this.ids.put(value, id);
                return value;
            }

            private long getId(IndexedRecord referenceable, Schema schema) {
                Referenceable info = (Referenceable)schema.getLogicalType();
                int idField = schema.getField(info.getIdFieldName()).pos();
                return (Long)referenceable.get(idField);
            }
        }

        private static interface Callback {
            public static final String __PARANAMER_DATA = "set java.lang.Object referenceable \n";

            public void set(Object var1);
        }
    }

    public static class Referenceable
    extends LogicalType {
        private static final String REFERENCEABLE = "referenceable";
        private static final String ID_FIELD_NAME = "id-field-name";
        private final String idFieldName;
        public static final String __PARANAMER_DATA = "<init> Schema schema \n<init> java.lang.String idFieldName \naddToSchema Schema schema \nvalidate Schema schema \n";

        public Referenceable(String idFieldName) {
            super(REFERENCEABLE);
            this.idFieldName = idFieldName;
        }

        public Referenceable(Schema schema) {
            super(REFERENCEABLE);
            this.idFieldName = schema.getProp(ID_FIELD_NAME);
        }

        public Schema addToSchema(Schema schema) {
            super.addToSchema(schema);
            schema.addProp(ID_FIELD_NAME, this.idFieldName);
            return schema;
        }

        public String getName() {
            return REFERENCEABLE;
        }

        public String getIdFieldName() {
            return this.idFieldName;
        }

        public void validate(Schema schema) {
            super.validate(schema);
            Schema.Field idField = schema.getField(this.idFieldName);
            if (idField == null || idField.schema().getType() != Schema.Type.LONG) {
                throw new IllegalArgumentException("Invalid ID field: " + this.idFieldName + ": " + idField);
            }
        }
    }

    public static class Reference
    extends LogicalType {
        private static final String REFERENCE = "reference";
        private static final String REF_FIELD_NAME = "ref-field-name";
        private final String refFieldName;
        public static final String __PARANAMER_DATA = "<init> Schema schema \n<init> java.lang.String refFieldName \naddToSchema Schema schema \nvalidate Schema schema \n";

        public Reference(String refFieldName) {
            super(REFERENCE);
            this.refFieldName = refFieldName;
        }

        public Reference(Schema schema) {
            super(REFERENCE);
            this.refFieldName = schema.getProp(REF_FIELD_NAME);
        }

        public Schema addToSchema(Schema schema) {
            super.addToSchema(schema);
            schema.addProp(REF_FIELD_NAME, this.refFieldName);
            return schema;
        }

        public String getName() {
            return REFERENCE;
        }

        public String getRefFieldName() {
            return this.refFieldName;
        }

        public void validate(Schema schema) {
            super.validate(schema);
            if (schema.getField(this.refFieldName) == null) {
                throw new IllegalArgumentException("Invalid field name for reference field: " + this.refFieldName);
            }
        }
    }
}

