/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.avro.RandomData;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.file.Syncable;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestDataFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataFile.class);
    CodecFactory codec = null;
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    private static final boolean VALIDATE = !"false".equals(System.getProperty("test.validate", "true"));
    private static final File DIR = new File(System.getProperty("test.dir", "/tmp"));
    private static final long SEED = System.currentTimeMillis();
    private static final String SCHEMA_JSON = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}";
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}");
    public static final String __PARANAMER_DATA = "<init> org.apache.avro.file.CodecFactory codec \nmain java.lang.String[] args \nreadFile java.io.File,org.apache.avro.io.DatumReader f,datumReader \n";

    public TestDataFile(CodecFactory codec) {
        this.codec = codec;
        LOG.info("Running with codec: " + codec);
    }

    @Parameterized.Parameters
    public static List<Object[]> codecs() {
        ArrayList<Object[]> r = new ArrayList<Object[]>();
        r.add(new Object[]{null});
        r.add(new Object[]{CodecFactory.deflateCodec((int)0)});
        r.add(new Object[]{CodecFactory.deflateCodec((int)1)});
        r.add(new Object[]{CodecFactory.deflateCodec((int)9)});
        r.add(new Object[]{CodecFactory.nullCodec()});
        r.add(new Object[]{CodecFactory.snappyCodec()});
        r.add(new Object[]{CodecFactory.xzCodec((int)0)});
        r.add(new Object[]{CodecFactory.xzCodec((int)1)});
        r.add(new Object[]{CodecFactory.xzCodec((int)6)});
        return r;
    }

    private File makeFile() {
        return new File(DIR, "test-" + this.codec + ".avro");
    }

    @Test
    public void runTestsInOrder() throws Exception {
        this.testGenericWrite();
        this.testGenericRead();
        this.testSplits();
        this.testSyncDiscovery();
        this.testGenericAppend();
        this.testReadWithHeader();
        this.testFSync(false);
        this.testFSync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGenericWrite() throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(100);
        if (this.codec != null) {
            writer.setCodec(this.codec);
        }
        writer.create(SCHEMA, this.makeFile());
        try {
            int count = 0;
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED)) {
                writer.append(datum);
                if (++count % (COUNT / 3) == 0) {
                    writer.sync();
                }
                if (count != 5) continue;
                boolean threwProperly = false;
                try {
                    GenericData.Record record = (GenericData.Record)datum;
                    record.put(1, null);
                    threwProperly = true;
                    writer.append((Object)record);
                    threwProperly = false;
                }
                catch (DataFileWriter.AppendWriteException e) {
                    System.out.println("Ignoring: " + (Object)((Object)e));
                }
                junit.framework.Assert.assertTrue((String)"failed to throw when expected", (boolean)threwProperly);
            }
        }
        finally {
            writer.close();
        }
        Exception doubleCloseEx = null;
        try {
            writer.close();
        }
        catch (Exception e) {
            doubleCloseEx = e;
        }
        junit.framework.Assert.assertNull((String)"Double close() threw an unexpected exception", (Object)doubleCloseEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGenericRead() throws IOException {
        DataFileReader reader = new DataFileReader(this.makeFile(), (DatumReader)new GenericDatumReader());
        try {
            Object datum = null;
            if (VALIDATE) {
                for (Object expected : new RandomData(SCHEMA, COUNT, SEED)) {
                    datum = reader.next(datum);
                    Assert.assertEquals((Object)expected, (Object)datum);
                }
            } else {
                for (int i = 0; i < COUNT; ++i) {
                    datum = reader.next(datum);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplits() throws IOException {
        File file = this.makeFile();
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        Random rand = new Random(SEED);
        try {
            int length;
            int start;
            int end;
            int splits = 10;
            int count = 0;
            for (int remaining = end = (length = (int)file.length()); remaining > 0; remaining -= end - start) {
                start = Math.max(0, end - rand.nextInt(2 * length / splits));
                reader.sync((long)start);
                while (!reader.pastSync((long)end)) {
                    reader.next();
                    ++count;
                }
                end = start;
            }
            Assert.assertEquals((long)COUNT, (long)count);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncDiscovery() throws IOException {
        File file = this.makeFile();
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        try {
            ArrayList<Long> syncs = new ArrayList<Long>();
            long previousSync = -1L;
            while (reader.hasNext()) {
                if (reader.previousSync() != previousSync) {
                    previousSync = reader.previousSync();
                    syncs.add(previousSync);
                }
                reader.next();
            }
            reader.sync(0L);
            Assert.assertEquals((long)reader.previousSync(), (long)((Long)syncs.get(0)));
            for (Long sync : syncs) {
                reader.seek(sync.longValue());
                Assert.assertNotNull((Object)reader.next());
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGenericAppend() throws IOException {
        File file = this.makeFile();
        long start = file.length();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).appendTo(file);
        try {
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
            }
        }
        finally {
            writer.close();
        }
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        try {
            Object datum;
            reader.seek(start);
            datum = null;
            if (VALIDATE) {
                for (Object expected : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                    datum = reader.next(datum);
                    Assert.assertEquals((Object)expected, (Object)datum);
                }
            } else {
                for (int i = 0; i < COUNT; ++i) {
                    datum = reader.next(datum);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public void testReadWithHeader() throws IOException {
        File file = this.makeFile();
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        DataFileStream.Header header = reader.getHeader();
        SeekableFileInput sin = new SeekableFileInput(file);
        sin.seek(sin.length() / 2L);
        reader = DataFileReader.openReader((SeekableInput)sin, (DatumReader)new GenericDatumReader(), (DataFileStream.Header)header, (boolean)true);
        Assert.assertNotNull((String)"Should be able to reopen from arbitrary point", (Object)reader.next());
        long validPos = reader.previousSync();
        sin.seek(validPos);
        reader = DataFileReader.openReader((SeekableInput)sin, (DatumReader)new GenericDatumReader(), (DataFileStream.Header)header, (boolean)false);
        Assert.assertEquals((String)"Should not move from sync point on reopen", (long)validPos, (long)sin.tell());
        Assert.assertNotNull((String)"Should be able to reopen at sync point", (Object)reader.next());
    }

    @Test
    public void testSyncInHeader() throws IOException {
        DataFileReader reader = new DataFileReader(new File("../../../share/test/data/syncInMeta.avro"), (DatumReader)new GenericDatumReader());
        reader.sync(0L);
        for (Object datum : reader) {
            Assert.assertNotNull(datum);
        }
    }

    @Test
    public void test12() throws IOException {
        TestDataFile.readFile(new File("../../../share/test/data/test.avro12"), (DatumReader<? extends Object>)new GenericDatumReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCount() throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.setFlushOnEveryBlock(false);
        TestingByteArrayOutputStream out = new TestingByteArrayOutputStream();
        writer.create(SCHEMA, (OutputStream)out);
        int currentCount = 0;
        int flushCounter = 0;
        try {
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
                writer.sync();
                if (++currentCount % 10 != 0) continue;
                ++flushCounter;
                writer.flush();
            }
        }
        finally {
            writer.close();
        }
        System.out.println("Total number of flushes: " + out.flushCount);
        junit.framework.Assert.assertTrue((out.flushCount < currentCount && out.flushCount >= flushCounter ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFSync(boolean useFile) throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.setFlushOnEveryBlock(false);
        TestingByteArrayOutputStream out = new TestingByteArrayOutputStream();
        if (useFile) {
            File f = this.makeFile();
            SeekableFileInput in = new SeekableFileInput(f);
            writer.appendTo((SeekableInput)in, (OutputStream)out);
        } else {
            writer.create(SCHEMA, (OutputStream)out);
        }
        int currentCount = 0;
        int syncCounter = 0;
        try {
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
                if (++currentCount % 10 != 0) continue;
                writer.fSync();
                ++syncCounter;
            }
        }
        finally {
            writer.close();
        }
        System.out.println("Total number of syncs: " + out.syncCount);
        junit.framework.Assert.assertEquals((int)syncCounter, (int)out.syncCount);
    }

    static void readFile(File f, DatumReader<? extends Object> datumReader) throws IOException {
        FileReader reader = DataFileReader.openReader((File)f, datumReader);
        for (Object datum : reader) {
            Assert.assertNotNull(datum);
        }
    }

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        Schema projection = null;
        if (args.length > 1) {
            projection = Schema.parse((File)new File(args[1]));
        }
        TestDataFile.readFile(input, (DatumReader<? extends Object>)new GenericDatumReader(null, projection));
        long start = System.currentTimeMillis();
        for (int i = 0; i < 4; ++i) {
            TestDataFile.readFile(input, (DatumReader<? extends Object>)new GenericDatumReader(null, projection));
        }
        System.out.println("Time: " + (System.currentTimeMillis() - start));
    }

    private class TestingByteArrayOutputStream
    extends ByteArrayOutputStream
    implements Syncable {
        private int flushCount = 0;
        private int syncCount = 0;
        public static final String __PARANAMER_DATA = "";

        private TestingByteArrayOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            ++this.flushCount;
        }

        public void sync() throws IOException {
            ++this.syncCount;
        }
    }
}

