/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.RandomData;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestDataFileConcat {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataFileConcat.class);
    CodecFactory codec = null;
    CodecFactory codec2 = null;
    boolean recompress;
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    private static final boolean VALIDATE = !"false".equals(System.getProperty("test.validate", "true"));
    private static final File DIR = new File(System.getProperty("test.dir", "/tmp"));
    private static final long SEED = System.currentTimeMillis();
    private static final String SCHEMA_JSON = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}";
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}");
    public static final String __PARANAMER_DATA = "<init> org.apache.avro.file.CodecFactory,org.apache.avro.file.CodecFactory,java.lang.Boolean codec,codec2,recompress \n";

    public TestDataFileConcat(CodecFactory codec, CodecFactory codec2, Boolean recompress) {
        this.codec = codec;
        this.codec2 = codec2;
        this.recompress = recompress;
        LOG.info("Testing concatenating files, " + codec2 + " into " + codec + " with recompress=" + recompress);
    }

    @Parameterized.Parameters
    public static List<Object[]> codecs() {
        ArrayList<Object[]> r = new ArrayList<Object[]>();
        r.add(new Object[]{null, null, false});
        r.add(new Object[]{null, null, true});
        r.add(new Object[]{CodecFactory.deflateCodec((int)1), CodecFactory.deflateCodec((int)6), false});
        r.add(new Object[]{CodecFactory.deflateCodec((int)1), CodecFactory.deflateCodec((int)6), true});
        r.add(new Object[]{CodecFactory.deflateCodec((int)3), CodecFactory.nullCodec(), false});
        r.add(new Object[]{CodecFactory.nullCodec(), CodecFactory.deflateCodec((int)6), false});
        r.add(new Object[]{CodecFactory.xzCodec((int)1), CodecFactory.xzCodec((int)2), false});
        r.add(new Object[]{CodecFactory.xzCodec((int)1), CodecFactory.xzCodec((int)2), true});
        r.add(new Object[]{CodecFactory.xzCodec((int)2), CodecFactory.nullCodec(), false});
        r.add(new Object[]{CodecFactory.nullCodec(), CodecFactory.xzCodec((int)2), false});
        return r;
    }

    private File makeFile(String name) {
        return new File(DIR, "test-" + name + ".avro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenateFiles() throws IOException {
        System.out.println("SEED = " + SEED);
        System.out.println("COUNT = " + COUNT);
        for (int k = 0; k < 5; ++k) {
            int syncInterval = 460 + k;
            RandomData data1 = new RandomData(SCHEMA, COUNT, SEED);
            RandomData data2 = new RandomData(SCHEMA, COUNT, SEED + 1L);
            File file1 = this.makeFile((this.codec == null ? "null" : this.codec.toString()) + "-A");
            File file2 = this.makeFile((this.codec2 == null ? "null" : this.codec2.toString()) + "-B");
            DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            if (this.codec != null) {
                writer.setCodec(this.codec);
            }
            writer.create(SCHEMA, file1);
            try {
                for (Object datum : data1) {
                    writer.append(datum);
                }
            }
            finally {
                writer.close();
            }
            DataFileWriter writer2 = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            if (this.codec2 != null) {
                writer2.setCodec(this.codec2);
            }
            writer2.create(SCHEMA, file2);
            try {
                for (Object datum : data2) {
                    writer2.append(datum);
                }
            }
            finally {
                writer2.close();
            }
            DataFileWriter concatinto = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(syncInterval);
            concatinto.appendTo(file1);
            DataFileReader concatfrom = new DataFileReader(file2, (DatumReader)new GenericDatumReader());
            concatinto.appendAllFrom((DataFileStream)concatfrom, this.recompress);
            concatinto.close();
            concatfrom.close();
            concatfrom = new DataFileReader(file2, (DatumReader)new GenericDatumReader());
            DataFileReader concat = new DataFileReader(file1, (DatumReader)new GenericDatumReader());
            int count = 0;
            try {
                Object datum = null;
                if (VALIDATE) {
                    for (Object expected : data1) {
                        datum = concat.next(datum);
                        Assert.assertEquals((String)("at " + count++), (Object)expected, (Object)datum);
                    }
                    for (Object expected : data2) {
                        datum = concatfrom.next(datum);
                        Assert.assertEquals((String)("at " + count++), (Object)expected, (Object)datum);
                    }
                    for (Object expected : data2) {
                        datum = concat.next(datum);
                        Assert.assertEquals((String)("at " + count++), (Object)expected, (Object)datum);
                    }
                    continue;
                }
                for (int i = 0; i < COUNT * 2; ++i) {
                    datum = concat.next(datum);
                }
                continue;
            }
            finally {
                if (count != 3 * COUNT) {
                    System.out.println(count + " " + k);
                }
                concat.close();
                concatfrom.close();
            }
        }
    }
}

