/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class TestDataFileCustomSync {
    public static final String __PARANAMER_DATA = "";

    private byte[] createDataFile(byte[] sync) throws IOException {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        w.create(schema, (OutputStream)baos, sync);
        w.append((Object)new Utf8("apple"));
        w.append((Object)new Utf8("banana"));
        w.sync();
        w.append((Object)new Utf8("celery"));
        w.append((Object)new Utf8("date"));
        w.sync();
        w.append((Object)new Utf8("endive"));
        w.append((Object)new Utf8("fig"));
        w.close();
        return baos.toByteArray();
    }

    private static byte[] generateSync() {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            long time = System.currentTimeMillis();
            digester.update((UUID.randomUUID() + "@" + time).getBytes());
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Test(expected=IOException.class)
    public void testInvalidSync() throws IOException {
        byte[] sync = new byte[8];
        this.createDataFile(sync);
    }

    @Test
    public void testRandomSync() throws IOException {
        byte[] sync = TestDataFileCustomSync.generateSync();
        byte[] randSyncFile = this.createDataFile(null);
        byte[] customSyncFile = this.createDataFile(sync);
        Assert.assertFalse((boolean)Arrays.equals(randSyncFile, customSyncFile));
    }

    @Test
    public void testCustomSync() throws IOException {
        byte[] sync = TestDataFileCustomSync.generateSync();
        byte[] customSyncFile = this.createDataFile(sync);
        byte[] sameCustomSyncFile = this.createDataFile(sync);
        Assert.assertTrue((boolean)Arrays.equals(customSyncFile, sameCustomSyncFile));
    }
}

