/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class TestDataFileDeflate {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testWriteAndRead() throws IOException {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        w.setCodec(CodecFactory.deflateCodec((int)6));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        w.create(schema, (OutputStream)baos);
        w.append((Object)new Utf8("hello world"));
        w.append((Object)new Utf8("hello moon"));
        w.sync();
        w.append((Object)new Utf8("bye bye world"));
        w.append((Object)new Utf8("bye bye moon"));
        w.close();
        DataFileStream r = new DataFileStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), (DatumReader)new GenericDatumReader(schema));
        Assert.assertEquals((Object)"hello world", (Object)((Utf8)r.next()).toString());
        Assert.assertEquals((Object)"hello moon", (Object)((Utf8)r.next()).toString());
        Assert.assertEquals((Object)"bye bye world", (Object)((Utf8)r.next()).toString());
        Assert.assertEquals((Object)"bye bye moon", (Object)((Utf8)r.next()).toString());
        Assert.assertFalse((boolean)r.hasNext());
    }
}

