/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTestUtil;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestDataFileMeta {
    public static final String __PARANAMER_DATA = "";

    @Test(expected=AvroRuntimeException.class)
    public void testUseReservedMeta() {
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        w.setMeta("avro.foo", "bar");
    }

    @Test
    public void testUseMeta() throws IOException {
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        File f = AvroTestUtil.tempFile(this.getClass(), "testDataFileMeta.avro");
        w.setMeta("hello", "bar");
        w.create(Schema.create((Schema.Type)Schema.Type.NULL), f);
        w.close();
        DataFileStream r = new DataFileStream((InputStream)new FileInputStream(f), (DatumReader)new GenericDatumReader());
        Assert.assertTrue((boolean)r.getMetaKeys().contains("hello"));
        Assert.assertEquals((Object)"bar", (Object)r.getMetaString("hello"));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testUseMetaAfterCreate() throws IOException {
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        w.create(Schema.create((Schema.Type)Schema.Type.NULL), (OutputStream)new ByteArrayOutputStream());
        w.setMeta("foo", "bar");
    }

    @Test
    public void testBlockSizeSetInvalid() {
        int exceptions = 0;
        for (int i = -1; i < 33; ++i) {
            try {
                new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(i);
                continue;
            }
            catch (IllegalArgumentException iae) {
                ++exceptions;
            }
        }
        junit.framework.Assert.assertEquals((int)33, (int)exceptions);
    }
}

