/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.BarRecord;
import org.apache.avro.FooRecord;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestDataFileReflect {
    private static final File DIR = new File(System.getProperty("test.dir", "/tmp"));
    private static final File FILE = new File(DIR, "test.avro");
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testMultiReflectWithUnionBeforeWriting() throws IOException {
        FileOutputStream fos = new FileOutputStream(FILE);
        ReflectData reflectData = ReflectData.get();
        List<Schema> schemas = Arrays.asList(reflectData.getSchema(FooRecord.class), reflectData.getSchema(BarRecord.class));
        Schema union = Schema.createUnion(schemas);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(union)).create(union, (OutputStream)fos);
        CheckList check = new CheckList();
        this.write(writer, new BarRecord("One beer please"), check);
        this.write(writer, new FooRecord(10), check);
        this.write(writer, new BarRecord("Two beers please"), check);
        this.write(writer, new FooRecord(20), check);
        writer.close();
        ReflectDatumReader din = new ReflectDatumReader();
        SeekableFileInput sin = new SeekableFileInput(FILE);
        DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);
        int count = 0;
        for (Object datum : reader) {
            check.assertEquals(datum, count++);
        }
        Assert.assertEquals((long)count, (long)check.size());
        reader.close();
    }

    @Test
    public void testNull() throws IOException {
        FileOutputStream fos = new FileOutputStream(FILE);
        ReflectData.AllowNull reflectData = ReflectData.AllowNull.get();
        Schema schema = reflectData.getSchema(BarRecord.class);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(BarRecord.class, (ReflectData)reflectData)).create(schema, (OutputStream)fos);
        CheckList check = new CheckList();
        this.write(writer, new BarRecord("One beer please"), check);
        this.write(writer, new BarRecord(), check);
        this.write(writer, new BarRecord("Two beers please"), check);
        writer.close();
        ReflectDatumReader din = new ReflectDatumReader();
        SeekableFileInput sin = new SeekableFileInput(FILE);
        DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);
        int count = 0;
        for (BarRecord datum : reader) {
            check.assertEquals(datum, count++);
        }
        Assert.assertEquals((long)count, (long)check.size());
        reader.close();
    }

    @Test
    public void testNestedClass() throws IOException {
        FileOutputStream fos = new FileOutputStream(FILE);
        Schema schema = ReflectData.get().getSchema(BazRecord.class);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new ReflectDatumWriter(schema)).create(schema, (OutputStream)fos);
        CheckList check = new CheckList();
        this.write(writer, new BazRecord(10), check);
        this.write(writer, new BazRecord(20), check);
        writer.close();
        ReflectDatumReader din = new ReflectDatumReader();
        SeekableFileInput sin = new SeekableFileInput(FILE);
        DataFileReader reader = new DataFileReader((SeekableInput)sin, (DatumReader)din);
        int count = 0;
        for (BazRecord datum : reader) {
            check.assertEquals(datum, count++);
        }
        Assert.assertEquals((long)count, (long)check.size());
        reader.close();
    }

    private <T> void write(DataFileWriter<T> writer, T o, CheckList<T> l) throws IOException {
        writer.append(l.addAndReturn(o));
    }

    private static class BazRecord {
        private int nbr;
        public static final String __PARANAMER_DATA = "<init> int nbr \nequals java.lang.Object that \n";

        public BazRecord() {
        }

        public BazRecord(int nbr) {
            this.nbr = nbr;
        }

        public boolean equals(Object that) {
            if (that instanceof BazRecord) {
                return this.nbr == ((BazRecord)that).nbr;
            }
            return false;
        }

        public int hashCode() {
            return this.nbr;
        }

        public String toString() {
            return BazRecord.class.getSimpleName() + "{cnt=" + this.nbr + "}";
        }
    }

    private static class CheckList<T>
    extends ArrayList<T> {
        public static final String __PARANAMER_DATA = "addAndReturn T check \nassertEquals java.lang.Object,int toCheck,i \n";

        private CheckList() {
        }

        T addAndReturn(T check) {
            this.add(check);
            return check;
        }

        void assertEquals(Object toCheck, int i) {
            Assert.assertNotNull((Object)toCheck);
            Object o = this.get(i);
            Assert.assertNotNull(o);
            Assert.assertEquals((Object)toCheck, o);
        }
    }
}

