/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestLogicalType {
    public static final String __PARANAMER_DATA = "assertEqualsFalse java.lang.String,java.lang.Object,java.lang.Object message,o1,o2 \nassertEqualsTrue java.lang.String,java.lang.Object,java.lang.Object message,o1,o2 \nassertThrows java.lang.String,java.lang.Class,java.lang.String,java.util.concurrent.Callable message,expected,containedInMessage,callable \n";

    @Test
    public void testDecimalFromSchema() {
        Schema schema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        schema.addProp("logicalType", "decimal");
        schema.addProp("precision", (Object)9);
        schema.addProp("scale", (Object)2);
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
        Assert.assertTrue((String)"Should be a Decimal", (boolean)(logicalType instanceof LogicalTypes.Decimal));
        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
        Assert.assertEquals((String)"Should have correct precision", (long)9L, (long)decimal.getPrecision());
        Assert.assertEquals((String)"Should have correct scale", (long)2L, (long)decimal.getScale());
    }

    @Test
    public void testInvalidLogicalTypeIgnored() {
        Schema schema = Schema.createFixed((String)"aFixed", null, null, (int)2);
        schema.addProp("logicalType", "decimal");
        schema.addProp("precision", (Object)9);
        schema.addProp("scale", (Object)2);
        Assert.assertNull((String)"Should ignore invalid logical type", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalWithNonByteArrayTypes() {
        Schema[] nonBytes;
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)5, (int)2);
        for (Schema schema : nonBytes = new Schema[]{Schema.createRecord((String)"Record", null, null, (boolean)false), Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.createEnum((String)"Enum", null, null, Arrays.asList("a", "b")), Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BYTES), Schema.createFixed((String)"fixed", null, null, (int)4))), Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}) {
            TestLogicalType.assertThrows("Should reject type: " + schema.getType(), IllegalArgumentException.class, "Logical type decimal must be backed by fixed or bytes", new Callable((LogicalType)decimal, schema){
                final /* synthetic */ LogicalType val$decimal;
                final /* synthetic */ Schema val$schema;
                {
                    this.val$decimal = logicalType;
                    this.val$schema = schema;
                }

                public Object call() throws Exception {
                    this.val$decimal.addToSchema(this.val$schema);
                    return null;
                }
            });
        }
    }

    @Test
    public void testUnknownFromJsonNode() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        schema.addProp("logicalType", "unknown");
        schema.addProp("someProperty", (Object)34);
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
        Assert.assertNull((String)"Should not return a LogicalType instance", (Object)logicalType);
    }

    @Test
    public void testDecimalBytesHasNoPrecisionLimit() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)Integer.MAX_VALUE).addToSchema(schema);
        Assert.assertEquals((String)"Precision should be an Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)((LogicalTypes.Decimal)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema)).getPrecision());
    }

    @Test
    public void testDecimalFixedPrecisionLimit() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "fixed(4) cannot store 10 digits (max 9)", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)10).addToSchema(schema);
                return null;
            }
        });
        Assert.assertNull((String)"Invalid logical type should not be set on schema", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalFailsWithZeroPrecision() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal precision: 0 (must be positive)", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)0).addToSchema(schema);
                return null;
            }
        });
        Assert.assertNull((String)"Invalid logical type should not be set on schema", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalFailsWithNegativePrecision() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal precision: -9 (must be positive)", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)-9).addToSchema(schema);
                return null;
            }
        });
        Assert.assertNull((String)"Invalid logical type should not be set on schema", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalScaleBoundedByPrecision() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal scale: 10 (greater than precision: 9)", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)9, (int)10).addToSchema(schema);
                return null;
            }
        });
        Assert.assertNull((String)"Invalid logical type should not be set on schema", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalFailsWithNegativeScale() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal scale: -2 (must be positive)", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)9, (int)-2).addToSchema(schema);
                return null;
            }
        });
        Assert.assertNull((String)"Invalid logical type should not be set on schema", (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testSchemaRejectsSecondLogicalType() {
        final Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9).addToSchema(schema);
        TestLogicalType.assertThrows("Should reject second logical type", AvroRuntimeException.class, "Can't overwrite property: scale", new Callable(){

            public Object call() throws Exception {
                LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
                return null;
            }
        });
        Assert.assertEquals((String)"First logical type should still be set on schema", (Object)LogicalTypes.decimal((int)9), (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema));
    }

    @Test
    public void testDecimalDefaultScale() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9).addToSchema(schema);
        Assert.assertEquals((String)"Scale should be a 0", (long)0L, (long)((LogicalTypes.Decimal)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema)).getScale());
    }

    @Test
    public void testFixedDecimalToFromJson() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
        Schema parsed = new Schema.Parser().parse(schema.toString(true));
        Assert.assertEquals((String)"Constructed and parsed schemas should match", (Object)schema, (Object)parsed);
    }

    @Test
    public void testBytesDecimalToFromJson() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
        Schema parsed = new Schema.Parser().parse(schema.toString(true));
        Assert.assertEquals((String)"Constructed and parsed schemas should match", (Object)schema, (Object)parsed);
    }

    @Test
    public void testLogicalTypeEquals() {
        LogicalTypes.Decimal decimal90 = LogicalTypes.decimal((int)9);
        LogicalTypes.Decimal decimal80 = LogicalTypes.decimal((int)8);
        LogicalTypes.Decimal decimal92 = LogicalTypes.decimal((int)9, (int)2);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)9, (int)0), decimal90);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)8, (int)0), decimal80);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)9, (int)2), decimal92);
        TestLogicalType.assertEqualsFalse("Different logical type", LogicalTypes.uuid(), decimal90);
        TestLogicalType.assertEqualsFalse("Different precision", decimal90, decimal80);
        TestLogicalType.assertEqualsFalse("Different scale", decimal90, decimal92);
    }

    @Test
    public void testLogicalTypeInSchemaEquals() {
        Schema schema1 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Schema schema2 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Schema schema3 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Assert.assertNotSame((Object)schema1, (Object)schema2);
        Assert.assertNotSame((Object)schema1, (Object)schema3);
        TestLogicalType.assertEqualsTrue("No logical types", schema1, schema2);
        TestLogicalType.assertEqualsTrue("No logical types", schema1, schema3);
        LogicalTypes.decimal((int)9).addToSchema(schema1);
        TestLogicalType.assertEqualsFalse("Two has no logical type", schema1, schema2);
        LogicalTypes.decimal((int)9).addToSchema(schema2);
        TestLogicalType.assertEqualsTrue("Same logical types", schema1, schema2);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema3);
        TestLogicalType.assertEqualsFalse("Different logical type", schema1, schema3);
    }

    public static void assertEqualsTrue(String message, Object o1, Object o2) {
        Assert.assertTrue((String)("Should be equal (forward): " + message), (boolean)o1.equals(o2));
        Assert.assertTrue((String)("Should be equal (reverse): " + message), (boolean)o2.equals(o1));
    }

    public static void assertEqualsFalse(String message, Object o1, Object o2) {
        Assert.assertFalse((String)("Should be equal (forward): " + message), (boolean)o1.equals(o2));
        Assert.assertFalse((String)("Should be equal (reverse): " + message), (boolean)o2.equals(o1));
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, String containedInMessage, Callable callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            Assert.assertEquals((String)message, expected, actual.getClass());
            Assert.assertTrue((String)("Expected exception message (" + containedInMessage + ") missing: " + actual.getMessage()), (boolean)actual.getMessage().contains(containedInMessage));
        }
    }
}

