/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.ArrayList;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestSchema {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testSplitSchemaBuild() {
        Schema s = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"HandshakeRequest").namespace("org.apache.avro.ipc")).fields().name("clientProtocol").type().optional().stringType()).name("meta").type().optional().map().values().bytesType()).endRecord();
        String schemaString = s.toString();
        int mid = schemaString.length() / 2;
        Schema parsedStringSchema = new Schema.Parser().parse(s.toString());
        Schema parsedArrayOfStringSchema = new Schema.Parser().parse(schemaString.substring(0, mid), new String[]{schemaString.substring(mid)});
        Assert.assertNotNull((Object)parsedStringSchema);
        Assert.assertNotNull((Object)parsedArrayOfStringSchema);
        Assert.assertEquals((Object)parsedStringSchema.toString(), (Object)parsedArrayOfStringSchema.toString());
    }

    @Test
    public void testDuplicateRecordFieldName() {
        Schema schema = Schema.createRecord((String)"RecordName", null, null, (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("field_name", Schema.create((Schema.Type)Schema.Type.NULL), null, null));
        fields.add(new Schema.Field("field_name", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        try {
            schema.setFields(fields);
            Assert.fail((String)"Should not be able to create a record with duplicate field name.");
        }
        catch (AvroRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Duplicate field field_name in record RecordName"));
        }
    }

    @Test
    public void testCreateUnionVarargs() {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        types.add(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema expected = Schema.createUnion(types);
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testEmptyRecordSchema() {
        Schema schema = Schema.createRecord((String)"foobar", null, null, (boolean)false);
        String schemaString = schema.toString();
        Assert.assertNotNull((Object)schemaString);
    }

    @Test
    public void testSchemaWithFields() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("field_name1", Schema.create((Schema.Type)Schema.Type.NULL), null, null));
        fields.add(new Schema.Field("field_name2", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        Schema schema = Schema.createRecord((String)"foobar", null, null, (boolean)false, fields);
        String schemaString = schema.toString();
        Assert.assertNotNull((Object)schemaString);
        Assert.assertEquals((long)2L, (long)schema.getFields().size());
    }

    @Test(expected=NullPointerException.class)
    public void testSchemaWithNullFields() {
        Schema.createRecord((String)"foobar", null, null, (boolean)false, null);
    }
}

