/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaBuilderException;
import org.apache.avro.SchemaParseException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.codehaus.jackson.node.NullNode;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaBuilder {
    private static final File DIR = new File(System.getProperty("test.dir", "/tmp"));
    private static final File FILE = new File(DIR, "test.avro");
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testRecord() {
        Schema schema = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("org.example")).aliases(new String[]{"oldrecord"})).fields().name("f0").aliases(new String[]{"f0alias"})).type().stringType().noDefault().name("f1").doc("This is f1")).type().longType().noDefault().name("f2").type().nullable().booleanType().booleanDefault(true).endRecord();
        Assert.assertEquals((Object)"myrecord", (Object)schema.getName());
        Assert.assertEquals((Object)"org.example", (Object)schema.getNamespace());
        Assert.assertEquals((Object)"org.example.oldrecord", schema.getAliases().iterator().next());
        Assert.assertFalse((boolean)schema.isError());
        List fields = schema.getFields();
        Assert.assertEquals((long)3L, (long)fields.size());
        Assert.assertEquals((Object)new Schema.Field("f0", Schema.create((Schema.Type)Schema.Type.STRING), null, null), fields.get(0));
        Assert.assertTrue((boolean)((Schema.Field)fields.get(0)).aliases().contains("f0alias"));
        Assert.assertEquals((Object)new Schema.Field("f1", Schema.create((Schema.Type)Schema.Type.LONG), "This is f1", null), fields.get(1));
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        Schema optional = Schema.createUnion(types);
        Assert.assertEquals((Object)new Schema.Field("f2", optional, null, (Object)true), fields.get(2));
    }

    @Test
    public void testDoc() {
        Schema s = (Schema)((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"myfixed").doc("mydoc")).size(1);
        Assert.assertEquals((Object)"mydoc", (Object)s.getDoc());
    }

    @Test
    public void testProps() {
        Schema s = (Schema)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("p1", "v1")).prop("p2", "v2")).prop("p2", "v2real")).endInt();
        int size = s.getProps().size();
        Assert.assertEquals((long)2L, (long)size);
        Assert.assertEquals((Object)"v1", (Object)s.getProp("p1"));
        Assert.assertEquals((Object)"v2real", (Object)s.getProp("p2"));
    }

    @Test
    public void testNamespaces() {
        Schema s1 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("org.example")).fields().name("myint").type().intType().noDefault().endRecord();
        Schema s2 = (Schema)SchemaBuilder.record((String)"org.example.myrecord").fields().name("myint").type().intType().noDefault().endRecord();
        Schema s3 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"org.example.myrecord").namespace("org.example2")).fields().name("myint").type().intType().noDefault().endRecord();
        Schema s4 = (Schema)SchemaBuilder.builder((String)"org.example").record("myrecord").fields().name("myint").type().intType().noDefault().endRecord();
        Assert.assertEquals((Object)"myrecord", (Object)s1.getName());
        Assert.assertEquals((Object)"myrecord", (Object)s2.getName());
        Assert.assertEquals((Object)"myrecord", (Object)s3.getName());
        Assert.assertEquals((Object)"myrecord", (Object)s4.getName());
        Assert.assertEquals((Object)"org.example", (Object)s1.getNamespace());
        Assert.assertEquals((Object)"org.example", (Object)s2.getNamespace());
        Assert.assertEquals((Object)"org.example", (Object)s3.getNamespace());
        Assert.assertEquals((Object)"org.example", (Object)s4.getNamespace());
        Assert.assertEquals((Object)"org.example.myrecord", (Object)s1.getFullName());
        Assert.assertEquals((Object)"org.example.myrecord", (Object)s2.getFullName());
        Assert.assertEquals((Object)"org.example.myrecord", (Object)s3.getFullName());
        Assert.assertEquals((Object)"org.example.myrecord", (Object)s4.getFullName());
    }

    @Test(expected=NullPointerException.class)
    public void testMissingRecordName() {
        SchemaBuilder.record(null).fields().name("f0").type().stringType().noDefault().endRecord();
    }

    @Test
    public void testBoolean() {
        Schema.Type type = Schema.Type.BOOLEAN;
        Schema simple = (Schema)SchemaBuilder.builder().booleanType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.BooleanBuilder)SchemaBuilder.builder().booleanBuilder().prop("p", "v")).endBoolean();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testInt() {
        Schema.Type type = Schema.Type.INT;
        Schema simple = (Schema)SchemaBuilder.builder().intType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("p", "v")).endInt();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testLong() {
        Schema.Type type = Schema.Type.LONG;
        Schema simple = (Schema)SchemaBuilder.builder().longType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.LongBuilder)SchemaBuilder.builder().longBuilder().prop("p", "v")).endLong();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testFloat() {
        Schema.Type type = Schema.Type.FLOAT;
        Schema simple = (Schema)SchemaBuilder.builder().floatType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.FloatBuilder)SchemaBuilder.builder().floatBuilder().prop("p", "v")).endFloat();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testDuble() {
        Schema.Type type = Schema.Type.DOUBLE;
        Schema simple = (Schema)SchemaBuilder.builder().doubleType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.DoubleBuilder)SchemaBuilder.builder().doubleBuilder().prop("p", "v")).endDouble();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testString() {
        Schema.Type type = Schema.Type.STRING;
        Schema simple = (Schema)SchemaBuilder.builder().stringType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("p", "v")).endString();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testBytes() {
        Schema.Type type = Schema.Type.BYTES;
        Schema simple = (Schema)SchemaBuilder.builder().bytesType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.BytesBuilder)SchemaBuilder.builder().bytesBuilder().prop("p", "v")).endBytes();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    public void testNull() {
        Schema.Type type = Schema.Type.NULL;
        Schema simple = (Schema)SchemaBuilder.builder().nullType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.NullBuilder)SchemaBuilder.builder().nullBuilder().prop("p", "v")).endNull();
        Assert.assertEquals((Object)expected, (Object)built1);
    }

    private Schema primitive(Schema.Type type, Schema bare) {
        Schema bareByName = (Schema)SchemaBuilder.builder().type(type.getName());
        Assert.assertEquals((Object)Schema.create((Schema.Type)type), (Object)bareByName);
        Assert.assertEquals((Object)bareByName, (Object)bare);
        Schema p = Schema.create((Schema.Type)type);
        p.addProp("p", "v");
        return p;
    }

    @Test
    public void testRecursiveRecord() {
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"LongList").fields().name("value").type().longType().noDefault().name("next").type().optional().type("LongList")).endRecord();
        Assert.assertEquals((Object)"LongList", (Object)schema.getName());
        List fields = schema.getFields();
        Assert.assertEquals((long)2L, (long)fields.size());
        Assert.assertEquals((Object)new Schema.Field("value", Schema.create((Schema.Type)Schema.Type.LONG), null, null), fields.get(0));
        Assert.assertEquals((Object)Schema.Type.UNION, (Object)((Schema.Field)fields.get(1)).schema().getType());
        Assert.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)((Schema.Field)fields.get(1)).schema().getTypes().get(0)).getType());
        Schema recordSchema = (Schema)((Schema.Field)fields.get(1)).schema().getTypes().get(1);
        Assert.assertEquals((Object)Schema.Type.RECORD, (Object)recordSchema.getType());
        Assert.assertEquals((Object)"LongList", (Object)recordSchema.getName());
        Assert.assertEquals((Object)NullNode.getInstance(), (Object)((Schema.Field)fields.get(1)).defaultValue());
    }

    @Test
    public void testEnum() {
        List<String> symbols = Arrays.asList("a", "b");
        Schema expected = Schema.createEnum((String)"myenum", null, null, symbols);
        expected.addProp("p", "v");
        Schema schema = (Schema)((SchemaBuilder.EnumBuilder)SchemaBuilder.enumeration((String)"myenum").prop("p", "v")).symbols(new String[]{"a", "b"});
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testFixed() {
        Schema expected = Schema.createFixed((String)"myfixed", null, null, (int)16);
        expected.addAlias("myOldFixed");
        Schema schema = (Schema)((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"myfixed").aliases(new String[]{"myOldFixed"})).size(16);
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testArray() {
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema expected = Schema.createArray((Schema)longSchema);
        Schema schema1 = (Schema)SchemaBuilder.array().items().longType();
        Assert.assertEquals((Object)expected, (Object)schema1);
        Schema schema2 = (Schema)SchemaBuilder.array().items(longSchema);
        Assert.assertEquals((Object)expected, (Object)schema2);
        Schema schema3 = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("p", "v")).items().type("long");
        expected.addProp("p", "v");
        Assert.assertEquals((Object)expected, (Object)schema3);
    }

    @Test
    public void testMap() {
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema expected = Schema.createMap((Schema)intSchema);
        Schema schema1 = (Schema)SchemaBuilder.map().values().intType();
        Assert.assertEquals((Object)expected, (Object)schema1);
        Schema schema2 = (Schema)SchemaBuilder.map().values(intSchema);
        Assert.assertEquals((Object)expected, (Object)schema2);
        Schema schema3 = (Schema)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("p", "v")).values().type("int");
        expected.addProp("p", "v");
        Assert.assertEquals((Object)expected, (Object)schema3);
    }

    @Test
    public void testUnionAndNullable() {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.LONG));
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        Schema expected = Schema.createUnion(types);
        Schema schema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().longType()).and().nullType()).endUnion();
        Assert.assertEquals((Object)expected, (Object)schema);
        schema = (Schema)SchemaBuilder.nullable().longType();
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testFields() {
        Schema rec = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"Rec").fields().name("documented").doc("documented")).type().nullType().noDefault().name("ascending").orderAscending().type().booleanType().noDefault().name("descending").orderDescending().type().floatType().noDefault().name("ignored").orderIgnore().type().doubleType().noDefault().name("aliased").aliases(new String[]{"anAlias"})).type().stringType().noDefault().endRecord();
        Assert.assertEquals((Object)"documented", (Object)rec.getField("documented").doc());
        Assert.assertEquals((Object)Schema.Field.Order.ASCENDING, (Object)rec.getField("ascending").order());
        Assert.assertEquals((Object)Schema.Field.Order.DESCENDING, (Object)rec.getField("descending").order());
        Assert.assertEquals((Object)Schema.Field.Order.IGNORE, (Object)rec.getField("ignored").order());
        Assert.assertTrue((boolean)rec.getField("aliased").aliases().contains("anAlias"));
    }

    @Test
    public void testFieldShortcuts() {
        Schema full = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"Blah").fields().name("rbool").type().booleanType().noDefault().name("obool").type().optional().booleanType()).name("nbool").type().nullable().booleanType().booleanDefault(true).name("rint").type().intType().noDefault().name("oint").type().optional().intType()).name("nint").type().nullable().intType().intDefault(1).name("rlong").type().longType().noDefault().name("olong").type().optional().longType()).name("nlong").type().nullable().longType().longDefault(2L).name("rfloat").type().floatType().noDefault().name("ofloat").type().optional().floatType()).name("nfloat").type().nullable().floatType().floatDefault(-1.1f).name("rdouble").type().doubleType().noDefault().name("odouble").type().optional().doubleType()).name("ndouble").type().nullable().doubleType().doubleDefault(99.9).name("rstring").type().stringType().noDefault().name("ostring").type().optional().stringType()).name("nstring").type().nullable().stringType().stringDefault("def").name("rbytes").type().bytesType().noDefault().name("obytes").type().optional().bytesType()).name("nbytes").type().nullable().bytesType().bytesDefault(new byte[]{1, 2, 3}).endRecord();
        Schema shortcut = (Schema)SchemaBuilder.record((String)"Blah").fields().requiredBoolean("rbool").optionalBoolean("obool").nullableBoolean("nbool", true).requiredInt("rint").optionalInt("oint").nullableInt("nint", 1).requiredLong("rlong").optionalLong("olong").nullableLong("nlong", 2L).requiredFloat("rfloat").optionalFloat("ofloat").nullableFloat("nfloat", -1.1f).requiredDouble("rdouble").optionalDouble("odouble").nullableDouble("ndouble", 99.9).requiredString("rstring").optionalString("ostring").nullableString("nstring", "def").requiredBytes("rbytes").optionalBytes("obytes").nullableBytes("nbytes", new byte[]{1, 2, 3}).endRecord();
        Assert.assertEquals((Object)full, (Object)shortcut);
    }

    @Test
    public void testNames() {
        Schema r = (Schema)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"Rec").fields().name("f0").type().fixed("org.foo.MyFixed").size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", __PARANAMER_DATA).noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().endRecord();
        Schema expected = Schema.createFixed((String)"org.foo.MyFixed", null, null, (int)1);
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        Schema f = (Schema)SchemaBuilder.builder((String)__PARANAMER_DATA).fixed("Foo").size(1);
        Assert.assertEquals((Object)Schema.createFixed((String)"Foo", null, null, (int)1), (Object)f);
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.foo")).fields().name("f0").type().fixed("MyFixed").size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", __PARANAMER_DATA).noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().name("f6").type("MyFixed", null).noDefault().name("f7").type("MyFixed").noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        this.checkField(r, expected, "f6");
        this.checkField(r, expected, "f7");
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.rec")).fields().name("f0").type().fixed("MyFixed").namespace("org.foo")).size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", __PARANAMER_DATA).noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        expected = Schema.createFixed((String)"MyFixed", null, null, (int)1);
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.rec")).fields().name("f0").type().fixed("MyFixed").namespace(__PARANAMER_DATA)).size(1)).noDefault().name("f1").type("MyFixed", __PARANAMER_DATA).noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        SchemaBuilder.fixed((String)"org.test.long").size(1);
        ((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"long").namespace("org.test")).size(1);
        SchemaBuilder.builder((String)"org.test").fixed("long").size(1);
    }

    private void checkField(Schema r, Schema expected, String name) {
        Assert.assertEquals((Object)expected, (Object)r.getField(name).schema());
    }

    @Test(expected=SchemaParseException.class)
    public void testNamesFailRedefined() {
        ((SchemaBuilder.EnumDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"Rec").fields().name("f0").type().enumeration("MyEnum").symbols(new String[]{"A", "B"})).enumDefault("A").name("f1").type().enumeration("MyEnum").symbols(new String[]{"X", "Y"})).noDefault().endRecord();
    }

    @Test(expected=SchemaParseException.class)
    public void testNamesFailAbsent() {
        SchemaBuilder.builder().type("notdefined");
    }

    @Test(expected=AvroTypeException.class)
    public void testNameReserved() {
        ((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"long").namespace(__PARANAMER_DATA)).size(1);
    }

    @Test
    public void testFieldTypesAndDefaultValues() {
        byte[] bytedef = new byte[]{3};
        ByteBuffer bufdef = ByteBuffer.wrap(bytedef);
        String strdef = "\u0003";
        HashMap<String, String> mapdef = new HashMap<String, String>();
        mapdef.put("a", "A");
        ArrayList<String> arrdef = new ArrayList<String>();
        arrdef.add("arr");
        Schema rec = (Schema)SchemaBuilder.record((String)"inner").fields().name("f").type().intType().noDefault().endRecord();
        Schema rec2 = (Schema)SchemaBuilder.record((String)"inner2").fields().name("f2").type().intType().noDefault().endRecord();
        GenericData.Record recdef = new GenericRecordBuilder(rec).set("f", (Object)1).build();
        GenericData.Record recdef2 = new GenericRecordBuilder(rec2).set("f2", (Object)2).build();
        Schema r = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.ArrayDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.MapDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.EnumDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.BytesDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.StringDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.DoubleDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FloatDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.LongDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.BooleanDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"r").fields().name("boolF").type().booleanType().booleanDefault(false).name("intF").type().intType().intDefault(1).name("longF").type().longType().longDefault(2L).name("floatF").type().floatType().floatDefault(3.0f).name("doubleF").type().doubleType().doubleDefault(4.0).name("stringF").type().stringType().stringDefault("def").name("bytesF1").type().bytesType().bytesDefault(bytedef).name("bytesF2").type().bytesType().bytesDefault(bufdef).name("bytesF3").type().bytesType().bytesDefault(strdef).name("nullF").type().nullType().nullDefault().name("fixedF1").type().fixed("F1").size(1)).fixedDefault(bytedef).name("fixedF2").type().fixed("F2").size(1)).fixedDefault(bufdef).name("fixedF3").type().fixed("F3").size(1)).fixedDefault(strdef).name("enumF").type().enumeration("E1").symbols(new String[]{"S"})).enumDefault("S").name("mapF").type().map().values().stringType()).mapDefault(mapdef).name("arrayF").type().array().items().stringType()).arrayDefault(arrdef).name("recordF").type().record("inner").fields().name("f").type().intType().noDefault().endRecord()).recordDefault((GenericRecord)recdef).name("byName").type("E1").withDefault((Object)"S").name("boolU").type().unionOf().booleanType().and().intType()).endUnion()).booleanDefault(false).name("intU").type().unionOf().intType().and().longType()).endUnion()).intDefault(1).name("longU").type().unionOf().longType().and().intType()).endUnion()).longDefault(2L).name("floatU").type().unionOf().floatType().and().intType()).endUnion()).floatDefault(3.0f).name("doubleU").type().unionOf().doubleType().and().intType()).endUnion()).doubleDefault(4.0).name("stringU").type().unionOf().stringType().and().intType()).endUnion()).stringDefault("def").name("bytesU").type().unionOf().bytesType().and().intType()).endUnion()).bytesDefault(bytedef).name("nullU").type().unionOf().nullType().and().intType()).endUnion()).nullDefault().name("fixedU").type().unionOf().fixed("F4").size(1)).and().intType()).endUnion()).fixedDefault(bytedef).name("enumU").type().unionOf().enumeration("E2").symbols(new String[]{"SS"})).and().intType()).endUnion()).enumDefault("SS").name("mapU").type().unionOf().map().values().stringType()).and().intType()).endUnion()).mapDefault(mapdef).name("arrayU").type().unionOf().array().items().stringType()).and().intType()).endUnion()).arrayDefault(arrdef).name("recordU").type().unionOf().record("inner2").fields().name("f2").type().intType().noDefault().endRecord()).and().intType()).endUnion()).recordDefault((GenericRecord)recdef2).endRecord();
        GenericData.Record newRec = new GenericRecordBuilder(r).build();
        Assert.assertEquals((Object)false, (Object)newRec.get("boolF"));
        Assert.assertEquals((Object)false, (Object)newRec.get("boolU"));
        Assert.assertEquals((Object)1, (Object)newRec.get("intF"));
        Assert.assertEquals((Object)1, (Object)newRec.get("intU"));
        Assert.assertEquals((Object)2L, (Object)newRec.get("longF"));
        Assert.assertEquals((Object)2L, (Object)newRec.get("longU"));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)newRec.get("floatF"));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)newRec.get("floatU"));
        Assert.assertEquals((Object)4.0, (Object)newRec.get("doubleF"));
        Assert.assertEquals((Object)4.0, (Object)newRec.get("doubleU"));
        Assert.assertEquals((Object)"def", (Object)newRec.get("stringF").toString());
        Assert.assertEquals((Object)"def", (Object)newRec.get("stringU").toString());
        Assert.assertEquals((Object)bufdef, (Object)newRec.get("bytesF1"));
        Assert.assertEquals((Object)bufdef, (Object)newRec.get("bytesF2"));
        Assert.assertEquals((Object)bufdef, (Object)newRec.get("bytesF3"));
        Assert.assertEquals((Object)bufdef, (Object)newRec.get("bytesU"));
        Assert.assertNull((Object)newRec.get("nullF"));
        Assert.assertNull((Object)newRec.get("nullU"));
        Assert.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF1")).bytes());
        Assert.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF2")).bytes());
        Assert.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF3")).bytes());
        Assert.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedU")).bytes());
        Assert.assertEquals((Object)"S", (Object)newRec.get("enumF").toString());
        Assert.assertEquals((Object)"SS", (Object)newRec.get("enumU").toString());
        Map map = (Map)newRec.get("mapF");
        Assert.assertEquals((long)mapdef.size(), (long)map.size());
        for (Map.Entry e : map.entrySet()) {
            Assert.assertEquals(mapdef.get(((CharSequence)e.getKey()).toString()), (Object)((CharSequence)e.getValue()).toString());
        }
        Assert.assertEquals((Object)newRec.get("mapF"), (Object)newRec.get("mapU"));
        GenericData.Array arr = (GenericData.Array)newRec.get("arrayF");
        Assert.assertEquals((long)arrdef.size(), (long)arr.size());
        for (CharSequence c : arr) {
            Assert.assertTrue((boolean)arrdef.contains(c.toString()));
        }
        Assert.assertEquals((Object)newRec.get("arrF"), (Object)newRec.get("arrU"));
        Assert.assertEquals((Object)recdef, (Object)newRec.get("recordF"));
        Assert.assertEquals((Object)recdef2, (Object)newRec.get("recordU"));
        Assert.assertEquals((Object)"S", (Object)newRec.get("byName").toString());
    }

    @Test(expected=SchemaBuilderException.class)
    public void testBadDefault() {
        SchemaBuilder.record((String)"r").fields().name("f").type(Schema.create((Schema.Type)Schema.Type.INT)).withDefault(new Object()).endRecord();
    }

    @Test
    public void testUnionFieldBuild() {
        ((SchemaBuilder.BooleanDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"r").fields().name("allUnion").type().unionOf().booleanType().and().intType()).and().longType()).and().floatType()).and().doubleType()).and().stringType()).and().bytesType()).and().nullType()).and().fixed("Fix").size(1)).and().enumeration("Enu").symbols(new String[]{"Q"})).and().array().items().intType()).and().map().values().longType()).and().record("Rec").fields().name("one").type("Fix").noDefault().endRecord()).endUnion()).booleanDefault(false).endRecord();
    }

    @Test
    public void testDefaults() throws IOException {
        Schema writeSchema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"r").fields().name("requiredInt").type().intType().noDefault().name("optionalInt").type().optional().intType()).name("nullableIntWithDefault").type().nullable().intType().intDefault(3).endRecord();
        GenericData.Record rec1 = new GenericRecordBuilder(writeSchema).set("requiredInt", (Object)1).build();
        Assert.assertEquals((Object)1, (Object)rec1.get("requiredInt"));
        Assert.assertEquals(null, (Object)rec1.get("optionalInt"));
        Assert.assertEquals((Object)3, (Object)rec1.get("nullableIntWithDefault"));
        GenericData.Record rec2 = new GenericRecordBuilder(writeSchema).set("requiredInt", (Object)1).set("optionalInt", (Object)2).set("nullableIntWithDefault", (Object)13).build();
        Assert.assertEquals((Object)1, (Object)rec2.get("requiredInt"));
        Assert.assertEquals((Object)2, (Object)rec2.get("optionalInt"));
        Assert.assertEquals((Object)13, (Object)rec2.get("nullableIntWithDefault"));
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.create(writeSchema, FILE);
        writer.append((Object)rec1);
        writer.append((Object)rec2);
        writer.close();
        Schema readSchema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"r").fields().name("requiredInt").type().intType().noDefault().name("optionalInt").type().optional().intType()).name("nullableIntWithDefault").type().nullable().intType().intDefault(3).name("newOptionalInt").type().optional().intType()).name("newNullableIntWithDefault").type().nullable().intType().intDefault(5).endRecord();
        DataFileReader reader = new DataFileReader(FILE, (DatumReader)new GenericDatumReader(writeSchema, readSchema));
        GenericData.Record rec1read = (GenericData.Record)reader.iterator().next();
        Assert.assertEquals((Object)1, (Object)rec1read.get("requiredInt"));
        Assert.assertEquals(null, (Object)rec1read.get("optionalInt"));
        Assert.assertEquals((Object)3, (Object)rec1read.get("nullableIntWithDefault"));
        Assert.assertEquals(null, (Object)rec1read.get("newOptionalInt"));
        Assert.assertEquals((Object)5, (Object)rec1read.get("newNullableIntWithDefault"));
        GenericData.Record rec2read = (GenericData.Record)reader.iterator().next();
        Assert.assertEquals((Object)1, (Object)rec2read.get("requiredInt"));
        Assert.assertEquals((Object)2, (Object)rec2read.get("optionalInt"));
        Assert.assertEquals((Object)13, (Object)rec2read.get("nullableIntWithDefault"));
        Assert.assertEquals(null, (Object)rec2read.get("newOptionalInt"));
        Assert.assertEquals((Object)5, (Object)rec2read.get("newNullableIntWithDefault"));
    }

    @Test
    public void testDefaultTypes() {
        Integer intDef = 1;
        Long longDef = 2L;
        Float floatDef = Float.valueOf(3.0f);
        Double doubleDef = 4.0;
        Schema schema = (Schema)SchemaBuilder.record((String)"r").fields().name("int").type().intType().intDefault(intDef.intValue()).name("long").type().longType().longDefault(longDef.longValue()).name("float").type().floatType().floatDefault(floatDef.floatValue()).name("double").type().doubleType().doubleDefault(doubleDef.doubleValue()).endRecord();
        Assert.assertEquals((String)"int field default type or value mismatch", (Object)intDef, (Object)schema.getField("int").defaultVal());
        Assert.assertEquals((String)"long field default type or value mismatch", (Object)longDef, (Object)schema.getField("long").defaultVal());
        Assert.assertEquals((String)"float field default type or value mismatch", (Object)floatDef, (Object)schema.getField("float").defaultVal());
        Assert.assertEquals((String)"double field default type or value mismatch", (Object)doubleDef, (Object)schema.getField("double").defaultVal());
    }
}

