/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSchemaCompatibility {
    private static final Logger LOG = LoggerFactory.getLogger(TestSchemaCompatibility.class);
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final Schema BOOLEAN_SCHEMA = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    private static final Schema INT_SCHEMA = Schema.create((Schema.Type)Schema.Type.INT);
    private static final Schema LONG_SCHEMA = Schema.create((Schema.Type)Schema.Type.LONG);
    private static final Schema FLOAT_SCHEMA = Schema.create((Schema.Type)Schema.Type.FLOAT);
    private static final Schema DOUBLE_SCHEMA = Schema.create((Schema.Type)Schema.Type.DOUBLE);
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    private static final Schema BYTES_SCHEMA = Schema.create((Schema.Type)Schema.Type.BYTES);
    private static final Schema INT_ARRAY_SCHEMA = Schema.createArray((Schema)INT_SCHEMA);
    private static final Schema LONG_ARRAY_SCHEMA = Schema.createArray((Schema)LONG_SCHEMA);
    private static final Schema STRING_ARRAY_SCHEMA = Schema.createArray((Schema)STRING_SCHEMA);
    private static final Schema INT_MAP_SCHEMA = Schema.createMap((Schema)INT_SCHEMA);
    private static final Schema LONG_MAP_SCHEMA = Schema.createMap((Schema)LONG_SCHEMA);
    private static final Schema STRING_MAP_SCHEMA = Schema.createMap((Schema)STRING_SCHEMA);
    private static final Schema ENUM1_AB_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemaCompatibility.list("A", "B"));
    private static final Schema ENUM1_ABC_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemaCompatibility.list("A", "B", "C"));
    private static final Schema ENUM1_BC_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemaCompatibility.list("B", "C"));
    private static final Schema ENUM2_AB_SCHEMA = Schema.createEnum((String)"Enum2", null, null, TestSchemaCompatibility.list("A", "B"));
    private static final Schema EMPTY_UNION_SCHEMA = Schema.createUnion(new ArrayList());
    private static final Schema NULL_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(NULL_SCHEMA));
    private static final Schema INT_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(INT_SCHEMA));
    private static final Schema LONG_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(LONG_SCHEMA));
    private static final Schema STRING_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(STRING_SCHEMA));
    private static final Schema INT_STRING_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(INT_SCHEMA, STRING_SCHEMA));
    private static final Schema STRING_INT_UNION_SCHEMA = Schema.createUnion(TestSchemaCompatibility.list(STRING_SCHEMA, INT_SCHEMA));
    private static final Schema EMPTY_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema EMPTY_RECORD2 = Schema.createRecord((String)"Record2", null, null, (boolean)false);
    private static final Schema A_INT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema A_LONG_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema A_INT_B_INT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema A_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema A_INT_B_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema A_DINT_B_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
    private static final Schema INT_LIST_RECORD;
    private static final Schema LONG_LIST_RECORD;
    private static final Schema WRITER_SCHEMA;
    public static final List<ReaderWriter> COMPATIBLE_READER_WRITER_TEST_CASES;
    public static final List<ReaderWriter> INCOMPATIBLE_READER_WRITER_TEST_CASES;
    public static final List<DecodingTestCase> DECODING_COMPATIBILITY_TEST_CASES;
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testValidateSchemaPairMissingField() throws Exception {
        ArrayList<Schema.Field> readerFields = TestSchemaCompatibility.list(new Schema.Field("oldfield1", INT_SCHEMA, null, null));
        Schema reader = Schema.createRecord(readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assert.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    public void testValidateSchemaPairMissingSecondField() throws Exception {
        ArrayList<Schema.Field> readerFields = TestSchemaCompatibility.list(new Schema.Field("oldfield2", STRING_SCHEMA, null, null));
        Schema reader = Schema.createRecord(readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assert.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    public void testValidateSchemaPairAllFields() throws Exception {
        ArrayList<Schema.Field> readerFields = TestSchemaCompatibility.list(new Schema.Field("oldfield1", INT_SCHEMA, null, null), new Schema.Field("oldfield2", STRING_SCHEMA, null, null));
        Schema reader = Schema.createRecord(readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assert.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    public void testValidateSchemaNewFieldWithDefault() throws Exception {
        ArrayList<Schema.Field> readerFields = TestSchemaCompatibility.list(new Schema.Field("oldfield1", INT_SCHEMA, null, null), new Schema.Field("newfield1", INT_SCHEMA, null, (Object)42));
        Schema reader = Schema.createRecord(readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, reader, WRITER_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        Assert.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    public void testValidateSchemaNewField() throws Exception {
        ArrayList<Schema.Field> readerFields = TestSchemaCompatibility.list(new Schema.Field("oldfield1", INT_SCHEMA, null, null), new Schema.Field("newfield1", INT_SCHEMA, null, null));
        Schema reader = Schema.createRecord(readerFields);
        SchemaCompatibility.SchemaPairCompatibility expectedResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, reader, WRITER_SCHEMA, String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", WRITER_SCHEMA.toString(true), reader.toString(true)));
        Assert.assertEquals((Object)expectedResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)WRITER_SCHEMA));
    }

    @Test
    public void testValidateArrayWriterSchema() throws Exception {
        Schema validReader = Schema.createArray((Schema)STRING_SCHEMA);
        Schema invalidReader = Schema.createMap((Schema)STRING_SCHEMA);
        SchemaCompatibility.SchemaPairCompatibility validResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, validReader, STRING_ARRAY_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        SchemaCompatibility.SchemaPairCompatibility invalidResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, invalidReader, STRING_ARRAY_SCHEMA, String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", STRING_ARRAY_SCHEMA.toString(true), invalidReader.toString(true)));
        Assert.assertEquals((Object)validResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)validReader, (Schema)STRING_ARRAY_SCHEMA));
        Assert.assertEquals((Object)invalidResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)invalidReader, (Schema)STRING_ARRAY_SCHEMA));
    }

    @Test
    public void testValidatePrimitiveWriterSchema() throws Exception {
        Schema validReader = Schema.create((Schema.Type)Schema.Type.STRING);
        SchemaCompatibility.SchemaPairCompatibility validResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, validReader, STRING_SCHEMA, "Reader schema can always successfully decode data written using the writer schema.");
        SchemaCompatibility.SchemaPairCompatibility invalidResult = new SchemaCompatibility.SchemaPairCompatibility(SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, INT_SCHEMA, STRING_SCHEMA, String.format("Data encoded using writer schema:%n%s%nwill or may fail to decode using reader schema:%n%s%n", STRING_SCHEMA.toString(true), INT_SCHEMA.toString(true)));
        Assert.assertEquals((Object)validResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)validReader, (Schema)STRING_SCHEMA));
        Assert.assertEquals((Object)invalidResult, (Object)SchemaCompatibility.checkReaderWriterCompatibility((Schema)INT_SCHEMA, (Schema)STRING_SCHEMA));
    }

    @Test
    public void testUnionReaderWriterSubsetIncompatibility() {
        Schema unionWriter = Schema.createUnion(TestSchemaCompatibility.list(INT_SCHEMA, STRING_SCHEMA));
        Schema unionReader = Schema.createUnion(TestSchemaCompatibility.list(STRING_SCHEMA));
        SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)unionReader, (Schema)unionWriter);
        Assert.assertEquals((Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)result.getType());
    }

    @Test
    public void testReaderWriterCompatibility() {
        for (ReaderWriter readerWriter : COMPATIBLE_READER_WRITER_TEST_CASES) {
            Schema reader = readerWriter.getReader();
            Schema writer = readerWriter.getWriter();
            LOG.debug("Testing compatibility of reader {} with writer {}.", (Object)reader, (Object)writer);
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)writer);
            Assert.assertEquals((String)String.format("Expecting reader %s to be compatible with writer %s, but tested incompatible.", reader, writer), (Object)SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE, (Object)result.getType());
        }
    }

    @Test
    public void testReaderWriterIncompatibility() {
        for (ReaderWriter readerWriter : INCOMPATIBLE_READER_WRITER_TEST_CASES) {
            Schema reader = readerWriter.getReader();
            Schema writer = readerWriter.getWriter();
            LOG.debug("Testing incompatibility of reader {} with writer {}.", (Object)reader, (Object)writer);
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)reader, (Schema)writer);
            Assert.assertEquals((String)String.format("Expecting reader %s to be incompatible with writer %s, but tested compatible.", reader, writer), (Object)SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE, (Object)result.getType());
        }
    }

    @Test
    public void testReaderWriterDecodingCompatibility() throws Exception {
        for (DecodingTestCase testCase : DECODING_COMPATIBILITY_TEST_CASES) {
            Schema readerSchema = testCase.getReaderSchema();
            Schema writerSchema = testCase.getWriterSchema();
            Object datum = testCase.getDatum();
            Object expectedDecodedDatum = testCase.getDecodedDatum();
            LOG.debug("Testing incompatibility of reader {} with writer {}.", (Object)readerSchema, (Object)writerSchema);
            LOG.debug("Encode datum {} with writer {}.", datum, (Object)writerSchema);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            GenericDatumWriter datumWriter = new GenericDatumWriter(writerSchema);
            datumWriter.write(datum, (Encoder)encoder);
            encoder.flush();
            LOG.debug("Decode datum {} whose writer is {} with reader {}.", new Object[]{datum, writerSchema, readerSchema});
            byte[] bytes = baos.toByteArray();
            ResolvingDecoder decoder = DecoderFactory.get().resolvingDecoder(writerSchema, readerSchema, (Decoder)DecoderFactory.get().binaryDecoder(bytes, null));
            GenericDatumReader datumReader = new GenericDatumReader(readerSchema);
            Object decodedDatum = datumReader.read(null, (Decoder)decoder);
            Assert.assertEquals((String)String.format("Expecting decoded value %s when decoding value %s whose writer schema is %s using reader schema %s, but value was %s.", expectedDecodedDatum, datum, writerSchema, readerSchema, decodedDatum), (Object)expectedDecodedDatum, (Object)decodedDatum);
        }
    }

    private static <E> ArrayList<E> list(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    static {
        EMPTY_RECORD1.setFields(Collections.emptyList());
        EMPTY_RECORD2.setFields(Collections.emptyList());
        A_INT_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", INT_SCHEMA, null, null)));
        A_LONG_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", LONG_SCHEMA, null, null)));
        A_INT_B_INT_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", INT_SCHEMA, null, null), new Schema.Field("b", INT_SCHEMA, null, null)));
        A_DINT_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0)));
        A_INT_B_DINT_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", INT_SCHEMA, null, null), new Schema.Field("b", INT_SCHEMA, null, (Object)0)));
        A_DINT_B_DINT_RECORD1.setFields(TestSchemaCompatibility.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", INT_SCHEMA, null, (Object)0)));
        INT_LIST_RECORD = Schema.createRecord((String)"List", null, null, (boolean)false);
        LONG_LIST_RECORD = Schema.createRecord((String)"List", null, null, (boolean)false);
        INT_LIST_RECORD.setFields(TestSchemaCompatibility.list(new Schema.Field("head", INT_SCHEMA, null, null), new Schema.Field("tail", INT_LIST_RECORD, null, null)));
        LONG_LIST_RECORD.setFields(TestSchemaCompatibility.list(new Schema.Field("head", LONG_SCHEMA, null, null), new Schema.Field("tail", LONG_LIST_RECORD, null, null)));
        WRITER_SCHEMA = Schema.createRecord(TestSchemaCompatibility.list(new Schema.Field("oldfield1", INT_SCHEMA, null, null), new Schema.Field("oldfield2", STRING_SCHEMA, null, null)));
        COMPATIBLE_READER_WRITER_TEST_CASES = TestSchemaCompatibility.list(new ReaderWriter(BOOLEAN_SCHEMA, BOOLEAN_SCHEMA), new ReaderWriter(INT_SCHEMA, INT_SCHEMA), new ReaderWriter(LONG_SCHEMA, INT_SCHEMA), new ReaderWriter(LONG_SCHEMA, LONG_SCHEMA), new ReaderWriter(FLOAT_SCHEMA, INT_SCHEMA), new ReaderWriter(FLOAT_SCHEMA, LONG_SCHEMA), new ReaderWriter(DOUBLE_SCHEMA, LONG_SCHEMA), new ReaderWriter(DOUBLE_SCHEMA, INT_SCHEMA), new ReaderWriter(DOUBLE_SCHEMA, FLOAT_SCHEMA), new ReaderWriter(STRING_SCHEMA, STRING_SCHEMA), new ReaderWriter(BYTES_SCHEMA, BYTES_SCHEMA), new ReaderWriter(INT_ARRAY_SCHEMA, INT_ARRAY_SCHEMA), new ReaderWriter(LONG_ARRAY_SCHEMA, INT_ARRAY_SCHEMA), new ReaderWriter(INT_MAP_SCHEMA, INT_MAP_SCHEMA), new ReaderWriter(LONG_MAP_SCHEMA, INT_MAP_SCHEMA), new ReaderWriter(ENUM1_AB_SCHEMA, ENUM1_AB_SCHEMA), new ReaderWriter(ENUM1_ABC_SCHEMA, ENUM1_AB_SCHEMA), new ReaderWriter(STRING_SCHEMA, BYTES_SCHEMA), new ReaderWriter(BYTES_SCHEMA, STRING_SCHEMA), new ReaderWriter(EMPTY_UNION_SCHEMA, EMPTY_UNION_SCHEMA), new ReaderWriter(INT_UNION_SCHEMA, INT_UNION_SCHEMA), new ReaderWriter(INT_STRING_UNION_SCHEMA, STRING_INT_UNION_SCHEMA), new ReaderWriter(INT_UNION_SCHEMA, EMPTY_UNION_SCHEMA), new ReaderWriter(LONG_UNION_SCHEMA, INT_UNION_SCHEMA), new ReaderWriter(INT_UNION_SCHEMA, INT_SCHEMA), new ReaderWriter(INT_SCHEMA, INT_UNION_SCHEMA), new ReaderWriter(EMPTY_RECORD1, EMPTY_RECORD1), new ReaderWriter(EMPTY_RECORD1, A_INT_RECORD1), new ReaderWriter(A_INT_RECORD1, A_INT_RECORD1), new ReaderWriter(A_DINT_RECORD1, A_INT_RECORD1), new ReaderWriter(A_DINT_RECORD1, A_DINT_RECORD1), new ReaderWriter(A_INT_RECORD1, A_DINT_RECORD1), new ReaderWriter(A_LONG_RECORD1, A_INT_RECORD1), new ReaderWriter(A_INT_RECORD1, A_INT_B_INT_RECORD1), new ReaderWriter(A_DINT_RECORD1, A_INT_B_INT_RECORD1), new ReaderWriter(A_INT_B_DINT_RECORD1, A_INT_RECORD1), new ReaderWriter(A_DINT_B_DINT_RECORD1, EMPTY_RECORD1), new ReaderWriter(A_DINT_B_DINT_RECORD1, A_INT_RECORD1), new ReaderWriter(A_INT_B_INT_RECORD1, A_DINT_B_DINT_RECORD1), new ReaderWriter(INT_LIST_RECORD, INT_LIST_RECORD), new ReaderWriter(LONG_LIST_RECORD, LONG_LIST_RECORD), new ReaderWriter(LONG_LIST_RECORD, INT_LIST_RECORD), new ReaderWriter(NULL_SCHEMA, NULL_SCHEMA));
        INCOMPATIBLE_READER_WRITER_TEST_CASES = TestSchemaCompatibility.list(new ReaderWriter(NULL_SCHEMA, INT_SCHEMA), new ReaderWriter(NULL_SCHEMA, LONG_SCHEMA), new ReaderWriter(BOOLEAN_SCHEMA, INT_SCHEMA), new ReaderWriter(INT_SCHEMA, NULL_SCHEMA), new ReaderWriter(INT_SCHEMA, BOOLEAN_SCHEMA), new ReaderWriter(INT_SCHEMA, LONG_SCHEMA), new ReaderWriter(INT_SCHEMA, FLOAT_SCHEMA), new ReaderWriter(INT_SCHEMA, DOUBLE_SCHEMA), new ReaderWriter(LONG_SCHEMA, FLOAT_SCHEMA), new ReaderWriter(LONG_SCHEMA, DOUBLE_SCHEMA), new ReaderWriter(FLOAT_SCHEMA, DOUBLE_SCHEMA), new ReaderWriter(STRING_SCHEMA, BOOLEAN_SCHEMA), new ReaderWriter(STRING_SCHEMA, INT_SCHEMA), new ReaderWriter(BYTES_SCHEMA, NULL_SCHEMA), new ReaderWriter(BYTES_SCHEMA, INT_SCHEMA), new ReaderWriter(INT_ARRAY_SCHEMA, LONG_ARRAY_SCHEMA), new ReaderWriter(INT_MAP_SCHEMA, INT_ARRAY_SCHEMA), new ReaderWriter(INT_ARRAY_SCHEMA, INT_MAP_SCHEMA), new ReaderWriter(INT_MAP_SCHEMA, LONG_MAP_SCHEMA), new ReaderWriter(ENUM1_AB_SCHEMA, ENUM1_ABC_SCHEMA), new ReaderWriter(ENUM1_BC_SCHEMA, ENUM1_ABC_SCHEMA), new ReaderWriter(ENUM1_AB_SCHEMA, ENUM2_AB_SCHEMA), new ReaderWriter(INT_SCHEMA, ENUM2_AB_SCHEMA), new ReaderWriter(ENUM2_AB_SCHEMA, INT_SCHEMA), new ReaderWriter(INT_UNION_SCHEMA, INT_STRING_UNION_SCHEMA), new ReaderWriter(STRING_UNION_SCHEMA, INT_STRING_UNION_SCHEMA), new ReaderWriter(EMPTY_RECORD2, EMPTY_RECORD1), new ReaderWriter(A_INT_RECORD1, EMPTY_RECORD1), new ReaderWriter(A_INT_B_DINT_RECORD1, EMPTY_RECORD1), new ReaderWriter(INT_LIST_RECORD, LONG_LIST_RECORD), new ReaderWriter(NULL_SCHEMA, INT_SCHEMA));
        DECODING_COMPATIBILITY_TEST_CASES = TestSchemaCompatibility.list(new DecodingTestCase(INT_SCHEMA, 1, INT_SCHEMA, 1), new DecodingTestCase(INT_SCHEMA, 1, LONG_SCHEMA, 1L), new DecodingTestCase(INT_SCHEMA, 1, FLOAT_SCHEMA, Float.valueOf(1.0f)), new DecodingTestCase(INT_SCHEMA, 1, DOUBLE_SCHEMA, 1.0), new DecodingTestCase(INT_SCHEMA, 0x1000001, FLOAT_SCHEMA, Float.valueOf(1.6777216E7f)), new DecodingTestCase(ENUM1_AB_SCHEMA, new GenericData.EnumSymbol(ENUM1_AB_SCHEMA, "A"), ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(ENUM1_ABC_SCHEMA, "A")), new DecodingTestCase(ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(ENUM1_ABC_SCHEMA, "A"), ENUM1_AB_SCHEMA, new GenericData.EnumSymbol(ENUM1_AB_SCHEMA, "A")), new DecodingTestCase(ENUM1_ABC_SCHEMA, new GenericData.EnumSymbol(ENUM1_ABC_SCHEMA, "B"), ENUM1_BC_SCHEMA, new GenericData.EnumSymbol(ENUM1_BC_SCHEMA, "B")), new DecodingTestCase(INT_STRING_UNION_SCHEMA, "the string", STRING_SCHEMA, new Utf8("the string")), new DecodingTestCase(INT_STRING_UNION_SCHEMA, "the string", STRING_UNION_SCHEMA, new Utf8("the string")));
    }

    private static final class DecodingTestCase {
        private final Schema mWriterSchema;
        private final Object mDatum;
        private final Schema mReaderSchema;
        private final Object mDecodedDatum;
        public static final String __PARANAMER_DATA = "<init> Schema,java.lang.Object,Schema,java.lang.Object writerSchema,datum,readerSchema,decoded \n";

        public DecodingTestCase(Schema writerSchema, Object datum, Schema readerSchema, Object decoded) {
            this.mWriterSchema = writerSchema;
            this.mDatum = datum;
            this.mReaderSchema = readerSchema;
            this.mDecodedDatum = decoded;
        }

        public Schema getReaderSchema() {
            return this.mReaderSchema;
        }

        public Schema getWriterSchema() {
            return this.mWriterSchema;
        }

        public Object getDatum() {
            return this.mDatum;
        }

        public Object getDecodedDatum() {
            return this.mDecodedDatum;
        }
    }

    private static final class ReaderWriter {
        private final Schema mReader;
        private final Schema mWriter;
        public static final String __PARANAMER_DATA = "<init> Schema,Schema reader,writer \n";

        public ReaderWriter(Schema reader, Schema writer) {
            this.mReader = reader;
            this.mWriter = writer;
        }

        public Schema getReader() {
            return this.mReader;
        }

        public Schema getWriter() {
            return this.mWriter;
        }
    }
}

