/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.util.CaseFinder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class TestSchemaNormalization {
    private static String DATA_FILE = System.getProperty("share.dir", "../../../share") + "/test/data/schema-tests.txt";
    private static final long ONE = Long.MIN_VALUE;
    private static final byte[] POSTFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final String __PARANAMER_DATA = "altFingerprint java.lang.String s \n";

    private static BufferedReader data() throws IOException {
        return new BufferedReader(new FileReader(DATA_FILE));
    }

    public static long altFingerprint(String s) {
        try {
            long tmp = TestSchemaNormalization.altExtend(-4513414715797952619L, 64, Long.MIN_VALUE, s.getBytes("UTF-8"));
            return TestSchemaNormalization.altExtend(-4513414715797952619L, 64, tmp, POSTFIX);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static long altExtend(long poly, int degree, long fp, byte[] b) {
        long overflowBit = 1L << 64 - degree;
        for (int i = 0; i < b.length; ++i) {
            for (int j = 1; j < 129; j <<= 1) {
                boolean overflow = 0L != (fp & overflowBit);
                fp >>>= 1;
                if (0 != (j & b[i])) {
                    fp |= Long.MIN_VALUE;
                }
                if (!overflow) continue;
                fp ^= poly;
            }
        }
        return fp;
    }

    private static void assertEqHex(long expected, long actual) {
        String m = TestSchemaNormalization.format("0x%016x != 0x%016x", expected, actual).toString();
        Assert.assertTrue((String)m, (expected == actual ? 1 : 0) != 0);
    }

    private static String format(String f, Object ... args) {
        return new Formatter().format(f, args).toString();
    }

    @RunWith(value=Parameterized.class)
    public static class TestFingerprintInternationalization {
        String input;
        String expectedOutput;
        public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String i,o \n";

        public TestFingerprintInternationalization(String i, String o) {
            this.input = i;
            this.expectedOutput = o;
        }

        @Parameterized.Parameters
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "fingerprint", new ArrayList<Object[]>());
        }

        @Test
        public void testCanonicalization() throws Exception {
            Locale originalDefaultLocale = Locale.getDefault();
            Locale.setDefault(Locale.forLanguageTag("tr"));
            Schema s = Schema.parse((String)this.input);
            long carefulFP = TestSchemaNormalization.altFingerprint(SchemaNormalization.toParsingForm((Schema)s));
            Assert.assertEquals((long)carefulFP, (long)Long.parseLong(this.expectedOutput));
            TestSchemaNormalization.assertEqHex(carefulFP, SchemaNormalization.parsingFingerprint64((Schema)s));
            Locale.setDefault(originalDefaultLocale);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TestFingerprint {
        String input;
        String expectedOutput;
        public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String i,o \n";

        public TestFingerprint(String i, String o) {
            this.input = i;
            this.expectedOutput = o;
        }

        @Parameterized.Parameters
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "fingerprint", new ArrayList<Object[]>());
        }

        @Test
        public void testCanonicalization() throws Exception {
            Schema s = Schema.parse((String)this.input);
            long carefulFP = TestSchemaNormalization.altFingerprint(SchemaNormalization.toParsingForm((Schema)s));
            Assert.assertEquals((long)carefulFP, (long)Long.parseLong(this.expectedOutput));
            TestSchemaNormalization.assertEqHex(carefulFP, SchemaNormalization.parsingFingerprint64((Schema)s));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TestCanonical {
        String input;
        String expectedOutput;
        public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String i,o \n";

        public TestCanonical(String i, String o) {
            this.input = i;
            this.expectedOutput = o;
        }

        @Parameterized.Parameters
        public static List<Object[]> cases() throws IOException {
            return CaseFinder.find(TestSchemaNormalization.data(), "canonical", new ArrayList<Object[]>());
        }

        @Test
        public void testCanonicalization() throws Exception {
            Assert.assertEquals((Object)SchemaNormalization.toParsingForm((Schema)Schema.parse((String)this.input)), (Object)this.expectedOutput);
        }
    }
}

