/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.reflect.ReflectData;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaValidation {
    SchemaValidatorBuilder builder = new SchemaValidatorBuilder();
    Schema rec = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().intType().intDefault(1).name("b").type().longType().noDefault().endRecord();
    Schema rec2 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().intType().intDefault(1).name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    Schema rec3 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    Schema rec4 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("b").type().longType().noDefault().name("c").type().intType().noDefault().endRecord();
    Schema rec5 = (Schema)SchemaBuilder.record((String)"test.Rec").fields().name("a").type().stringType().stringDefault("").name("b").type().longType().noDefault().name("c").type().intType().intDefault(0).endRecord();
    public static final Schema circleSchema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"Circle").fields().name("center").type().record("Point").fields().requiredDouble("x").requiredDouble("y").endRecord()).noDefault().requiredDouble("radius").endRecord();
    public static final Schema circleSchemaDifferentNames = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"crcl").fields().name("center").type().record("pt").fields().requiredDouble("x").requiredDouble("y").endRecord()).noDefault().requiredDouble("radius").endRecord();
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testAllTypes() throws SchemaValidationException {
        Schema s = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"r").fields().requiredBoolean("boolF").requiredInt("intF").requiredLong("longF").requiredFloat("floatF").requiredDouble("doubleF").requiredString("stringF").requiredBytes("bytesF").name("fixedF1").type().fixed("F1").size(1)).noDefault().name("enumF").type().enumeration("E1").symbols(new String[]{"S"})).noDefault().name("mapF").type().map().values().stringType()).noDefault().name("arrayF").type().array().items().stringType()).noDefault().name("recordF").type().record("inner").fields().name("f").type().intType().noDefault().endRecord()).noDefault().optionalBoolean("boolO").endRecord();
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateLatest(), s, s);
    }

    @Test
    public void testReadOnePrior() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canReadStrategy().validateLatest(), this.rec3, this.rec);
        this.testValidatorPasses(this.builder.canReadStrategy().validateLatest(), this.rec5, this.rec3);
        this.testValidatorFails(this.builder.canReadStrategy().validateLatest(), this.rec4, this.rec);
    }

    @Test
    public void testReadAllPrior() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), this.rec3, this.rec, this.rec2);
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), this.rec4, this.rec, this.rec2, this.rec3);
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), this.rec5, this.rec, this.rec2, this.rec3);
    }

    @Test
    public void testOnePriorCanRead() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec3);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateLatest(), this.rec, this.rec4);
    }

    @Test
    public void testAllPriorCanRead() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec3, this.rec2);
        this.testValidatorFails(this.builder.canBeReadStrategy().validateAll(), this.rec, this.rec4, this.rec3, this.rec2);
    }

    @Test
    public void testOnePriorCompatible() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateLatest(), this.rec, this.rec3);
        this.testValidatorFails(this.builder.mutualReadStrategy().validateLatest(), this.rec, this.rec4);
    }

    @Test
    public void testAllPriorCompatible() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.mutualReadStrategy().validateAll(), this.rec, this.rec3, this.rec2);
        this.testValidatorFails(this.builder.mutualReadStrategy().validateAll(), this.rec, this.rec4, this.rec3, this.rec2);
    }

    @Test(expected=AvroRuntimeException.class)
    public void testInvalidBuild() {
        this.builder.strategy(null).validateAll();
    }

    @Test
    public void testReflectMatchStructure() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), circleSchemaDifferentNames, ReflectData.get().getSchema(Circle.class));
    }

    @Test
    public void testReflectWithAllowNullMatchStructure() throws SchemaValidationException {
        this.testValidatorPasses(this.builder.canBeReadStrategy().validateAll(), circleSchemaDifferentNames, ReflectData.AllowNull.get().getSchema(Circle.class));
    }

    @Test
    public void testUnionWithIncompatibleElements() throws SchemaValidationException {
        Schema union1 = Schema.createUnion(Arrays.asList(this.rec));
        Schema union2 = Schema.createUnion(Arrays.asList(this.rec4));
        this.testValidatorFails(this.builder.canReadStrategy().validateAll(), union2, union1);
    }

    @Test
    public void testUnionWithCompatibleElements() throws SchemaValidationException {
        Schema union1 = Schema.createUnion(Arrays.asList(this.rec));
        Schema union2 = Schema.createUnion(Arrays.asList(this.rec3));
        this.testValidatorPasses(this.builder.canReadStrategy().validateAll(), union2, union1);
    }

    private void testValidatorPasses(SchemaValidator validator, Schema schema, Schema ... prev) throws SchemaValidationException {
        ArrayList<Schema> prior = new ArrayList<Schema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(prev[i]);
        }
        validator.validate(schema, prior);
    }

    private void testValidatorFails(SchemaValidator validator, Schema schemaFails, Schema ... prev) throws SchemaValidationException {
        ArrayList<Schema> prior = new ArrayList<Schema>();
        for (int i = prev.length - 1; i >= 0; --i) {
            prior.add(prev[i]);
        }
        boolean threw = false;
        try {
            validator.validate(schemaFails, prior);
        }
        catch (SchemaValidationException sve) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
    }

    public static class Circle {
        Point center;
        double radius;
        public static final String __PARANAMER_DATA = "";
    }

    public static class Point {
        double x;
        double y;
        public static final String __PARANAMER_DATA = "";
    }
}

