/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilderBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RecordBuilderBaseTest {
    private static Set<Schema.Type> primitives;
    private static Set<Schema.Type> nonNullPrimitives;
    public static final String __PARANAMER_DATA = "";

    @BeforeClass
    public static void setUpBeforeClass() {
        primitives = new HashSet<Schema.Type>(Arrays.asList(Schema.Type.values()));
        primitives.removeAll(Arrays.asList(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.UNION, Schema.Type.FIXED));
        nonNullPrimitives = new HashSet<Schema.Type>(primitives);
        nonNullPrimitives.remove(Schema.Type.NULL);
    }

    @Test
    public void testIsValidValueWithPrimitives() {
        Schema.Field f;
        for (Schema.Type type : primitives) {
            f = new Schema.Field("f", Schema.create((Schema.Type)type), null, null);
            Assert.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)f, (Object)new Object()));
        }
        for (Schema.Type type : nonNullPrimitives) {
            f = new Schema.Field("f", Schema.create((Schema.Type)type), null, null);
            Assert.assertFalse((boolean)RecordBuilderBase.isValidValue((Schema.Field)f, null));
        }
    }

    @Test
    public void testIsValidValueWithNullField() {
        Assert.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", Schema.create((Schema.Type)Schema.Type.NULL), null, null), null));
    }

    @Test
    public void testIsValidValueWithUnion() {
        Schema unionWithoutNull = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.BOOLEAN)));
        Assert.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithoutNull, null, null), (Object)new Object()));
        Assert.assertFalse((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithoutNull, null, null), null));
        Schema unionWithNull = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        Assert.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithNull, null, null), (Object)new Object()));
        Assert.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithNull, null, null), null));
    }
}

