/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.data;

import java.util.Date;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTimeConversions {
    public static Schema DATE_SCHEMA;
    public static Schema TIME_MILLIS_SCHEMA;
    public static Schema TIME_MICROS_SCHEMA;
    public static Schema TIMESTAMP_MILLIS_SCHEMA;
    public static Schema TIMESTAMP_MICROS_SCHEMA;
    public static final String __PARANAMER_DATA = "";

    @BeforeClass
    public static void createSchemas() {
        DATE_SCHEMA = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TIME_MILLIS_SCHEMA = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TIME_MICROS_SCHEMA = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TIMESTAMP_MILLIS_SCHEMA = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TIMESTAMP_MICROS_SCHEMA = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    @Test
    public void testDateConversion() throws Exception {
        TimeConversions.DateConversion conversion = new TimeConversions.DateConversion();
        LocalDate Jan_6_1970 = new LocalDate(1970, 1, 6);
        LocalDate Jan_1_1970 = new LocalDate(1970, 1, 1);
        LocalDate Dec_27_1969 = new LocalDate(1969, 12, 27);
        Assert.assertEquals((String)"6 Jan 1970 should be 5", (long)5L, (long)conversion.toInt(Jan_6_1970, DATE_SCHEMA, (LogicalType)LogicalTypes.date()).intValue());
        Assert.assertEquals((String)"1 Jan 1970 should be 0", (long)0L, (long)conversion.toInt(Jan_1_1970, DATE_SCHEMA, (LogicalType)LogicalTypes.date()).intValue());
        Assert.assertEquals((String)"27 Dec 1969 should be -5", (long)-5L, (long)conversion.toInt(Dec_27_1969, DATE_SCHEMA, (LogicalType)LogicalTypes.date()).intValue());
        Assert.assertEquals((String)"6 Jan 1970 should be 5", (Object)conversion.fromInt(Integer.valueOf(5), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Jan_6_1970);
        Assert.assertEquals((String)"1 Jan 1970 should be 0", (Object)conversion.fromInt(Integer.valueOf(0), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Jan_1_1970);
        Assert.assertEquals((String)"27 Dec 1969 should be -5", (Object)conversion.fromInt(Integer.valueOf(-5), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Dec_27_1969);
    }

    @Test
    public void testTimeMillisConversion() throws Exception {
        TimeConversions.TimeConversion conversion = new TimeConversions.TimeConversion();
        LocalTime oneAM = new LocalTime(1, 0);
        LocalTime afternoon = new LocalTime(15, 14, 15, 926);
        int afternoonMillis = 54855926;
        Assert.assertEquals((String)"Midnight should be 0", (long)0L, (long)conversion.toInt(LocalTime.MIDNIGHT, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()).intValue());
        Assert.assertEquals((String)"01:00 should be 3,600,000", (long)3600000L, (long)conversion.toInt(oneAM, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()).intValue());
        Assert.assertEquals((String)("15:14:15.926 should be " + afternoonMillis), (long)afternoonMillis, (long)conversion.toInt(afternoon, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()).intValue());
        Assert.assertEquals((String)"Midnight should be 0", (Object)LocalTime.MIDNIGHT, (Object)conversion.fromInt(Integer.valueOf(0), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()));
        Assert.assertEquals((String)"01:00 should be 3,600,000", (Object)oneAM, (Object)conversion.fromInt(Integer.valueOf(3600000), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()));
        Assert.assertEquals((String)("15:14:15.926 should be " + afternoonMillis), (Object)afternoon, (Object)conversion.fromInt(Integer.valueOf(afternoonMillis), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()));
    }

    @Test
    public void testTimeMicrosConversion() throws Exception {
        TimeConversions.TimeMicrosConversion conversion = new TimeConversions.TimeMicrosConversion();
        LocalTime oneAM = new LocalTime(1, 0);
        LocalTime afternoon = new LocalTime(15, 14, 15, 926);
        long afternoonMicros = 54855926551L;
        Assert.assertEquals((String)"Midnight should be 0", (Object)LocalTime.MIDNIGHT, (Object)conversion.fromLong(Long.valueOf(0L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)"01:00 should be 3,600,000,000", (Object)oneAM, (Object)conversion.fromLong(Long.valueOf(3600000000L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)("15:14:15.926000 should be " + afternoonMicros), (Object)afternoon, (Object)conversion.fromLong(Long.valueOf(afternoonMicros), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        try {
            conversion.toLong((Object)afternoon, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
            Assert.fail((String)"Should not convert LocalTime to long");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testLossyTimeMicrosConversion() throws Exception {
        TimeConversions.LossyTimeMicrosConversion conversion = new TimeConversions.LossyTimeMicrosConversion();
        LocalTime oneAM = new LocalTime(1, 0);
        LocalTime afternoon = new LocalTime(15, 14, 15, 926);
        long afternoonMicros = 54855926551L;
        Assert.assertEquals((String)"Midnight should be 0", (long)0L, (long)conversion.toLong((Object)LocalTime.MIDNIGHT, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)"01:00 should be 3,600,000,000", (long)3600000000L, (long)conversion.toLong((Object)oneAM, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)("15:14:15.926551 should be " + afternoonMicros), (long)this.dropMicros(afternoonMicros), (long)conversion.toLong((Object)afternoon, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)"Midnight should be 0", (Object)LocalTime.MIDNIGHT, (Object)conversion.fromLong(Long.valueOf(0L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)"01:00 should be 3,600,000,000", (Object)oneAM, (Object)conversion.fromLong(Long.valueOf(3600000000L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
        Assert.assertEquals((String)("15:14:15.926000 should be " + afternoonMicros), (Object)afternoon, (Object)conversion.fromLong(Long.valueOf(afternoonMicros), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()));
    }

    @Test
    public void testTimestampMillisConversion() throws Exception {
        TimeConversions.TimestampConversion conversion = new TimeConversions.TimestampConversion();
        long nowInstant = new Date().getTime();
        DateTime now = conversion.fromLong(Long.valueOf(nowInstant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        long roundTrip = conversion.toLong(now, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        Assert.assertEquals((String)"Round-trip conversion should work", (long)nowInstant, (long)roundTrip);
        long May_28_2015_21_46_53_221_instant = 1432849613221L;
        DateTime May_28_2015_21_46_53_221 = new DateTime(2015, 5, 28, 21, 46, 53, 221, DateTimeZone.UTC);
        Assert.assertEquals((String)"Known date should be correct", (Object)May_28_2015_21_46_53_221, (Object)conversion.fromLong(Long.valueOf(May_28_2015_21_46_53_221_instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()));
        Assert.assertEquals((String)"Known date should be correct", (long)May_28_2015_21_46_53_221_instant, (long)conversion.toLong(May_28_2015_21_46_53_221, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()));
    }

    @Test
    public void testTimestampMicrosConversion() throws Exception {
        TimeConversions.TimestampMicrosConversion conversion = new TimeConversions.TimestampMicrosConversion();
        long May_28_2015_21_46_53_221_843_instant = 1432849613221843L;
        DateTime May_28_2015_21_46_53_221 = new DateTime(2015, 5, 28, 21, 46, 53, 221, DateTimeZone.UTC);
        Assert.assertEquals((String)"Known date should be correct", (Object)May_28_2015_21_46_53_221, (Object)conversion.fromLong(Long.valueOf(May_28_2015_21_46_53_221_843_instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()));
        try {
            conversion.toLong((Object)May_28_2015_21_46_53_221, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
            Assert.fail((String)"Should not convert DateTime to long");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testLossyTimestampMicrosConversion() throws Exception {
        TimeConversions.LossyTimestampMicrosConversion conversion = new TimeConversions.LossyTimestampMicrosConversion();
        long nowInstant = new Date().getTime() * 1000L + 674L;
        DateTime now = conversion.fromLong(Long.valueOf(nowInstant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        long roundTrip = conversion.toLong((Object)now, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros());
        Assert.assertEquals((String)"Round-trip conversion should lose microseconds", (long)this.dropMicros(nowInstant), (long)roundTrip);
        long May_28_2015_21_46_53_221_843_instant = 1432849613221843L;
        DateTime May_28_2015_21_46_53_221 = new DateTime(2015, 5, 28, 21, 46, 53, 221, DateTimeZone.UTC);
        Assert.assertEquals((String)"Known date should be correct", (Object)May_28_2015_21_46_53_221, (Object)conversion.fromLong(Long.valueOf(May_28_2015_21_46_53_221_843_instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()));
        Assert.assertEquals((String)"Known date should be correct", (long)this.dropMicros(May_28_2015_21_46_53_221_843_instant), (long)conversion.toLong((Object)May_28_2015_21_46_53_221, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()));
    }

    private long dropMicros(long micros) {
        return micros / 1000L * 1000L;
    }
}

