/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.file.BZip2Codec;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestBZip2Codec {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testBZip2CompressionAndDecompression() throws IOException {
        Codec codec = CodecFactory.fromString((String)"bzip2").createInstance();
        Assert.assertTrue((boolean)(codec instanceof BZip2Codec));
        Assert.assertTrue((boolean)codec.getName().equals("bzip2"));
        int inputByteSize = 196650;
        byte[] inputByteArray = new byte[196650];
        for (int i = 0; i < 196650; ++i) {
            inputByteArray[i] = (byte)(65 + i % 10);
        }
        ByteBuffer inputByteBuffer = ByteBuffer.allocate(393300);
        inputByteBuffer.put(inputByteArray);
        ByteBuffer compressedBuffer = codec.compress(inputByteBuffer);
        Assert.assertTrue((compressedBuffer.array().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((compressedBuffer.array().length < inputByteArray.length ? 1 : 0) != 0);
        ByteBuffer decompressedBuffer = codec.decompress(compressedBuffer);
        Assert.assertTrue((decompressedBuffer.array().length == inputByteArray.length ? 1 : 0) != 0);
        byte[] outputByteArray = decompressedBuffer.array();
        for (int i = 0; i < 196650; ++i) {
            inputByteArray[i] = outputByteArray[i];
        }
    }
}

