/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.file.LengthLimitedInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLengthLimitedInputStream {
    InputStream raw;
    public static final String __PARANAMER_DATA = "";

    @Before
    public void setupRawStream() {
        byte[] buf = new byte[128];
        for (int i = 0; i < 128; ++i) {
            buf[i] = (byte)i;
        }
        this.raw = new ByteArrayInputStream(buf);
    }

    @Test
    public void testAvailable() throws IOException {
        LengthLimitedInputStream is = new LengthLimitedInputStream(this.raw, 10L);
        Assert.assertEquals((long)10L, (long)is.available());
        is.skip(100L);
        Assert.assertEquals((long)0L, (long)is.available());
    }

    @Test
    public void testRead() throws IOException {
        LengthLimitedInputStream is = new LengthLimitedInputStream(this.raw, 10L);
        byte[] x = new byte[12];
        Assert.assertEquals((long)0L, (long)is.read());
        Assert.assertEquals((long)9L, (long)is.read(x));
        Assert.assertEquals((long)-1L, (long)is.read(x));
        Assert.assertEquals((long)x[8], (long)9L);
    }
}

