/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class TestSeekableByteArrayInput {
    public static final String __PARANAMER_DATA = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSerializedMessage(IndexedRecord message, Schema schema) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SpecificDatumWriter writer = new SpecificDatumWriter();
        DataFileWriter dfw = null;
        try {
            dfw = new DataFileWriter((DatumWriter)writer).create(schema, (OutputStream)baos);
            dfw.append((Object)message);
        }
        finally {
            if (dfw != null) {
                dfw.close();
            }
        }
        return baos.toByteArray();
    }

    private Schema getTestSchema() throws Exception {
        Schema schema = Schema.createRecord((String)"TestRecord", (String)"this is a test record", (String)"org.apache.avro.file", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("name", Schema.create((Schema.Type)Schema.Type.STRING), "this is a test field", null));
        schema.setFields(fields);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws Exception {
        Schema testSchema = this.getTestSchema();
        GenericData.Record message = new GenericData.Record(testSchema);
        message.put("name", (Object)"testValue");
        byte[] data = this.getSerializedMessage((IndexedRecord)message, testSchema);
        GenericDatumReader reader = new GenericDatumReader(testSchema);
        SeekableByteArrayInput in = new SeekableByteArrayInput(data);
        FileReader dfr = null;
        IndexedRecord result = null;
        try {
            dfr = DataFileReader.openReader((SeekableInput)in, (DatumReader)reader);
            result = (IndexedRecord)dfr.next();
        }
        finally {
            if (dfr != null) {
                dfr.close();
            }
        }
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof GenericRecord));
        Assert.assertEquals((Object)new Utf8("testValue"), (Object)((GenericRecord)result).get("name"));
    }
}

