/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.TestCircularReferences;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericData {
    public static final String __PARANAMER_DATA = "";

    @Test(expected=AvroRuntimeException.class)
    public void testrecordConstructorNullSchema() throws Exception {
        new GenericData.Record(null);
    }

    @Test(expected=AvroRuntimeException.class)
    public void testrecordConstructorWrongSchema() throws Exception {
        new GenericData.Record(Schema.create((Schema.Type)Schema.Type.INT));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testArrayConstructorNullSchema() throws Exception {
        new GenericData.Array(1, null);
    }

    @Test(expected=AvroRuntimeException.class)
    public void testArrayConstructorWrongSchema() throws Exception {
        new GenericData.Array(1, Schema.create((Schema.Type)Schema.Type.INT));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testRecordCreateEmptySchema() throws Exception {
        Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
        GenericData.Record r = new GenericData.Record(s);
    }

    @Test(expected=AvroRuntimeException.class)
    public void testGetEmptySchemaFields() throws Exception {
        Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
        s.getFields();
    }

    @Test(expected=AvroRuntimeException.class)
    public void testGetEmptySchemaField() throws Exception {
        Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
        s.getField("foo");
    }

    @Test(expected=AvroRuntimeException.class)
    public void testRecordPutInvalidField() throws Exception {
        Schema s = Schema.createRecord((String)"schemaName", (String)"schemaDoc", (String)"namespace", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("someFieldName", s, "docs", null));
        s.setFields(fields);
        GenericData.Record r = new GenericData.Record(s);
        r.put("invalidFieldName", (Object)"someValue");
    }

    @Test
    public void testHashCode() {
        GenericData.get().hashCode(null, Schema.create((Schema.Type)Schema.Type.NULL));
        GenericData.get().hashCode(null, Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.STRING))));
        ArrayList<String> stuff = new ArrayList<String>();
        stuff.add("string");
        Schema schema = this.recordSchema();
        GenericData.Record r = new GenericData.Record(schema);
        r.put(0, stuff);
        GenericData.get().hashCode((Object)r, schema);
    }

    @Test
    public void testEquals() {
        Schema s = this.recordSchema();
        GenericData.Record r0 = new GenericData.Record(s);
        GenericData.Record r1 = new GenericData.Record(s);
        GenericData.Record r2 = new GenericData.Record(s);
        ArrayDeque<StringBuffer> l0 = new ArrayDeque<StringBuffer>();
        ArrayList<String> l1 = new ArrayList<String>();
        GenericData.Array l2 = new GenericData.Array(1, ((Schema.Field)s.getFields().get(0)).schema());
        String foo = "foo";
        l0.add(new StringBuffer(foo));
        l1.add(foo);
        l2.add((Object)new Utf8(foo));
        r0.put(0, l0);
        r1.put(0, l1);
        r2.put(0, (Object)l2);
        Assert.assertEquals((Object)r0, (Object)r1);
        Assert.assertEquals((Object)r0, (Object)r2);
        Assert.assertEquals((Object)r1, (Object)r2);
    }

    private Schema recordSchema() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("anArray", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        Schema schema = Schema.createRecord((String)"arrayFoo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    @Test
    public void testEquals2() {
        Schema schema1 = Schema.createRecord((String)"r", null, (String)"x", (boolean)false);
        ArrayList<Schema.Field> fields1 = new ArrayList<Schema.Field>();
        fields1.add(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.STRING), null, null, Schema.Field.Order.IGNORE));
        schema1.setFields(fields1);
        Schema schema2 = Schema.createRecord((String)"r", null, (String)"x", (boolean)false);
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        fields2.add(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.STRING), null, null, Schema.Field.Order.ASCENDING));
        schema2.setFields(fields2);
        GenericData.Record record1 = new GenericData.Record(schema1);
        record1.put("a", (Object)"1");
        GenericData.Record record2 = new GenericData.Record(schema2);
        record2.put("a", (Object)"2");
        Assert.assertFalse((boolean)record2.equals(record1));
        Assert.assertFalse((boolean)record1.equals(record2));
    }

    @Test
    public void testRecordGetFieldDoesntExist() throws Exception {
        ArrayList fields = new ArrayList();
        Schema schema = Schema.createRecord(fields);
        GenericData.Record record = new GenericData.Record(schema);
        Assert.assertNull((Object)record.get("does not exist"));
    }

    @Test
    public void testArrayReversal() {
        int i;
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array forward = new GenericData.Array(10, schema);
        GenericData.Array backward = new GenericData.Array(10, schema);
        for (i = 0; i <= 9; ++i) {
            forward.add((Object)i);
        }
        for (i = 9; i >= 0; --i) {
            backward.add((Object)i);
        }
        forward.reverse();
        Assert.assertTrue((boolean)forward.equals(backward));
    }

    @Test
    public void testArrayListInterface() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(1, schema);
        array.add((Object)99);
        Assert.assertEquals((Object)new Integer(99), (Object)array.get(0));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(99);
        Assert.assertEquals((Object)array, list);
        Assert.assertEquals(list, (Object)array);
        Assert.assertEquals((long)list.hashCode(), (long)array.hashCode());
        try {
            array.get(2);
            Assert.fail((String)"Expected IndexOutOfBoundsException getting index 2");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        array.clear();
        Assert.assertEquals((long)0L, (long)array.size());
        try {
            array.get(0);
            Assert.fail((String)"Expected IndexOutOfBoundsException getting index 0 after clear()");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    @Test
    public void testArrayAddAtLocation() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(6, schema);
        array.clear();
        for (int i = 0; i < 5; ++i) {
            array.add((Object)i);
        }
        Assert.assertEquals((long)5L, (long)array.size());
        array.add(0, (Object)6);
        Assert.assertEquals((Object)new Integer(6), (Object)array.get(0));
        Assert.assertEquals((long)6L, (long)array.size());
        Assert.assertEquals((Object)new Integer(0), (Object)array.get(1));
        Assert.assertEquals((Object)new Integer(4), (Object)array.get(5));
        array.add(6, (Object)7);
        Assert.assertEquals((Object)new Integer(7), (Object)array.get(6));
        Assert.assertEquals((long)7L, (long)array.size());
        Assert.assertEquals((Object)new Integer(6), (Object)array.get(0));
        Assert.assertEquals((Object)new Integer(4), (Object)array.get(5));
        array.add(1, (Object)8);
        Assert.assertEquals((Object)new Integer(8), (Object)array.get(1));
        Assert.assertEquals((Object)new Integer(0), (Object)array.get(2));
        Assert.assertEquals((Object)new Integer(6), (Object)array.get(0));
        Assert.assertEquals((long)8L, (long)array.size());
        try {
            array.get(9);
            Assert.fail((String)"Expected IndexOutOfBoundsException after adding elements");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayRemove() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(10, schema);
        array.clear();
        for (int i = 0; i < 10; ++i) {
            array.add((Object)i);
        }
        Assert.assertEquals((long)10L, (long)array.size());
        Assert.assertEquals((Object)new Integer(0), (Object)array.get(0));
        Assert.assertEquals((Object)new Integer(9), (Object)array.get(9));
        array.remove(0);
        Assert.assertEquals((long)9L, (long)array.size());
        Assert.assertEquals((Object)new Integer(1), (Object)array.get(0));
        Assert.assertEquals((Object)new Integer(2), (Object)array.get(1));
        Assert.assertEquals((Object)new Integer(9), (Object)array.get(8));
        try {
            array.get(9);
            Assert.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            array.set(9, (Object)99);
            Assert.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            array.remove(9);
            Assert.fail((String)"Expected IndexOutOfBoundsException after removing an element");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((Object)new Integer(9), (Object)array.remove(8));
        Assert.assertEquals((long)8L, (long)array.size());
        array.add((Object)88);
        Assert.assertEquals((Object)new Integer(88), (Object)array.get(8));
    }

    @Test
    public void testArraySet() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        GenericData.Array array = new GenericData.Array(10, schema);
        array.clear();
        for (int i = 0; i < 10; ++i) {
            array.add((Object)i);
        }
        Assert.assertEquals((long)10L, (long)array.size());
        Assert.assertEquals((Object)new Integer(0), (Object)array.get(0));
        Assert.assertEquals((Object)new Integer(5), (Object)array.get(5));
        Assert.assertEquals((Object)new Integer(5), (Object)array.set(5, (Object)55));
        Assert.assertEquals((long)10L, (long)array.size());
        Assert.assertEquals((Object)new Integer(55), (Object)array.get(5));
    }

    @Test
    public void testToStringIsJson() throws JsonParseException, IOException {
        Schema.Field stringField = new Schema.Field("string", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema.Field enumField = new Schema.Field("enum", Schema.createEnum((String)"my_enum", (String)"doc", null, Arrays.asList("a", "b", "c")), null, null);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        schema.setFields(Arrays.asList(stringField, enumField));
        GenericData.Record r = new GenericData.Record(schema);
        r.put(stringField.name(), (Object)"hello\nthere\"\tyou\u2013}");
        r.put(enumField.name(), (Object)new GenericData.EnumSymbol(enumField.schema(), "a"));
        String json = r.toString();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readTree(parser);
    }

    @Test
    public void testToStringEscapesControlCharsInBytes() throws Exception {
        GenericData data = GenericData.get();
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 10, 98});
        Assert.assertEquals((Object)"{\"bytes\": \"a\\nb\"}", (Object)data.toString((Object)bytes));
        Assert.assertEquals((Object)"{\"bytes\": \"a\\nb\"}", (Object)data.toString((Object)bytes));
    }

    @Test
    public void testToStringFixed() throws Exception {
        GenericData data = GenericData.get();
        Assert.assertEquals((Object)"[97, 10, 98]", (Object)data.toString((Object)new GenericData.Fixed(Schema.createFixed((String)"test", null, null, (int)3), new byte[]{97, 10, 98})));
    }

    @Test
    public void testToStringDoesNotEscapeForwardSlash() throws Exception {
        GenericData data = GenericData.get();
        Assert.assertEquals((Object)"\"/\"", (Object)data.toString((Object)"/"));
    }

    @Test
    public void testToStringNanInfinity() throws Exception {
        GenericData data = GenericData.get();
        Assert.assertEquals((Object)"\"Infinity\"", (Object)data.toString((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)"\"-Infinity\"", (Object)data.toString((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        Assert.assertEquals((Object)"\"NaN\"", (Object)data.toString((Object)Float.valueOf(Float.NaN)));
        Assert.assertEquals((Object)"\"Infinity\"", (Object)data.toString((Object)Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"\"-Infinity\"", (Object)data.toString((Object)Double.NEGATIVE_INFINITY));
        Assert.assertEquals((Object)"\"NaN\"", (Object)data.toString((Object)Double.NaN));
    }

    @Test
    public void testCompare() {
        Schema.Field integerField = new Schema.Field("test", Schema.create((Schema.Type)Schema.Type.INT), null, null);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(integerField);
        Schema record = Schema.createRecord((String)"test", null, null, (boolean)false);
        record.setFields(fields);
        ByteArrayOutputStream b1 = new ByteArrayOutputStream(5);
        ByteArrayOutputStream b2 = new ByteArrayOutputStream(5);
        BinaryEncoder b1Enc = EncoderFactory.get().binaryEncoder((OutputStream)b1, null);
        BinaryEncoder b2Enc = EncoderFactory.get().binaryEncoder((OutputStream)b2, null);
        GenericData.Record testDatum1 = new GenericData.Record(record);
        testDatum1.put(0, (Object)1);
        GenericData.Record testDatum2 = new GenericData.Record(record);
        testDatum2.put(0, (Object)2);
        GenericDatumWriter gWriter = new GenericDatumWriter(record);
        Integer start1 = 0;
        Integer start2 = 0;
        try {
            gWriter.write((Object)testDatum1, (Encoder)b1Enc);
            b1Enc.flush();
            start1 = b1.size();
            gWriter.write((Object)testDatum1, (Encoder)b1Enc);
            b1Enc.flush();
            b1.close();
            gWriter.write((Object)testDatum2, (Encoder)b2Enc);
            b2Enc.flush();
            start2 = b2.size();
            gWriter.write((Object)testDatum2, (Encoder)b2Enc);
            b2Enc.flush();
            b2.close();
            Assert.assertEquals((long)-1L, (long)BinaryData.compare((byte[])b1.toByteArray(), (int)start1, (byte[])b2.toByteArray(), (int)start2, (Schema)record));
        }
        catch (IOException e) {
            Assert.fail((String)"IOException while writing records to output stream.");
        }
    }

    @Test
    public void testEnumCompare() {
        Schema s = Schema.createEnum((String)"Kind", null, null, Arrays.asList("Z", "Y", "X"));
        GenericData.EnumSymbol z = new GenericData.EnumSymbol(s, "Z");
        GenericData.EnumSymbol y = new GenericData.EnumSymbol(s, "Y");
        Assert.assertEquals((long)0L, (long)z.compareTo((Object)z));
        Assert.assertTrue((y.compareTo((Object)z) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((z.compareTo((Object)y) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testByteBufferDeepCopy() {
        byte[] buffer_value = new byte[]{0, 1, 2, 3, 0, 0, 0};
        ByteBuffer buffer = ByteBuffer.wrap(buffer_value, 1, 4);
        Schema schema = Schema.createRecord((String)"my_record", (String)"doc", (String)"mytest", (boolean)false);
        Schema.Field byte_field = new Schema.Field("bytes", Schema.create((Schema.Type)Schema.Type.BYTES), null, null);
        schema.setFields(Arrays.asList(byte_field));
        GenericData.Record record = new GenericData.Record(schema);
        record.put(byte_field.name(), (Object)buffer);
        GenericRecord copy = (GenericRecord)GenericData.get().deepCopy(schema, (Object)record);
        ByteBuffer buffer_copy = (ByteBuffer)copy.get(byte_field.name());
        Assert.assertEquals((Object)buffer, (Object)buffer_copy);
    }

    @Test
    public void testValidateNullableEnum() {
        ArrayList<Schema> unionTypes = new ArrayList<Schema>();
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        Schema enumSchema = Schema.createEnum((String)"AnEnum", null, null, Arrays.asList("X", "Y", "Z"));
        GenericData.EnumSymbol w = new GenericData.EnumSymbol(enumSchema, "W");
        GenericData.EnumSymbol x = new GenericData.EnumSymbol(enumSchema, "X");
        GenericData.EnumSymbol y = new GenericData.EnumSymbol(enumSchema, "Y");
        GenericData.EnumSymbol z = new GenericData.EnumSymbol(enumSchema, "Z");
        unionTypes.clear();
        unionTypes.add(nullSchema);
        unionTypes.add(enumSchema);
        Schema schema = Schema.createUnion(unionTypes);
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)z));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)y));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)x));
        Assert.assertFalse((boolean)GenericData.get().validate(schema, (Object)w));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, null));
        unionTypes.clear();
        unionTypes.add(enumSchema);
        unionTypes.add(nullSchema);
        schema = Schema.createUnion(unionTypes);
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)z));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)y));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, (Object)x));
        Assert.assertFalse((boolean)GenericData.get().validate(schema, (Object)w));
        Assert.assertTrue((boolean)GenericData.get().validate(schema, null));
    }

    @Test
    public void validateRequiresGenericSymbolForEnumSchema() {
        Schema schema = Schema.createEnum((String)"my_enum", (String)"doc", (String)"namespace", Arrays.asList("ONE", "TWO", "THREE"));
        GenericData gd = GenericData.get();
        Assert.assertTrue((boolean)gd.validate(schema, (Object)new GenericData.EnumSymbol(schema, "ONE")));
        Assert.assertTrue((boolean)gd.validate(schema, (Object)new GenericData.EnumSymbol(schema, (Object)anEnum.ONE)));
        Assert.assertFalse((String)"We don't expect GenericData to allow a String datum for an enum schema", (boolean)gd.validate(schema, (Object)"ONE"));
        Assert.assertFalse((String)"We don't expect GenericData to allow a Java Enum for an enum schema", (boolean)gd.validate(schema, (Object)anEnum.ONE));
    }

    @Test
    public void testValidateUnion() {
        Schema type1Schema = (Schema)SchemaBuilder.record((String)"Type1").fields().requiredString("myString").requiredInt("myInt").endRecord();
        Schema type2Schema = (Schema)SchemaBuilder.record((String)"Type2").fields().requiredString("myString").endRecord();
        Schema unionSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().type(type1Schema)).and().type(type2Schema)).endUnion();
        GenericData.Record record = new GenericData.Record(type2Schema);
        record.put("myString", (Object)"myValue");
        Assert.assertTrue((boolean)GenericData.get().validate(unionSchema, (Object)record));
    }

    @Test
    public void testToStringSameValues() throws IOException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("nullstring1", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        fields.add(new Schema.Field("nullstring2", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        fields.add(new Schema.Field("string1", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        fields.add(new Schema.Field("string2", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        fields.add(new Schema.Field("bytes1", Schema.create((Schema.Type)Schema.Type.BYTES), null, (Object)null));
        fields.add(new Schema.Field("bytes2", Schema.create((Schema.Type)Schema.Type.BYTES), null, (Object)null));
        fields.add(new Schema.Field("int1", Schema.create((Schema.Type)Schema.Type.INT), null, (Object)null));
        fields.add(new Schema.Field("int2", Schema.create((Schema.Type)Schema.Type.INT), null, (Object)null));
        fields.add(new Schema.Field("long1", Schema.create((Schema.Type)Schema.Type.LONG), null, (Object)null));
        fields.add(new Schema.Field("long2", Schema.create((Schema.Type)Schema.Type.LONG), null, (Object)null));
        fields.add(new Schema.Field("float1", Schema.create((Schema.Type)Schema.Type.FLOAT), null, (Object)null));
        fields.add(new Schema.Field("float2", Schema.create((Schema.Type)Schema.Type.FLOAT), null, (Object)null));
        fields.add(new Schema.Field("double1", Schema.create((Schema.Type)Schema.Type.DOUBLE), null, (Object)null));
        fields.add(new Schema.Field("double2", Schema.create((Schema.Type)Schema.Type.DOUBLE), null, (Object)null));
        fields.add(new Schema.Field("boolean1", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, (Object)null));
        fields.add(new Schema.Field("boolean2", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, (Object)null));
        ArrayList<String> enumValues = new ArrayList<String>();
        enumValues.add("One");
        enumValues.add("Two");
        Schema enumSchema = Schema.createEnum((String)"myEnum", null, null, enumValues);
        fields.add(new Schema.Field("enum1", enumSchema, null, (Object)null));
        fields.add(new Schema.Field("enum2", enumSchema, null, (Object)null));
        Schema recordSchema = (Schema)SchemaBuilder.record((String)"aRecord").fields().requiredString("myString").endRecord();
        fields.add(new Schema.Field("record1", recordSchema, null, (Object)null));
        fields.add(new Schema.Field("record2", recordSchema, null, (Object)null));
        Schema arraySchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        fields.add(new Schema.Field("array1", arraySchema, null, (Object)null));
        fields.add(new Schema.Field("array2", arraySchema, null, (Object)null));
        Schema mapSchema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        fields.add(new Schema.Field("map1", mapSchema, null, (Object)null));
        fields.add(new Schema.Field("map2", mapSchema, null, (Object)null));
        Schema schema = Schema.createRecord((String)"Foo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        GenericData.Record testRecord = new GenericData.Record(schema);
        testRecord.put("nullstring1", null);
        testRecord.put("nullstring2", null);
        String fortyTwo = "42";
        testRecord.put("string1", (Object)fortyTwo);
        testRecord.put("string2", (Object)fortyTwo);
        testRecord.put("bytes1", (Object)66);
        testRecord.put("bytes2", (Object)66);
        testRecord.put("int1", (Object)42);
        testRecord.put("int2", (Object)42);
        testRecord.put("long1", (Object)42L);
        testRecord.put("long2", (Object)42L);
        testRecord.put("float1", (Object)Float.valueOf(42.0f));
        testRecord.put("float2", (Object)Float.valueOf(42.0f));
        testRecord.put("double1", (Object)42.0);
        testRecord.put("double2", (Object)42.0);
        testRecord.put("boolean1", (Object)true);
        testRecord.put("boolean2", (Object)true);
        testRecord.put("enum1", (Object)"One");
        testRecord.put("enum2", (Object)"One");
        GenericData.Record record = new GenericData.Record(recordSchema);
        record.put("myString", (Object)"42");
        testRecord.put("record1", (Object)record);
        testRecord.put("record2", (Object)record);
        GenericData.Array array = new GenericData.Array(1, arraySchema);
        array.clear();
        array.add((Object)"42");
        testRecord.put("array1", (Object)array);
        testRecord.put("array2", (Object)array);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("42", "42");
        testRecord.put("map1", map);
        testRecord.put("map2", map);
        String testString = testRecord.toString();
        Assert.assertFalse((String)"Record with duplicated values results in wrong 'toString()'", (boolean)testString.contains("CIRCULAR REFERENCE"));
    }

    @Test
    public void testToStringRecursive() throws IOException {
        TestCircularReferences.ReferenceManager manager = new TestCircularReferences.ReferenceManager();
        GenericData model = new GenericData();
        model.addLogicalTypeConversion((Conversion)manager.getTracker());
        model.addLogicalTypeConversion((Conversion)manager.getHandler());
        Schema parentSchema = Schema.createRecord((String)"Parent", null, null, (boolean)false);
        Schema placeholderSchema = Schema.createRecord((String)"Placeholder", null, null, (boolean)false);
        ArrayList<Schema.Field> placeholderFields = new ArrayList<Schema.Field>();
        placeholderFields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, (Object)null));
        placeholderSchema.setFields(placeholderFields);
        TestCircularReferences.Referenceable idRef = new TestCircularReferences.Referenceable("id");
        Schema parentRefSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG), idRef.addToSchema(placeholderSchema)});
        TestCircularReferences.Reference parentRef = new TestCircularReferences.Reference("parent");
        ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
        childFields.add(new Schema.Field("c", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        childFields.add(new Schema.Field("parent", parentRefSchema, null, (Object)null));
        Schema childSchema = parentRef.addToSchema(Schema.createRecord((String)"Child", null, null, (boolean)false, childFields));
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        parentFields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, (Object)null));
        parentFields.add(new Schema.Field("p", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)null));
        parentFields.add(new Schema.Field("child", childSchema, null, (Object)null));
        parentSchema.setFields(parentFields);
        Schema schema = idRef.addToSchema(parentSchema);
        GenericData.Record parent = new GenericData.Record(schema);
        parent.put("id", (Object)1L);
        parent.put("p", (Object)"parent data!");
        GenericData.Record child = new GenericData.Record(childSchema);
        child.put("c", (Object)"child data!");
        child.put("parent", (Object)parent);
        parent.put("child", (Object)child);
        try {
            Assert.assertNotNull((Object)parent.toString());
        }
        catch (StackOverflowError e) {
            Assert.fail((String)"StackOverflowError occurred");
        }
    }

    private static enum anEnum {
        ONE,
        TWO,
        THREE;

        public static final String __PARANAMER_DATA = "";
    }
}

