/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericDatumWriter {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testWrite() throws IOException {
        String json = "{\"type\": \"record\", \"name\": \"r\", \"fields\": [{ \"name\": \"f1\", \"type\": \"long\" }]}";
        Schema s = Schema.parse((String)json);
        GenericData.Record r = new GenericData.Record(s);
        r.put("f1", (Object)100L);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter w = new GenericDatumWriter(s);
        JsonEncoder e = EncoderFactory.get().jsonEncoder(s, (OutputStream)bao);
        w.write((Object)r, (Encoder)e);
        e.flush();
        Object o = new GenericDatumReader(s).read(null, (Decoder)DecoderFactory.get().jsonDecoder(s, (InputStream)new ByteArrayInputStream(bao.toByteArray())));
        Assert.assertEquals((Object)r, (Object)o);
    }

    @Test
    public void testArrayConcurrentModification() throws Exception {
        String json = "{\"type\": \"array\", \"items\": \"int\" }";
        Schema s = Schema.parse((String)json);
        GenericData.Array a = new GenericData.Array(1, s);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        final GenericDatumWriter w = new GenericDatumWriter(s);
        CountDownLatch sizeWrittenSignal = new CountDownLatch(1);
        CountDownLatch eltAddedSignal = new CountDownLatch(1);
        TestEncoder e = new TestEncoder((Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)bao, null), sizeWrittenSignal, eltAddedSignal);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(new Callable<Void>((GenericArray)a, e){
            final /* synthetic */ GenericArray val$a;
            final /* synthetic */ TestEncoder val$e;
            {
                this.val$a = genericArray;
                this.val$e = testEncoder;
            }

            @Override
            public Void call() throws Exception {
                w.write((Object)this.val$a, (Encoder)this.val$e);
                return null;
            }
        });
        sizeWrittenSignal.await();
        a.add((Object)7);
        eltAddedSignal.countDown();
        try {
            result.get();
            Assert.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof ConcurrentModificationException));
        }
    }

    @Test
    public void testMapConcurrentModification() throws Exception {
        String json = "{\"type\": \"map\", \"values\": \"int\" }";
        Schema s = Schema.parse((String)json);
        final HashMap<String, Integer> m = new HashMap<String, Integer>();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        final GenericDatumWriter w = new GenericDatumWriter(s);
        CountDownLatch sizeWrittenSignal = new CountDownLatch(1);
        CountDownLatch eltAddedSignal = new CountDownLatch(1);
        final TestEncoder e = new TestEncoder((Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)bao, null), sizeWrittenSignal, eltAddedSignal);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                w.write((Object)m, (Encoder)e);
                return null;
            }
        });
        sizeWrittenSignal.await();
        m.put("a", 7);
        eltAddedSignal.countDown();
        try {
            result.get();
            Assert.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof ConcurrentModificationException));
        }
    }

    @Test(expected=AvroTypeException.class)
    public void writeDoesNotAllowStringForGenericEnum() throws IOException {
        String json = "{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}";
        Schema schema = Schema.parse((String)"{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}");
        GenericData.Record record = new GenericData.Record(schema);
        record.put("field", (Object)"ONE");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)bao);
        writer.write((Object)record, (Encoder)encoder);
    }

    @Test(expected=AvroTypeException.class)
    public void writeDoesNotAllowJavaEnumForGenericEnum() throws IOException {
        String json = "{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}";
        Schema schema = Schema.parse((String)"{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}");
        GenericData.Record record = new GenericData.Record(schema);
        record.put("field", (Object)AnEnum.ONE);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)bao);
        writer.write((Object)record, (Encoder)encoder);
    }

    private static enum AnEnum {
        ONE,
        TWO,
        THREE;

        public static final String __PARANAMER_DATA = "";
    }

    static class TestEncoder
    extends Encoder {
        Encoder e;
        CountDownLatch sizeWrittenSignal;
        CountDownLatch eltAddedSignal;
        public static final String __PARANAMER_DATA = "<init> org.apache.avro.io.Encoder,java.util.concurrent.CountDownLatch,java.util.concurrent.CountDownLatch encoder,sizeWrittenSignal,eltAddedSignal \nsetItemCount long itemCount \nwriteBoolean boolean b \nwriteBytes byte[],int,int bytes,start,len \nwriteBytes java.nio.ByteBuffer bytes \nwriteDouble double d \nwriteEnum int en \nwriteFixed byte[],int,int bytes,start,len \nwriteFloat float f \nwriteIndex int unionIndex \nwriteInt int n \nwriteLong long n \nwriteString org.apache.avro.util.Utf8 utf8 \n";

        TestEncoder(Encoder encoder, CountDownLatch sizeWrittenSignal, CountDownLatch eltAddedSignal) {
            this.e = encoder;
            this.sizeWrittenSignal = sizeWrittenSignal;
            this.eltAddedSignal = eltAddedSignal;
        }

        public void writeArrayStart() throws IOException {
            this.e.writeArrayStart();
            this.sizeWrittenSignal.countDown();
            try {
                this.eltAddedSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void writeMapStart() throws IOException {
            this.e.writeMapStart();
            this.sizeWrittenSignal.countDown();
            try {
                this.eltAddedSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void flush() throws IOException {
            this.e.flush();
        }

        public void writeNull() throws IOException {
            this.e.writeNull();
        }

        public void writeBoolean(boolean b) throws IOException {
            this.e.writeBoolean(b);
        }

        public void writeInt(int n) throws IOException {
            this.e.writeInt(n);
        }

        public void writeLong(long n) throws IOException {
            this.e.writeLong(n);
        }

        public void writeFloat(float f) throws IOException {
            this.e.writeFloat(f);
        }

        public void writeDouble(double d) throws IOException {
            this.e.writeDouble(d);
        }

        public void writeString(Utf8 utf8) throws IOException {
            this.e.writeString(utf8);
        }

        public void writeBytes(ByteBuffer bytes) throws IOException {
            this.e.writeBytes(bytes);
        }

        public void writeBytes(byte[] bytes, int start, int len) throws IOException {
            this.e.writeBytes(bytes, start, len);
        }

        public void writeFixed(byte[] bytes, int start, int len) throws IOException {
            this.e.writeFixed(bytes, start, len);
        }

        public void writeEnum(int en) throws IOException {
            this.e.writeEnum(en);
        }

        public void setItemCount(long itemCount) throws IOException {
            this.e.setItemCount(itemCount);
        }

        public void startItem() throws IOException {
            this.e.startItem();
        }

        public void writeArrayEnd() throws IOException {
            this.e.writeArrayEnd();
        }

        public void writeMapEnd() throws IOException {
            this.e.writeMapEnd();
        }

        public void writeIndex(int unionIndex) throws IOException {
            this.e.writeIndex(unionIndex);
        }
    }
}

