/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestGenericLogicalTypes {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final GenericData GENERIC = new GenericData();
    public static final String __PARANAMER_DATA = "";

    @BeforeClass
    public static void addDecimalAndUUID() {
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
    }

    @Test
    public void testReadUUID() throws IOException {
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<UUID> expected = Arrays.asList(u1, u2);
        File test = this.write(Schema.create((Schema.Type)Schema.Type.STRING), u1.toString(), u2.toString());
        Assert.assertEquals((String)"Should convert Strings to UUIDs", expected, this.read(GENERIC.createDatumReader(uuidSchema), test));
    }

    @Test
    public void testWriteUUID() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringSchema.addProp("avro.java.string", "String");
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<String> expected = Arrays.asList(u1.toString(), u2.toString());
        File test = this.write(GENERIC, uuidSchema, u1, u2);
        Assert.assertEquals((String)"Should read UUIDs as Strings", expected, this.read(GenericData.get().createDatumReader(stringSchema), test));
    }

    @Test
    public void testWriteNullableUUID() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringSchema.addProp("avro.java.string", "String");
        Schema nullableStringSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), stringSchema});
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        Schema nullableUuidSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), uuidSchema});
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<String> expected = Arrays.asList(u1.toString(), u2.toString());
        File test = this.write(GENERIC, nullableUuidSchema, u1, u2);
        Assert.assertEquals((String)"Should read UUIDs as Strings", expected, this.read(GenericData.get().createDatumReader(nullableStringSchema), test));
    }

    @Test
    public void testReadDecimalFixed() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema decimalSchema = decimal.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        List<BigDecimal> expected = Arrays.asList(d1, d2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericFixed d1fixed = conversion.toFixed((Object)d1, fixedSchema, (LogicalType)decimal);
        GenericFixed d2fixed = conversion.toFixed((Object)d2, fixedSchema, (LogicalType)decimal);
        File test = this.write(fixedSchema, d1fixed, d2fixed);
        Assert.assertEquals((String)"Should convert fixed to BigDecimals", expected, this.read(GENERIC.createDatumReader(decimalSchema), test));
    }

    @Test
    public void testWriteDecimalFixed() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema decimalSchema = decimal.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericFixed d1fixed = conversion.toFixed((Object)d1, fixedSchema, (LogicalType)decimal);
        GenericFixed d2fixed = conversion.toFixed((Object)d2, fixedSchema, (LogicalType)decimal);
        List<GenericFixed> expected = Arrays.asList(d1fixed, d2fixed);
        File test = this.write(GENERIC, decimalSchema, d1, d2);
        Assert.assertEquals((String)"Should read BigDecimals as fixed", expected, this.read(GenericData.get().createDatumReader(fixedSchema), test));
    }

    @Test
    public void testReadDecimalBytes() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema decimalSchema = decimal.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        List<BigDecimal> expected = Arrays.asList(d1, d2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        ByteBuffer d1bytes = conversion.toBytes((Object)d1, bytesSchema, (LogicalType)decimal);
        ByteBuffer d2bytes = conversion.toBytes((Object)d2, bytesSchema, (LogicalType)decimal);
        File test = this.write(bytesSchema, d1bytes, d2bytes);
        Assert.assertEquals((String)"Should convert bytes to BigDecimals", expected, this.read(GENERIC.createDatumReader(decimalSchema), test));
    }

    @Test
    public void testWriteDecimalBytes() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema decimalSchema = decimal.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        ByteBuffer d1bytes = conversion.toBytes((Object)d1, bytesSchema, (LogicalType)decimal);
        ByteBuffer d2bytes = conversion.toBytes((Object)d2, bytesSchema, (LogicalType)decimal);
        List<ByteBuffer> expected = Arrays.asList(d1bytes, d2bytes);
        File test = this.write(GENERIC, decimalSchema, d1bytes, d2bytes);
        Assert.assertEquals((String)"Should read BigDecimals as bytes", expected, this.read(GenericData.get().createDatumReader(bytesSchema), test));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> List<D> read(DatumReader<D> reader, File file) throws IOException {
        ArrayList data = new ArrayList();
        DataFileReader fileReader = null;
        try {
            fileReader = new DataFileReader(file, reader);
            for (Object datum : fileReader) {
                data.add(datum);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return data;
    }

    private <D> File write(Schema schema, D ... data) throws IOException {
        return this.write(GenericData.get(), schema, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        File file = this.temp.newFile();
        DatumWriter writer = model.createDatumWriter(schema);
        DataFileWriter fileWriter = new DataFileWriter(writer);
        try {
            fileWriter.create(schema, file);
            for (D datum : data) {
                fileWriter.append(datum);
            }
        }
        finally {
            fileWriter.close();
        }
        return file;
    }

    @Test
    public void testCopyUuid() {
        this.testCopy(LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), UUID.randomUUID(), GENERIC);
    }

    @Test
    public void testCopyUuidRaw() {
        this.testCopy(LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), UUID.randomUUID().toString(), GenericData.get());
    }

    @Test
    public void testCopyDecimal() {
        this.testCopy(LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), new BigDecimal("-34.34"), GENERIC);
    }

    @Test
    public void testCopyDecimalRaw() {
        this.testCopy(LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), ByteBuffer.wrap(new BigDecimal("-34.34").unscaledValue().toByteArray()), GenericData.get());
    }

    private void testCopy(Schema schema, Object value, GenericData model) {
        this.checkCopy(value, model.deepCopy(schema, value), false);
        Schema recordSchema = Schema.createRecord((String)"X", (String)__PARANAMER_DATA, (String)"test", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("x", schema, __PARANAMER_DATA, null));
        recordSchema.setFields(fields);
        GenericRecordBuilder builder = new GenericRecordBuilder(recordSchema);
        builder.set("x", value);
        GenericData.Record record = builder.build();
        this.checkCopy(record, model.deepCopy(recordSchema, (Object)record), true);
        Schema arraySchema = Schema.createArray((Schema)schema);
        ArrayList<Object> array = new ArrayList<Object>(Arrays.asList(value));
        this.checkCopy(array, model.deepCopy(arraySchema, array), true);
        Schema recordArraySchema = Schema.createArray((Schema)recordSchema);
        ArrayList<GenericData.Record> recordArray = new ArrayList<GenericData.Record>(Arrays.asList(record));
        this.checkCopy(recordArray, model.deepCopy(recordArraySchema, recordArray), true);
    }

    private void checkCopy(Object original, Object copy, boolean notSame) {
        if (notSame) {
            Assert.assertNotSame((Object)original, (Object)copy);
        }
        Assert.assertEquals((Object)original, (Object)copy);
    }
}

