/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericRecordBuilder {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testGenericBuilder() {
        Schema schema = TestGenericRecordBuilder.recordSchema();
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            Assert.assertFalse((String)("RecordBuilder should not have field " + field.name()), (boolean)builder.has(field.name()));
            Assert.assertNull((String)("Field " + field.name() + " should be null"), (Object)builder.get(field.name()));
        }
        builder.set("intField", (Object)1);
        List<String> anArray = Arrays.asList("one", "two", "three");
        builder.set("anArray", anArray);
        Assert.assertTrue((String)"anArray should be set", (boolean)builder.has("anArray"));
        Assert.assertEquals(anArray, (Object)builder.get("anArray"));
        Assert.assertFalse((String)"id should not be set", (boolean)builder.has("id"));
        Assert.assertNull((Object)builder.get("id"));
        GenericData.Record record = builder.build();
        Assert.assertEquals((Object)new Integer(1), (Object)record.get("intField"));
        Assert.assertEquals(anArray, (Object)record.get("anArray"));
        Assert.assertNotNull((Object)record.get("id"));
        Assert.assertEquals((Object)"0", (Object)record.get("id").toString());
        Assert.assertEquals((Object)builder, (Object)new GenericRecordBuilder(builder));
        Assert.assertEquals((Object)record, (Object)new GenericRecordBuilder(record).build());
        builder.clear("intField");
        Assert.assertFalse((boolean)builder.has("intField"));
        Assert.assertNull((Object)builder.get("intField"));
    }

    @Test(expected=AvroRuntimeException.class)
    public void attemptToSetNonNullableFieldToNull() {
        new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).set("intField", null);
    }

    @Test(expected=AvroRuntimeException.class)
    public void buildWithoutSettingRequiredFields1() {
        new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).build();
    }

    @Test
    public void buildWithoutSettingRequiredFields2() {
        try {
            new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).set("anArray", Arrays.asList("one")).build();
            Assert.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("intField"));
        }
    }

    private static Schema recordSchema() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)"0"));
        fields.add(new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        fields.add(new Schema.Field("anArray", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("optionalInt", Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)Schema.NULL_VALUE));
        Schema schema = Schema.createRecord((String)"Foo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        return schema;
    }
}

