/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.RandomData;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.DirectBinaryDecoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBinaryDecoder {
    DecoderFactory factory = new DecoderFactory().configureDecoderBufferSize(521);
    private boolean useDirect = false;
    static EncoderFactory e_factory = EncoderFactory.get();
    private static byte[] data = null;
    private static int seed = -1;
    private static Schema schema = null;
    private static int count = 200;
    private static ArrayList<Object> records = new ArrayList(count);
    public static final String __PARANAMER_DATA = "<init> boolean useDirect \n";

    public TestBinaryDecoder(boolean useDirect) {
        this.useDirect = useDirect;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private Decoder newDecoderWithNoData() throws IOException {
        return this.newDecoder(new byte[0]);
    }

    private Decoder newDecoder(byte[] bytes, int start, int len) throws IOException {
        return this.factory.binaryDecoder(bytes, start, len, null);
    }

    private Decoder newDecoder(InputStream in) {
        if (this.useDirect) {
            return this.factory.directBinaryDecoder(in, null);
        }
        return this.factory.binaryDecoder(in, null);
    }

    private Decoder newDecoder(byte[] bytes) throws IOException {
        return this.factory.binaryDecoder(bytes, null);
    }

    @Test(expected=EOFException.class)
    public void testEOFBoolean() throws IOException {
        this.newDecoderWithNoData().readBoolean();
    }

    @Test(expected=EOFException.class)
    public void testEOFInt() throws IOException {
        this.newDecoderWithNoData().readInt();
    }

    @Test(expected=EOFException.class)
    public void testEOFLong() throws IOException {
        this.newDecoderWithNoData().readLong();
    }

    @Test(expected=EOFException.class)
    public void testEOFFloat() throws IOException {
        this.newDecoderWithNoData().readFloat();
    }

    @Test(expected=EOFException.class)
    public void testEOFDouble() throws IOException {
        this.newDecoderWithNoData().readDouble();
    }

    @Test(expected=EOFException.class)
    public void testEOFBytes() throws IOException {
        this.newDecoderWithNoData().readBytes(null);
    }

    @Test(expected=EOFException.class)
    public void testEOFString() throws IOException {
        this.newDecoderWithNoData().readString(new Utf8("a"));
    }

    @Test(expected=EOFException.class)
    public void testEOFFixed() throws IOException {
        this.newDecoderWithNoData().readFixed(new byte[1]);
    }

    @Test(expected=EOFException.class)
    public void testEOFEnum() throws IOException {
        this.newDecoderWithNoData().readEnum();
    }

    @Test
    public void testReuse() throws IOException {
        ByteBufferOutputStream bbo1 = new ByteBufferOutputStream();
        ByteBufferOutputStream bbo2 = new ByteBufferOutputStream();
        byte[] b1 = new byte[]{1, 2};
        BinaryEncoder e1 = e_factory.binaryEncoder((OutputStream)bbo1, null);
        e1.writeBytes(b1);
        e1.flush();
        BinaryEncoder e2 = e_factory.binaryEncoder((OutputStream)bbo2, null);
        e2.writeBytes(b1);
        e2.flush();
        DirectBinaryDecoder d = new DirectBinaryDecoder((InputStream)new ByteBufferInputStream(bbo1.getBufferList()));
        ByteBuffer bb1 = d.readBytes(null);
        Assert.assertEquals((long)b1.length, (long)(bb1.limit() - bb1.position()));
        d.configure((InputStream)new ByteBufferInputStream(bbo2.getBufferList()));
        ByteBuffer bb2 = d.readBytes(null);
        Assert.assertEquals((long)b1.length, (long)(bb2.limit() - bb2.position()));
    }

    @BeforeClass
    public static void generateData() throws IOException {
        seed = (int)System.currentTimeMillis();
        String jsonSchema = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"intField\", \"type\":\"int\"},{\"name\":\"bytesField\", \"type\":\"bytes\"},{\"name\":\"booleanField\", \"type\":\"boolean\"},{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"floatField\", \"type\":\"float\"},{\"name\":\"doubleField\", \"type\":\"double\"},{\"name\":\"arrayField\", \"type\": {\"type\":\"array\", \"items\":\"boolean\"}},{\"name\":\"longField\", \"type\":\"long\"}]}";
        schema = Schema.parse((String)jsonSchema);
        GenericDatumWriter writer = new GenericDatumWriter();
        writer.setSchema(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        BinaryEncoder encoder = e_factory.binaryEncoder((OutputStream)baos, null);
        for (Object datum : new RandomData(schema, count, seed)) {
            writer.write(datum, (Encoder)encoder);
            records.add(datum);
        }
        encoder.flush();
        data = baos.toByteArray();
    }

    @Test
    public void testDecodeFromSources() throws IOException {
        GenericDatumReader reader = new GenericDatumReader();
        reader.setSchema(schema);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ByteArrayInputStream is2 = new ByteArrayInputStream(data);
        ByteArrayInputStream is3 = new ByteArrayInputStream(data);
        Decoder fromInputStream = this.newDecoder(is);
        Decoder fromArray = this.newDecoder(data);
        byte[] data2 = new byte[data.length + 30];
        Arrays.fill(data2, (byte)-1);
        System.arraycopy(data, 0, data2, 15, data.length);
        Decoder fromOffsetArray = this.newDecoder(data2, 15, data.length);
        BinaryDecoder initOnInputStream = this.factory.binaryDecoder(new byte[50], 0, 30, null);
        initOnInputStream = this.factory.binaryDecoder((InputStream)is2, initOnInputStream);
        BinaryDecoder initOnArray = this.factory.binaryDecoder((InputStream)is3, null);
        initOnArray = this.factory.binaryDecoder(data, 0, data.length, initOnArray);
        for (Object datum : records) {
            Assert.assertEquals((String)"InputStream based BinaryDecoder result does not match", (Object)datum, (Object)reader.read(null, fromInputStream));
            Assert.assertEquals((String)"Array based BinaryDecoder result does not match", (Object)datum, (Object)reader.read(null, fromArray));
            Assert.assertEquals((String)"offset Array based BinaryDecoder result does not match", (Object)datum, (Object)reader.read(null, fromOffsetArray));
            Assert.assertEquals((String)"InputStream initialized BinaryDecoder result does not match", (Object)datum, (Object)reader.read(null, (Decoder)initOnInputStream));
            Assert.assertEquals((String)"Array initialized BinaryDecoder result does not match", (Object)datum, (Object)reader.read(null, (Decoder)initOnArray));
        }
    }

    @Test
    public void testInputStreamProxy() throws IOException {
        Decoder d = this.newDecoder(data);
        if (d instanceof BinaryDecoder) {
            BinaryDecoder bd = (BinaryDecoder)d;
            InputStream test = bd.inputStream();
            ByteArrayInputStream check = new ByteArrayInputStream(data);
            this.validateInputStreamReads(test, check);
            bd = this.factory.binaryDecoder(data, bd);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamSkips(test, check);
            bd = this.factory.binaryDecoder((InputStream)new ByteArrayInputStream(data), bd);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamReads(test, check);
            bd = this.factory.binaryDecoder((InputStream)new ByteArrayInputStream(data), bd);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamSkips(test, check);
        }
    }

    @Test
    public void testInputStreamProxyDetached() throws IOException {
        Decoder d = this.newDecoder(data);
        if (d instanceof BinaryDecoder) {
            BinaryDecoder bd = (BinaryDecoder)d;
            InputStream test = bd.inputStream();
            ByteArrayInputStream check = new ByteArrayInputStream(data);
            this.factory.binaryDecoder(new byte[56], null);
            InputStream bad = bd.inputStream();
            ByteArrayInputStream check2 = new ByteArrayInputStream(data);
            this.validateInputStreamReads(test, check);
            Assert.assertFalse((bad.read() == ((InputStream)check2).read() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInputStreamPartiallyUsed() throws IOException {
        ByteArrayInputStream check;
        InputStream test;
        BinaryDecoder bd;
        block2: {
            bd = this.factory.binaryDecoder((InputStream)new ByteArrayInputStream(data), null);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            try {
                Assert.assertFalse((boolean)bd.isEnd());
            }
            catch (UnsupportedOperationException e) {
                if (bd.getClass() == DirectBinaryDecoder.class) break block2;
                throw e;
            }
        }
        bd.readFloat();
        ((InputStream)check).skip(4L);
        this.validateInputStreamReads(test, check);
    }

    private void validateInputStreamReads(InputStream test, InputStream check) throws IOException {
        int t;
        byte[] bt = new byte[7];
        byte[] bc = new byte[7];
        do {
            t = test.read();
            int c = check.read();
            Assert.assertEquals((long)c, (long)t);
            if (-1 == t) break;
            t = test.read(bt);
            c = check.read(bc);
            Assert.assertEquals((long)c, (long)t);
            Assert.assertArrayEquals((byte[])bt, (byte[])bc);
            if (-1 == t) break;
            t = test.read(bt, 1, 4);
            c = check.read(bc, 1, 4);
            Assert.assertEquals((long)c, (long)t);
            Assert.assertArrayEquals((byte[])bt, (byte[])bc);
        } while (-1 != t);
        Assert.assertEquals((long)0L, (long)test.skip(5L));
        Assert.assertEquals((long)0L, (long)test.available());
        Assert.assertFalse((test.getClass() != ByteArrayInputStream.class && test.markSupported() ? 1 : 0) != 0);
        test.close();
    }

    private void validateInputStreamSkips(InputStream test, InputStream check) throws IOException {
        long t2;
        do {
            t2 = test.skip(19L);
            long c2 = check.skip(19L);
            Assert.assertEquals((long)c2, (long)t2);
        } while (0L != t2);
        Assert.assertEquals((long)-1L, (long)test.read());
    }

    @Test
    public void testBadIntEncoding() throws IOException {
        byte[] badint = new byte[5];
        Arrays.fill(badint, (byte)-1);
        BinaryDecoder bd = this.factory.binaryDecoder(badint, null);
        String message = "";
        try {
            bd.readInt();
        }
        catch (IOException ioe) {
            message = ioe.getMessage();
        }
        Assert.assertEquals((Object)"Invalid int encoding", (Object)message);
    }

    @Test
    public void testBadLongEncoding() throws IOException {
        byte[] badint = new byte[10];
        Arrays.fill(badint, (byte)-1);
        BinaryDecoder bd = this.factory.binaryDecoder(badint, null);
        String message = "";
        try {
            bd.readLong();
        }
        catch (IOException ioe) {
            message = ioe.getMessage();
        }
        Assert.assertEquals((Object)"Invalid long encoding", (Object)message);
    }

    @Test
    public void testBadLengthEncoding() throws IOException {
        byte[] bad = new byte[]{1};
        BinaryDecoder bd = this.factory.binaryDecoder(bad, null);
        String message = "";
        try {
            bd.readString();
        }
        catch (AvroRuntimeException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((Object)"Malformed data. Length is negative: -1", (Object)message);
    }

    @Test(expected=EOFException.class)
    public void testIntTooShort() throws IOException {
        byte[] badint = new byte[4];
        Arrays.fill(badint, (byte)-1);
        this.newDecoder(badint).readInt();
    }

    @Test(expected=EOFException.class)
    public void testLongTooShort() throws IOException {
        byte[] badint = new byte[9];
        Arrays.fill(badint, (byte)-1);
        this.newDecoder(badint).readLong();
    }

    @Test(expected=EOFException.class)
    public void testFloatTooShort() throws IOException {
        byte[] badint = new byte[3];
        Arrays.fill(badint, (byte)-1);
        this.newDecoder(badint).readInt();
    }

    @Test(expected=EOFException.class)
    public void testDoubleTooShort() throws IOException {
        byte[] badint = new byte[7];
        Arrays.fill(badint, (byte)-1);
        this.newDecoder(badint).readLong();
    }

    @Test
    public void testSkipping() throws IOException {
        block6: {
            Decoder d = this.newDecoder(data);
            this.skipGenerated(d);
            if (d instanceof BinaryDecoder) {
                BinaryDecoder bd;
                block5: {
                    bd = (BinaryDecoder)d;
                    try {
                        Assert.assertTrue((boolean)bd.isEnd());
                    }
                    catch (UnsupportedOperationException e) {
                        if (bd.getClass() == DirectBinaryDecoder.class) break block5;
                        throw e;
                    }
                }
                bd = this.factory.binaryDecoder((InputStream)new ByteArrayInputStream(data), bd);
                this.skipGenerated((Decoder)bd);
                try {
                    Assert.assertTrue((boolean)bd.isEnd());
                }
                catch (UnsupportedOperationException e) {
                    if (bd.getClass() == DirectBinaryDecoder.class) break block6;
                    throw e;
                }
            }
        }
    }

    private void skipGenerated(Decoder bd) throws IOException {
        for (int i = 0; i < records.size(); ++i) {
            bd.readInt();
            bd.skipBytes();
            bd.skipFixed(1);
            bd.skipString();
            bd.skipFixed(4);
            bd.skipFixed(8);
            long leftover = bd.skipArray();
            bd.skipFixed((int)leftover + 1);
            bd.skipFixed(0);
            bd.readLong();
        }
        EOFException eof = null;
        try {
            bd.skipFixed(4);
        }
        catch (EOFException e) {
            eof = e;
        }
        Assert.assertTrue((null != eof ? 1 : 0) != 0);
    }

    @Test(expected=EOFException.class)
    public void testEOF() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        e.writeLong(0x10000000000000L);
        e.flush();
        Decoder d = this.newDecoder(new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertEquals((long)0x10000000000000L, (long)d.readLong());
        d.readInt();
    }
}

