/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBlockingIO {
    private static final String UTF_8 = "UTF-8";
    private final int iSize;
    private final int iDepth;
    private final String sInput;
    public static final String __PARANAMER_DATA = "<init> int,int,java.lang.String sz,dp,inp \ndump byte[] bb \n";

    public TestBlockingIO(int sz, int dp, String inp) {
        this.iSize = sz;
        this.iDepth = dp;
        this.sInput = inp;
    }

    protected static void dump(byte[] bb) {
        int col = 0;
        for (byte b : bb) {
            if (col % 16 == 0) {
                System.out.println();
            }
            ++col;
            System.out.print(Integer.toHexString(b & 0xFF) + " ");
        }
        System.out.println();
    }

    @Test
    public void testScan() throws IOException {
        Tests t = new Tests(this.iSize, this.iDepth, this.sInput);
        t.scan();
    }

    @Test
    public void testSkip1() throws IOException {
        this.testSkip(this.iSize, this.iDepth, this.sInput, 0);
    }

    @Test
    public void testSkip2() throws IOException {
        this.testSkip(this.iSize, this.iDepth, this.sInput, 1);
    }

    @Test
    public void testSkip3() throws IOException {
        this.testSkip(this.iSize, this.iDepth, this.sInput, 2);
    }

    private void testSkip(int bufferSize, int depth, String input, int skipLevel) throws IOException {
        Tests t = new Tests(bufferSize, depth, input);
        t.skip(skipLevel);
    }

    private static void skipMap(JsonParser parser, Decoder input, int depth) throws IOException {
        long l = input.skipMap();
        while (l != 0L) {
            for (long i = 0L; i < l; ++i) {
                if (depth == 0) {
                    input.skipBytes();
                    continue;
                }
                TestBlockingIO.skipArray(parser, input, depth - 1);
            }
            l = input.skipMap();
        }
        parser.skipChildren();
    }

    private static void skipArray(JsonParser parser, Decoder input, int depth) throws IOException {
        long l = input.skipArray();
        while (l != 0L) {
            for (long i = 0L; i < l; ++i) {
                if (depth == 1) {
                    input.skipBytes();
                    continue;
                }
                TestBlockingIO.skipArray(parser, input, depth - 1);
            }
            l = input.skipArray();
        }
        parser.skipChildren();
    }

    private static void checkString(String s, Decoder input, int n) throws IOException {
        ByteBuffer buf = input.readBytes(null);
        Assert.assertEquals((long)n, (long)buf.remaining());
        String s2 = new String(buf.array(), buf.position(), buf.remaining(), UTF_8);
        Assert.assertEquals((Object)s, (Object)s2);
    }

    private static void serialize(Encoder cos, JsonParser p, ByteArrayOutputStream os) throws IOException {
        boolean[] isArray = new boolean[100];
        int[] counts = new int[100];
        int stackTop = -1;
        block8: while (p.nextToken() != null) {
            switch (p.getCurrentToken()) {
                case END_ARRAY: {
                    Assert.assertTrue((boolean)isArray[stackTop]);
                    cos.writeArrayEnd();
                    --stackTop;
                    continue block8;
                }
                case END_OBJECT: {
                    Assert.assertFalse((boolean)isArray[stackTop]);
                    cos.writeMapEnd();
                    --stackTop;
                    continue block8;
                }
                case START_ARRAY: {
                    if (stackTop >= 0 && isArray[stackTop]) {
                        cos.setItemCount(1L);
                        cos.startItem();
                        int n = stackTop;
                        counts[n] = counts[n] + 1;
                    }
                    cos.writeArrayStart();
                    isArray[++stackTop] = true;
                    counts[stackTop] = 0;
                    continue block8;
                }
                case VALUE_STRING: {
                    if (stackTop >= 0 && isArray[stackTop]) {
                        cos.setItemCount(1L);
                        cos.startItem();
                        int n = stackTop;
                        counts[n] = counts[n] + 1;
                    }
                    byte[] bb = p.getText().getBytes(UTF_8);
                    cos.writeBytes(bb);
                    continue block8;
                }
                case START_OBJECT: {
                    if (stackTop >= 0 && isArray[stackTop]) {
                        cos.setItemCount(1L);
                        cos.startItem();
                        int n = stackTop;
                        counts[n] = counts[n] + 1;
                    }
                    cos.writeMapStart();
                    isArray[++stackTop] = false;
                    counts[stackTop] = 0;
                    continue block8;
                }
                case FIELD_NAME: {
                    cos.setItemCount(1L);
                    cos.startItem();
                    int n = stackTop;
                    counts[n] = counts[n] + 1;
                    cos.writeBytes(p.getCurrentName().getBytes(UTF_8));
                    continue block8;
                }
            }
            throw new RuntimeException("Unsupported: " + p.getCurrentToken());
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({64, 0, ""}, {64, 0, TestBlockingIO.jss(0, 'a')}, {64, 0, TestBlockingIO.jss(3, 'a')}, {64, 0, TestBlockingIO.jss(64, 'a')}, {64, 0, TestBlockingIO.jss(65, 'a')}, {64, 0, TestBlockingIO.jss(100, 'a')}, {64, 1, "[]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(3, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(61, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(62, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(64, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(65, 'a') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(10, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(63, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(64, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(65, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(0, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(10, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(51, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(52, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(54, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(55, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(63, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(64, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(0, 'a') + "," + TestBlockingIO.jss(65, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(20, 'A') + "," + TestBlockingIO.jss(10, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(20, 'A') + "," + TestBlockingIO.jss(23, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(20, 'A') + "," + TestBlockingIO.jss(24, '0') + "]"}, {64, 1, "[" + TestBlockingIO.jss(10, 'a') + "," + TestBlockingIO.jss(20, 'A') + "," + TestBlockingIO.jss(25, '0') + "]"}, {64, 2, "[[]]"}, {64, 2, "[[" + TestBlockingIO.jss(0, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(10, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(59, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(60, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(100, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(53, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(54, 'a') + "], []]"}, {64, 2, "[[" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(55, 'a') + "], []]"}, {64, 2, "[[], [" + TestBlockingIO.jss(0, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(10, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(63, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(64, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(65, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(53, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(54, 'a') + "]]"}, {64, 2, "[[], [" + TestBlockingIO.jss(10, '0') + ", " + TestBlockingIO.jss(55, 'a') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(10, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(62, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(63, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(64, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(10, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(52, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(53, '0') + "]]"}, {64, 2, "[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(54, '0') + "]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(62, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(63, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(64, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(10, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(52, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + ", " + TestBlockingIO.jss(53, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + "], [" + TestBlockingIO.jss(54, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + "], [" + TestBlockingIO.jss(10, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + "], [" + TestBlockingIO.jss(52, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + "], [" + TestBlockingIO.jss(53, '0') + "]]]"}, {64, 3, "[[[" + TestBlockingIO.jss(10, 'a') + "], [" + TestBlockingIO.jss(54, '0') + "]]]"}, {64, 2, "[[\"p\"], [\"mn\"]]"}, {64, 2, "[[\"pqr\"], [\"mn\"]]"}, {64, 2, "[[\"pqrstuvwxyz\"], [\"mn\"]]"}, {64, 2, "[[\"abc\", \"pqrstuvwxyz\"], [\"mn\"]]"}, {64, 2, "[[\"mn\"], [\"\"]]"}, {64, 2, "[[\"mn\"], \"abc\"]"}, {64, 2, "[[\"mn\"], \"abcdefghijk\"]"}, {64, 2, "[[\"mn\"], \"pqr\", \"abc\"]"}, {64, 2, "[[\"mn\"]]"}, {64, 2, "[[\"p\"], [\"mnopqrstuvwx\"]]"}, {64, 2, "[[\"pqr\"], [\"mnopqrstuvwx\"]]"}, {64, 2, "[[\"pqrstuvwxyz\"], [\"mnopqrstuvwx\"]]"}, {64, 2, "[[\"abc\"], \"pqrstuvwxyz\", [\"mnopqrstuvwx\"]]"}, {64, 2, "[[\"mnopqrstuvwx\"], [\"\"]]"}, {64, 2, "[[\"mnopqrstuvwx\"], [\"abc\"]]"}, {64, 2, "[[\"mnopqrstuvwx\"], [\"abcdefghijk\"]]"}, {64, 2, "[[\"mnopqrstuvwx\"], [\"pqr\", \"abc\"]]"}, {100, 2, "[[\"pqr\", \"mnopqrstuvwx\"]]"}, {100, 2, "[[\"pqr\", \"ab\", \"mnopqrstuvwx\"]]"}, {64, 2, "[[[\"pqr\"]], [[\"ab\"], [\"mnopqrstuvwx\"]]]"}, {64, 1, "{}"}, {64, 1, "{\"n\": \"v\"}"}, {64, 1, "{\"n1\": \"v\", \"n2\": []}"}, {100, 1, "{\"n1\": \"v\", \"n2\": []}"}, {100, 1, "{\"n1\": \"v\", \"n2\": [\"abc\"]}"});
    }

    private static String jss(int n, char c) {
        char[] cc = new char[n + 2];
        cc[n + 1] = 34;
        cc[0] = 34;
        for (int i = 1; i < n + 1; ++i) {
            c = c == 'Z' ? (char)97 : (c == 'z' ? (char)48 : (c == '9' ? (char)65 : (char)(c + '\u0001')));
            cc[i] = c;
        }
        return new String(cc);
    }

    private static class S {
        public final long count;
        public final boolean isArray;
        public static final String __PARANAMER_DATA = "<init> long,boolean count,isArray \n";

        public S(long count, boolean isArray) {
            this.count = count;
            this.isArray = isArray;
        }
    }

    private static class Tests {
        private final JsonParser parser;
        private final Decoder input;
        private final int depth;
        public static final String __PARANAMER_DATA = "<init> int,int,java.lang.String bufferSize,depth,input \nskip int skipLevel \n";

        public Tests(int bufferSize, int depth, String input) throws IOException {
            this.depth = depth;
            byte[] in = input.getBytes(TestBlockingIO.UTF_8);
            JsonFactory f = new JsonFactory();
            JsonParser p = f.createJsonParser((InputStream)new ByteArrayInputStream(input.getBytes(TestBlockingIO.UTF_8)));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            EncoderFactory factory = new EncoderFactory().configureBlockSize(bufferSize);
            BinaryEncoder cos = factory.blockingBinaryEncoder((OutputStream)os, null);
            TestBlockingIO.serialize((Encoder)cos, p, os);
            cos.flush();
            byte[] bb = os.toByteArray();
            this.input = DecoderFactory.get().binaryDecoder(bb, null);
            this.parser = f.createJsonParser((InputStream)new ByteArrayInputStream(in));
        }

        public void scan() throws IOException {
            Stack<S> countStack = new Stack<S>();
            long count = 0L;
            block8: while (this.parser.nextToken() != null) {
                switch (this.parser.getCurrentToken()) {
                    case END_ARRAY: {
                        Assert.assertEquals((long)0L, (long)count);
                        Assert.assertTrue((boolean)((S)countStack.peek()).isArray);
                        count = ((S)countStack.pop()).count;
                        break;
                    }
                    case END_OBJECT: {
                        Assert.assertEquals((long)0L, (long)count);
                        Assert.assertFalse((boolean)((S)countStack.peek()).isArray);
                        count = ((S)countStack.pop()).count;
                        break;
                    }
                    case START_ARRAY: {
                        countStack.push(new S(count, true));
                        count = this.input.readArrayStart();
                        continue block8;
                    }
                    case VALUE_STRING: {
                        String s = this.parser.getText();
                        int n = s.getBytes(TestBlockingIO.UTF_8).length;
                        TestBlockingIO.checkString(s, this.input, n);
                        break;
                    }
                    case FIELD_NAME: {
                        String s = this.parser.getCurrentName();
                        int n = s.getBytes(TestBlockingIO.UTF_8).length;
                        TestBlockingIO.checkString(s, this.input, n);
                        continue block8;
                    }
                    case START_OBJECT: {
                        countStack.push(new S(count, false));
                        count = this.input.readMapStart();
                        if (count >= 0L) continue block8;
                        count = -count;
                        this.input.readLong();
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("Unsupported: " + this.parser.getCurrentToken());
                    }
                }
                if (--count != 0L) continue;
                count = ((S)countStack.peek()).isArray ? this.input.arrayNext() : this.input.mapNext();
            }
        }

        public void skip(int skipLevel) throws IOException {
            Stack<S> countStack = new Stack<S>();
            long count = 0L;
            block8: while (this.parser.nextToken() != null) {
                switch (this.parser.getCurrentToken()) {
                    case END_ARRAY: {
                        Assert.assertTrue((boolean)((S)countStack.peek()).isArray);
                        count = ((S)countStack.pop()).count;
                        break;
                    }
                    case END_OBJECT: {
                        Assert.assertFalse((boolean)((S)countStack.peek()).isArray);
                        count = ((S)countStack.pop()).count;
                        break;
                    }
                    case START_ARRAY: {
                        if (countStack.size() == skipLevel) {
                            TestBlockingIO.skipArray(this.parser, this.input, this.depth - skipLevel);
                            break;
                        }
                        countStack.push(new S(count, true));
                        count = this.input.readArrayStart();
                        continue block8;
                    }
                    case VALUE_STRING: {
                        if (countStack.size() == skipLevel) {
                            this.input.skipBytes();
                            break;
                        }
                        String s = this.parser.getText();
                        int n = s.getBytes(TestBlockingIO.UTF_8).length;
                        TestBlockingIO.checkString(s, this.input, n);
                        break;
                    }
                    case FIELD_NAME: {
                        String s = this.parser.getCurrentName();
                        int n = s.getBytes(TestBlockingIO.UTF_8).length;
                        TestBlockingIO.checkString(s, this.input, n);
                        continue block8;
                    }
                    case START_OBJECT: {
                        if (countStack.size() == skipLevel) {
                            TestBlockingIO.skipMap(this.parser, this.input, this.depth - skipLevel);
                            break;
                        }
                        countStack.push(new S(count, false));
                        count = this.input.readMapStart();
                        if (count >= 0L) continue block8;
                        count = -count;
                        this.input.readLong();
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("Unsupported: " + this.parser.getCurrentToken());
                    }
                }
                if (--count != 0L) continue;
                count = ((S)countStack.peek()).isArray ? this.input.arrayNext() : this.input.mapNext();
            }
        }
    }
}

