/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.TestValidatingIO;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBlockingIO2 {
    private final Decoder decoder;
    private final String calls;
    private Object[] values;
    public static final String __PARANAMER_DATA = "<init> int,int,java.lang.String bufferSize,skipLevel,calls \n";

    public TestBlockingIO2(int bufferSize, int skipLevel, String calls) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        EncoderFactory factory = new EncoderFactory().configureBlockSize(bufferSize);
        BinaryEncoder encoder = factory.blockingBinaryEncoder((OutputStream)os, null);
        this.values = TestValidatingIO.randomValues(calls);
        TestValidatingIO.generate((Encoder)encoder, calls, this.values);
        encoder.flush();
        byte[] bb = os.toByteArray();
        this.decoder = DecoderFactory.get().binaryDecoder(bb, null);
        this.calls = calls;
    }

    @Test
    public void testScan() throws IOException {
        TestValidatingIO.check(this.decoder, this.calls, this.values, -1);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({64, 0, ""}, {64, 0, "S0"}, {64, 0, "S3"}, {64, 0, "S64"}, {64, 0, "S65"}, {64, 0, "S100"}, {64, 1, "[]"}, {64, 1, "[c1sS0]"}, {64, 1, "[c1sS3]"}, {64, 1, "[c1sS61]"}, {64, 1, "[c1sS62]"}, {64, 1, "[c1sS64]"}, {64, 1, "[c1sS65]"}, {64, 1, "[c2sS0sS0]"}, {64, 1, "[c2sS0sS10]"}, {64, 1, "[c2sS0sS63]"}, {64, 1, "[c2sS0sS64]"}, {64, 1, "[c2sS0sS65]"}, {64, 1, "[c2sS10sS0]"}, {64, 1, "[c2sS10sS10]"}, {64, 1, "[c2sS10sS51]"}, {64, 1, "[c2sS10sS52]"}, {64, 1, "[c2sS10sS54]"}, {64, 1, "[c2sS10sS55]"}, {64, 1, "[c3sS0sS0sS0]"}, {64, 1, "[c3sS0sS0sS63]"}, {64, 1, "[c3sS0sS0sS64]"}, {64, 1, "[c3sS0sS0sS65]"}, {64, 1, "[c3sS10sS20sS10]"}, {64, 1, "[c3sS10sS20sS23]"}, {64, 1, "[c3sS10sS20sS24]"}, {64, 1, "[c3sS10sS20sS25]"}, {64, 1, "[c1s[]]"}, {64, 1, "[c1s[c1sS0]]"}, {64, 1, "[c1s[c1sS10]]"}, {64, 1, "[c2s[c1sS10]s[]]"}, {64, 1, "[c2s[c1sS59]s[]]"}, {64, 1, "[c2s[c1sS60]s[]]"}, {64, 1, "[c2s[c1sS100]s[]]"}, {64, 1, "[c2s[c2sS10sS53]s[]]"}, {64, 1, "[c2s[c2sS10sS54]s[]]"}, {64, 1, "[c2s[c2sS10sS55]s[]]"}, {64, 1, "[c2s[]s[c1sS0]]"}, {64, 1, "[c2s[]s[c1sS10]]"}, {64, 1, "[c2s[]s[c1sS63]]"}, {64, 1, "[c2s[]s[c1sS64]]"}, {64, 1, "[c2s[]s[c1sS65]]"}, {64, 1, "[c2s[]s[c2sS10sS53]]"}, {64, 1, "[c2s[]s[c2sS10sS54]]"}, {64, 1, "[c2s[]s[c2sS10sS55]]"}, {64, 1, "[c1s[c1sS10]]"}, {64, 1, "[c1s[c1sS62]]"}, {64, 1, "[c1s[c1sS63]]"}, {64, 1, "[c1s[c1sS64]]"}, {64, 1, "[c1s[c2sS10sS10]]"}, {64, 1, "[c1s[c2sS10sS52]]"}, {64, 1, "[c1s[c2sS10sS53]]"}, {64, 1, "[c1s[c2sS10sS54]]"}, {64, 1, "[c1s[c1s[c1sS10]]]"}, {64, 1, "[c1s[c1s[c1sS62]]]"}, {64, 1, "[c1s[c1s[c1sS63]]]"}, {64, 1, "[c1s[c1s[c1sS64]]]"}, {64, 1, "[c1s[c1s[c2sS10sS10]]]"}, {64, 1, "[c1s[c1s[c2sS10sS52]]]"}, {64, 1, "[c1s[c1s[c2sS10sS53]]]"}, {64, 1, "[c1s[c1s[c2sS10sS54]]]"}, {64, 1, "[c1s[c2sS10s[c1sS10]]]"}, {64, 1, "[c1s[c2sS10s[c1sS52]]]"}, {64, 1, "[c1s[c2sS10s[c1sS53]]]"}, {64, 1, "[c1s[c2sS10s[c1sS54]]]"}, {64, 1, "{}"}, {64, 1, "{c1sK5S1}"}, {64, 1, "{c1sK5[]}"}, {100, 1, "{c1sK5[]}"}, {100, 1, "{c1sK5[c1sS10]}"}, {100, 1, "{c1sK5e10}"}, {100, 1, "{c1sK5U1S10}"}, {100, 1, "{c1sK5f10S10}"}, {100, 1, "{c1sK5NS10}"}, {100, 1, "{c1sK5BS10}"}, {100, 1, "{c1sK5IS10}"}, {100, 1, "{c1sK5LS10}"}, {100, 1, "{c1sK5FS10}"}, {100, 1, "{c1sK5DS10}"});
    }
}

