/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Assert;
import org.junit.Test;

public class TestEncoders {
    private static EncoderFactory factory = EncoderFactory.get();
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder enc = factory.binaryEncoder((OutputStream)out, null);
        Assert.assertTrue((enc == factory.binaryEncoder((OutputStream)out, enc) ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testBadBinaryEncoderInit() {
        factory.binaryEncoder(null, null);
    }

    @Test
    public void testBlockingBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder reuse = null;
        Assert.assertTrue(((reuse = factory.blockingBinaryEncoder((OutputStream)out, reuse)) == factory.blockingBinaryEncoder((OutputStream)out, reuse) ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testBadBlockintBinaryEncoderInit() {
        factory.binaryEncoder(null, null);
    }

    @Test
    public void testDirectBinaryEncoderInit() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder enc = factory.directBinaryEncoder((OutputStream)out, null);
        Assert.assertTrue((enc == factory.directBinaryEncoder((OutputStream)out, enc) ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testBadDirectBinaryEncoderInit() {
        factory.directBinaryEncoder(null, null);
    }

    @Test
    public void testJsonEncoderInit() throws IOException {
        Schema s = Schema.parse((String)"\"int\"");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        factory.jsonEncoder(s, (OutputStream)out);
        JsonEncoder enc = factory.jsonEncoder(s, new JsonFactory().createJsonGenerator((OutputStream)out, JsonEncoding.UTF8));
        enc.configure((OutputStream)out);
    }

    @Test(expected=NullPointerException.class)
    public void testBadJsonEncoderInitOS() throws IOException {
        factory.jsonEncoder(Schema.create((Schema.Type)Schema.Type.INT), (OutputStream)null);
    }

    @Test(expected=NullPointerException.class)
    public void testBadJsonEncoderInit() throws IOException {
        factory.jsonEncoder(Schema.create((Schema.Type)Schema.Type.INT), (JsonGenerator)null);
    }

    @Test
    public void testJsonEncoderNewlineDelimited() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Schema ints = Schema.create((Schema.Type)Schema.Type.INT);
        JsonEncoder e = factory.jsonEncoder(ints, (OutputStream)out);
        String separator = System.getProperty("line.separator");
        GenericDatumWriter writer = new GenericDatumWriter(ints);
        writer.write((Object)1, (Encoder)e);
        writer.write((Object)2, (Encoder)e);
        e.flush();
        Assert.assertEquals((Object)("1" + separator + "2"), (Object)((Object)out).toString());
    }

    @Test
    public void testValidatingEncoderInit() throws IOException {
        Schema s = Schema.parse((String)"\"int\"");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder e = factory.directBinaryEncoder((OutputStream)out, null);
        factory.validatingEncoder(s, (Encoder)e).configure((Encoder)e);
    }

    @Test
    public void testJsonRecordOrdering() throws IOException {
        String value = "{\"b\": 2, \"a\": 1}";
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [{\"name\": \"a\", \"type\": \"int\"}, {\"name\": \"b\", \"type\": \"int\"}]}");
        GenericDatumReader reader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)"{\"a\": 1, \"b\": 2}", (Object)o.toString());
    }

    @Test(expected=AvroTypeException.class)
    public void testJsonExcessFields() throws IOException {
        String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a0\": 45, \"a2\":true, \"a1\": null}}";
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
        reader.read(null, (Decoder)decoder);
    }

    @Test
    public void testJsonRecordOrdering2() throws IOException {
        String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}, \"b\": {\"b1\": \"h\", \"b2\": 3.14, \"b3\": 1.4}}", (Object)o.toString());
    }

    @Test
    public void testJsonRecordOrderingWithProjection() throws IOException {
        String value = "{\"b\": { \"b3\": 1.4, \"b2\": 3.14, \"b1\": \"h\"}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema writerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":\"float\"}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        Schema readerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(writerSchema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}}", (Object)o.toString());
    }

    @Test
    public void testJsonRecordOrderingWithProjection2() throws IOException {
        String value = "{\"b\": { \"b1\": \"h\", \"b2\": [3.14, 3.56], \"b3\": 1.4}, \"a\": {\"a2\":true, \"a1\": null}}";
        Schema writerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}},\n{\"name\": \"b\", \"type\": {\"type\":\"record\",\"name\":\"B\",\"fields\":\n[{\"name\":\"b1\", \"type\":\"string\"}, {\"name\":\"b2\", \"type\":{\"type\":\"array\", \"items\":\"float\"}}, {\"name\":\"b3\", \"type\":\"double\"}]}}\n]}");
        Schema readerSchema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"ab\", \"fields\": [\n{\"name\": \"a\", \"type\": {\"type\":\"record\",\"name\":\"A\",\"fields\":\n[{\"name\":\"a1\", \"type\":\"null\"}, {\"name\":\"a2\", \"type\":\"boolean\"}]}}\n]}");
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(writerSchema, value);
        Object o = reader.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)"{\"a\": {\"a1\": null, \"a2\": true}}", (Object)o.toString());
    }
}

