/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonDecoder {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testInt() throws Exception {
        this.checkNumeric("int", 1);
    }

    @Test
    public void testLong() throws Exception {
        this.checkNumeric("long", 1L);
    }

    @Test
    public void testFloat() throws Exception {
        this.checkNumeric("float", Float.valueOf(1.0f));
    }

    @Test
    public void testDouble() throws Exception {
        this.checkNumeric("double", 1.0);
    }

    private void checkNumeric(String type, Object value) throws Exception {
        String[] records;
        String def = "{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"type\":\"" + type + "\",\"name\":\"n\"}]}";
        Schema schema = Schema.parse((String)def);
        GenericDatumReader reader = new GenericDatumReader(schema);
        for (String record : records = new String[]{"{\"n\":1}", "{\"n\":1.0}"}) {
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, record);
            GenericRecord r = (GenericRecord)reader.read(null, (Decoder)decoder);
            Assert.assertEquals((Object)value, (Object)r.get("n"));
        }
    }

    @Test
    public void testReorderFields() throws Exception {
        String w = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"type\":\"long\",\"name\":\"l\"},{\"type\":{\"type\":\"array\",\"items\":\"int\"},\"name\":\"a\"}]}";
        Schema ws = Schema.parse((String)w);
        DecoderFactory df = DecoderFactory.get();
        String data = "{\"a\":[1,2],\"l\":100}{\"l\": 200, \"a\":[1,2]}";
        JsonDecoder in = df.jsonDecoder(ws, data);
        Assert.assertEquals((long)100L, (long)in.readLong());
        in.skipArray();
        Assert.assertEquals((long)200L, (long)in.readLong());
        in.skipArray();
    }
}

