/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.io.TestValidatingIO;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResolvingIO {
    protected final TestValidatingIO.Encoding eEnc;
    protected final int iSkipL;
    protected final String sJsWrtSchm;
    protected final String sWrtCls;
    protected final String sJsRdrSchm;
    protected final String sRdrCls;
    private static final int COUNT = 10;
    static Object[][] encodings = new Object[][]{{TestValidatingIO.Encoding.BINARY}, {TestValidatingIO.Encoding.BLOCKING_BINARY}, {TestValidatingIO.Encoding.JSON}};
    static Object[][] skipLevels = new Object[][]{{-1}, {0}, {1}, {2}};
    public static final String __PARANAMER_DATA = "<init> org.apache.avro.io.TestValidatingIO$Encoding,int,java.lang.String,java.lang.String,java.lang.String,java.lang.String encoding,skipLevel,jsonWriterSchema,writerCalls,jsonReaderSchema,readerCalls \ncheck org.apache.avro.Schema,org.apache.avro.Schema,byte[],java.lang.String,java.lang.Object[],org.apache.avro.io.TestValidatingIO$Encoding,int wsc,rsc,bytes,calls,values,encoding,skipLevel \n";

    public TestResolvingIO(TestValidatingIO.Encoding encoding, int skipLevel, String jsonWriterSchema, String writerCalls, String jsonReaderSchema, String readerCalls) {
        this.eEnc = encoding;
        this.iSkipL = skipLevel;
        this.sJsWrtSchm = jsonWriterSchema;
        this.sWrtCls = writerCalls;
        this.sJsRdrSchm = jsonReaderSchema;
        this.sRdrCls = readerCalls;
    }

    @Test
    public void testIdentical() throws IOException {
        this.performTest(this.eEnc, this.iSkipL, this.sJsWrtSchm, this.sWrtCls, this.sJsWrtSchm, this.sWrtCls);
    }

    @Test
    public void testCompatible() throws IOException {
        this.performTest(this.eEnc, this.iSkipL, this.sJsWrtSchm, this.sWrtCls, this.sJsRdrSchm, this.sRdrCls);
    }

    private void performTest(TestValidatingIO.Encoding encoding, int skipLevel, String jsonWriterSchema, String writerCalls, String jsonReaderSchema, String readerCalls) throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.testOnce(jsonWriterSchema, writerCalls, jsonReaderSchema, readerCalls, encoding, skipLevel);
        }
    }

    private void testOnce(String jsonWriterSchema, String writerCalls, String jsonReaderSchema, String readerCalls, TestValidatingIO.Encoding encoding, int skipLevel) throws IOException {
        Object[] values = TestValidatingIO.randomValues(writerCalls);
        Object[] expected = TestValidatingIO.randomValues(readerCalls);
        Schema writerSchema = new Schema.Parser().parse(jsonWriterSchema);
        byte[] bytes = TestValidatingIO.make(writerSchema, writerCalls, values, encoding);
        Schema readerSchema = new Schema.Parser().parse(jsonReaderSchema);
        TestValidatingIO.print(encoding, skipLevel, writerSchema, readerSchema, values, expected);
        TestResolvingIO.check(writerSchema, readerSchema, bytes, readerCalls, expected, encoding, skipLevel);
    }

    static void check(Schema wsc, Schema rsc, byte[] bytes, String calls, Object[] values, TestValidatingIO.Encoding encoding, int skipLevel) throws IOException {
        BinaryDecoder bvi = null;
        switch (encoding) {
            case BINARY: 
            case BLOCKING_BINARY: {
                bvi = DecoderFactory.get().binaryDecoder(bytes, null);
                break;
            }
            case JSON: {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                bvi = new JsonDecoder(wsc, (InputStream)in);
            }
        }
        ResolvingDecoder vi = new ResolvingDecoder(wsc, rsc, (Decoder)bvi);
        TestValidatingIO.check((Decoder)vi, calls, values, skipLevel);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data2() {
        return Arrays.asList(TestValidatingIO.convertTo2dArray(encodings, skipLevels, TestResolvingIO.testSchemas()));
    }

    private static Object[][] testSchemas() {
        return new Object[][]{{"\"int\"", "I", "\"float\"", "F"}, {"\"int\"", "I", "\"double\"", "D"}, {"\"int\"", "I", "\"long\"", "L"}, {"\"long\"", "L", "\"float\"", "F"}, {"\"long\"", "L", "\"double\"", "D"}, {"\"float\"", "F", "\"double\"", "D"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[]", "{\"type\":\"array\", \"items\": \"long\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[]", "{\"type\":\"array\", \"items\": \"double\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"long\"}", "[]", "{\"type\":\"array\", \"items\": \"double\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"float\"}", "[]", "{\"type\":\"array\", \"items\": \"double\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[c1sI]", "{\"type\":\"array\", \"items\": \"long\"}", "[c1sL]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[c1sI]", "{\"type\":\"array\", \"items\": \"double\"}", "[c1sD]"}, {"{\"type\":\"array\", \"items\": \"long\"}", "[c1sL]", "{\"type\":\"array\", \"items\": \"double\"}", "[c1sD]"}, {"{\"type\":\"array\", \"items\": \"float\"}", "[c1sF]", "{\"type\":\"array\", \"items\": \"double\"}", "[c1sD]"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{}", "{\"type\":\"map\", \"values\": \"long\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{}", "{\"type\":\"map\", \"values\": \"double\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"long\"}", "{}", "{\"type\":\"map\", \"values\": \"double\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"float\"}", "{}", "{\"type\":\"map\", \"values\": \"double\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{c1sK5I}", "{\"type\":\"map\", \"values\": \"long\"}", "{c1sK5L}"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{c1sK5I}", "{\"type\":\"map\", \"values\": \"double\"}", "{c1sK5D}"}, {"{\"type\":\"map\", \"values\": \"long\"}", "{c1sK5L}", "{\"type\":\"map\", \"values\": \"double\"}", "{c1sK5D}"}, {"{\"type\":\"map\", \"values\": \"float\"}", "{c1sK5F}", "{\"type\":\"map\", \"values\": \"double\"}", "{c1sK5D}"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"int\"}]}", "I", "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"long\"}]}", "L"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"int\"}]}", "I", "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"double\"}]}", "D"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"},{\"name\":\"f1\", \"type\":\"int\"},{\"name\":\"f2\", \"type\":\"float\"},{\"name\":\"f3\", \"type\":\"bytes\"},{\"name\":\"f4\", \"type\":\"string\"}]}", "BIFbS", "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"},{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":\"double\"},{\"name\":\"f3\", \"type\":\"string\"},{\"name\":\"f4\", \"type\":\"bytes\"}]}", "BLDSb"}, {"[\"int\"]", "U0I", "[\"long\"]", "U0L"}, {"[\"int\"]", "U0I", "[\"double\"]", "U0D"}, {"[\"long\"]", "U0L", "[\"double\"]", "U0D"}, {"[\"float\"]", "U0F", "[\"double\"]", "U0D"}, {"\"int\"", "I", "[\"int\"]", "U0I"}, {"[\"int\"]", "U0I", "\"int\"", "I"}, {"[\"int\"]", "U0I", "\"long\"", "L"}, {"[\"boolean\", \"int\"]", "U1I", "[\"boolean\", \"long\"]", "U1L"}, {"[\"boolean\", \"int\"]", "U1I", "[\"long\", \"boolean\"]", "U0L"}};
    }
}

