/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.TestResolvingIO;
import org.apache.avro.io.TestValidatingIO;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResolvingIOResolving {
    protected TestValidatingIO.Encoding eEnc;
    protected final int iSkipL;
    protected final String sJsWrtSchm;
    protected final String sWrtCls;
    protected final String sJsRdrSchm;
    protected final String sRdrCls;
    protected final Object[] oaWrtVals;
    protected final Object[] oaRdrVals;
    public static final String __PARANAMER_DATA = "<init> org.apache.avro.io.TestValidatingIO$Encoding,int,java.lang.String,java.lang.String,java.lang.Object[],java.lang.String,java.lang.String,java.lang.Object[] encoding,skipLevel,jsonWriterSchema,writerCalls,writerValues,jsonReaderSchema,readerCalls,readerValues \n";

    public TestResolvingIOResolving(TestValidatingIO.Encoding encoding, int skipLevel, String jsonWriterSchema, String writerCalls, Object[] writerValues, String jsonReaderSchema, String readerCalls, Object[] readerValues) {
        this.eEnc = encoding;
        this.iSkipL = skipLevel;
        this.sJsWrtSchm = jsonWriterSchema;
        this.sWrtCls = writerCalls;
        this.oaWrtVals = writerValues;
        this.sJsRdrSchm = jsonReaderSchema;
        this.sRdrCls = readerCalls;
        this.oaRdrVals = readerValues;
    }

    @Test
    public void testResolving() throws IOException {
        Schema writerSchema = new Schema.Parser().parse(this.sJsWrtSchm);
        byte[] bytes = TestValidatingIO.make(writerSchema, this.sWrtCls, this.oaWrtVals, this.eEnc);
        Schema readerSchema = new Schema.Parser().parse(this.sJsRdrSchm);
        TestValidatingIO.print(this.eEnc, this.iSkipL, writerSchema, readerSchema, this.oaWrtVals, this.oaRdrVals);
        TestResolvingIO.check(writerSchema, readerSchema, bytes, this.sRdrCls, this.oaRdrVals, this.eEnc, this.iSkipL);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data3() {
        List<Object[]> ret = Arrays.asList(TestValidatingIO.convertTo2dArray(TestResolvingIO.encodings, TestResolvingIO.skipLevels, TestResolvingIOResolving.dataForResolvingTests()));
        return ret;
    }

    private static Object[][] dataForResolvingTests() {
        return new Object[][]{{"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"string\"},{\"name\":\"f2\", \"type\":\"string\"},{\"name\":\"f3\", \"type\":\"int\"}]}", "S10S10IS10S10I", new Object[]{"s1", "s2", 100, "t1", "t2", 200}, "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"string\" },{\"name\":\"f2\", \"type\":\"string\"}]}", "RS10S10RS10S10", new Object[]{"s1", "s2", "t1", "t2"}}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"int\"},{\"name\":\"f2\", \"type\":\"string\"}]}", "IS10", new Object[]{10, "hello"}, "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f2\", \"type\":\"string\" },{\"name\":\"f1\", \"type\":\"long\"}]}", "RLS10", new Object[]{10L, "hello"}}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[]}", "", new Object[0], "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"int\", \"default\": 100}]}", "RI", new Object[]{100}}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f2\", \"type\":\"int\"}]}", "I", new Object[]{10}, "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"int\", \"default\": 101},{\"name\":\"f2\", \"type\":\"int\"}]}", "RII", new Object[]{10, 101}}, {"{\"type\":\"record\",\"name\":\"outer\",\"fields\":[{\"name\": \"g1\", \"type\":{\"type\":\"record\",\"name\":\"inner\",\"fields\":[{\"name\":\"f2\", \"type\":\"int\"}]}}, {\"name\": \"g2\", \"type\": \"long\"}]}", "IL", new Object[]{10, 11L}, "{\"type\":\"record\",\"name\":\"outer\",\"fields\":[{\"name\": \"g1\", \"type\":{\"type\":\"record\",\"name\":\"inner\",\"fields\":[{\"name\":\"f1\", \"type\":\"int\", \"default\": 101},{\"name\":\"f2\", \"type\":\"int\"}]}}, {\"name\": \"g2\", \"type\": \"long\"}]}}", "RRIIL", new Object[]{10, 101, 11L}}, {"{\"type\":\"record\",\"name\":\"outer\",\"fields\":[{\"name\": \"g2\", \"type\": \"long\"}]}", "L", new Object[]{11L}, "{\"type\":\"record\",\"name\":\"outer\",\"fields\":[{\"name\": \"g1\", \"type\":{\"type\":\"record\",\"name\":\"inner\",\"fields\":[{\"name\":\"f1\", \"type\":\"int\" },{\"name\":\"f2\", \"type\":\"int\"}] }, \"default\": { \"f1\": 10, \"f2\": 101 } }, {\"name\": \"g2\", \"type\": \"long\"}]}", "RLRII", new Object[]{11L, 10, 101}}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[]}", "", new Object[0], "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":{ \"type\": \"array\", \"items\": \"int\" }, \"default\": [100]}]}", "[c1sI]", new Object[]{100}}, {"{ \"type\": \"array\", \"items\": {\"type\":\"record\",\"name\":\"r\",\"fields\":[]} }", "[c1s]", new Object[0], "{ \"type\": \"array\", \"items\": {\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"int\", \"default\": 100}]} }", "[c1sI]", new Object[]{100}}, {"{\"type\":\"enum\",\"name\":\"e\",\"symbols\":[\"x\",\"y\",\"z\"]}", "e2", new Object[0], "{\"type\":\"enum\",\"name\":\"e\",\"symbols\":[ \"y\", \"z\" ]}", "e1", new Object[0]}, {"{\"type\":\"enum\",\"name\":\"e\",\"symbols\":[ \"x\", \"y\" ]}", "e1", new Object[0], "{\"type\":\"enum\",\"name\":\"e\",\"symbols\":[ \"y\", \"z\" ]}", "e0", new Object[0]}, {"\"int\"", "I", new Object[]{100}, "[ \"long\", \"int\"]", "U1I", new Object[]{100}}, {"[ \"long\", \"int\"]", "U1I", new Object[]{100}, "\"int\"", "I", new Object[]{100}}, {"\"int\"", "I", new Object[]{100}, "[ \"long\", \"string\"]", "U0L", new Object[]{100L}}, {"[ \"int\", \"string\"]", "U0I", new Object[]{100}, "\"long\"", "L", new Object[]{100L}}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"},{\"name\":\"f1\", \"type\":\"int\"},{\"name\":\"f2\", \"type\":[\"int\", \"long\"]},{\"name\":\"f3\", \"type\":\"float\"}]}", "BIU0IF", new Object[]{true, 100, 121, Float.valueOf(10.75f)}, "{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"},{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f3\", \"type\":\"double\"}]}", "BLD", new Object[]{true, 100L, 10.75}}, {"{ \"type\": \"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"},{\"name\":\"f1\", \"type\": {\"type\":\"array\", \"items\": \"boolean\" }}]}}", "[c2sB[c2sBsB]sB[c3sBsBsB]]", new Object[]{true, false, false, false, true, true, true}, "{ \"type\": \"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"boolean\"}]}}", "[c2sBsB]", new Object[]{true, false}}};
    }
}

