/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.io.ValidatingDecoder;
import org.apache.avro.io.ValidatingEncoder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestValidatingIO {
    private static final Logger LOG = LoggerFactory.getLogger(TestValidatingIO.class);
    private Encoding eEnc;
    private int iSkipL;
    private String sJsSch;
    private String sCl;
    private static final int COUNT = 1;
    private static Object[][] encodings = new Object[][]{{Encoding.BINARY}, {Encoding.BLOCKING_BINARY}, {Encoding.JSON}};
    private static Object[][] skipLevels = new Object[][]{{-1}, {0}, {1}, {2}};
    public static final String __PARANAMER_DATA = "<init> org.apache.avro.io.TestValidatingIO$Encoding,int,java.lang.String,java.lang.String enc,skip,js,cls \nmake org.apache.avro.Schema,java.lang.String,java.lang.Object[],org.apache.avro.io.TestValidatingIO$Encoding sc,calls,values,encoding \nconcat java.lang.Object[] oo \nrandomValues java.lang.String calls \nconvertTo2dArray java.lang.Object[][] values \npaste java.lang.Object[][] in \ncartesian java.lang.Object[][] values \ncheck Decoder,java.lang.String,java.lang.Object[],int vi,calls,values,skipLevel \ndump byte[] bb \ngenerate Encoder,java.lang.String,java.lang.Object[] vw,calls,values \nprint org.apache.avro.io.TestValidatingIO$Encoding,int,org.apache.avro.Schema,org.apache.avro.Schema,java.lang.Object[],java.lang.Object[] encoding,skipLevel,writerSchema,readerSchema,writtenValues,expectedValues \n";

    public TestValidatingIO(Encoding enc, int skip, String js, String cls) {
        this.eEnc = enc;
        this.iSkipL = skip;
        this.sJsSch = js;
        this.sCl = cls;
    }

    @Test
    public void testMain() throws IOException {
        for (int i = 0; i < 1; ++i) {
            this.testOnce(new Schema.Parser().parse(this.sJsSch), this.sCl, this.iSkipL, this.eEnc);
        }
    }

    private void testOnce(Schema schema, String calls, int skipLevel, Encoding encoding) throws IOException {
        Object[] values = TestValidatingIO.randomValues(calls);
        TestValidatingIO.print(this.eEnc, this.iSkipL, schema, schema, values, values);
        byte[] bytes = TestValidatingIO.make(schema, calls, values, encoding);
        TestValidatingIO.check(schema, bytes, calls, values, skipLevel, encoding);
    }

    public static byte[] make(Schema sc, String calls, Object[] values, Encoding encoding) throws IOException {
        EncoderFactory factory = EncoderFactory.get();
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        BinaryEncoder bvo = null;
        switch (encoding) {
            case BINARY: {
                bvo = factory.binaryEncoder((OutputStream)ba, null);
                break;
            }
            case BLOCKING_BINARY: {
                bvo = factory.blockingBinaryEncoder((OutputStream)ba, null);
                break;
            }
            case JSON: {
                bvo = factory.jsonEncoder(sc, (OutputStream)ba);
            }
        }
        ValidatingEncoder vo = factory.validatingEncoder(sc, bvo);
        TestValidatingIO.generate((Encoder)vo, calls, values);
        vo.flush();
        return ba.toByteArray();
    }

    public static void generate(Encoder vw, String calls, Object[] values) throws IOException {
        InputScanner cs = new InputScanner(calls.toCharArray());
        int p = 0;
        block20: while (!cs.isDone()) {
            char c = cs.cur();
            cs.next();
            switch (c) {
                case 'N': {
                    vw.writeNull();
                    continue block20;
                }
                case 'B': {
                    boolean b = (Boolean)values[p++];
                    vw.writeBoolean(b);
                    continue block20;
                }
                case 'I': {
                    int ii = (Integer)values[p++];
                    vw.writeInt(ii);
                    continue block20;
                }
                case 'L': {
                    long l = (Long)values[p++];
                    vw.writeLong(l);
                    continue block20;
                }
                case 'F': {
                    float f = ((Float)values[p++]).floatValue();
                    vw.writeFloat(f);
                    continue block20;
                }
                case 'D': {
                    double d = (Double)values[p++];
                    vw.writeDouble(d);
                    continue block20;
                }
                case 'S': {
                    TestValidatingIO.extractInt(cs);
                    String s = (String)values[p++];
                    vw.writeString(new Utf8(s));
                    continue block20;
                }
                case 'K': {
                    TestValidatingIO.extractInt(cs);
                    String s = (String)values[p++];
                    vw.writeString(s);
                    continue block20;
                }
                case 'b': {
                    TestValidatingIO.extractInt(cs);
                    byte[] bb = (byte[])values[p++];
                    vw.writeBytes(bb);
                    continue block20;
                }
                case 'f': {
                    TestValidatingIO.extractInt(cs);
                    byte[] bb = (byte[])values[p++];
                    vw.writeFixed(bb);
                    continue block20;
                }
                case 'e': {
                    int e = TestValidatingIO.extractInt(cs);
                    vw.writeEnum(e);
                    continue block20;
                }
                case '[': {
                    vw.writeArrayStart();
                    continue block20;
                }
                case ']': {
                    vw.writeArrayEnd();
                    continue block20;
                }
                case '{': {
                    vw.writeMapStart();
                    continue block20;
                }
                case '}': {
                    vw.writeMapEnd();
                    continue block20;
                }
                case 'c': {
                    vw.setItemCount((long)TestValidatingIO.extractInt(cs));
                    continue block20;
                }
                case 's': {
                    vw.startItem();
                    continue block20;
                }
                case 'U': {
                    vw.writeIndex(TestValidatingIO.extractInt(cs));
                    continue block20;
                }
            }
            Assert.fail();
        }
    }

    public static Object[] randomValues(String calls) {
        Random r = new Random(0L);
        InputScanner cs = new InputScanner(calls.toCharArray());
        ArrayList<Object> result = new ArrayList<Object>();
        block12: while (!cs.isDone()) {
            char c = cs.cur();
            cs.next();
            switch (c) {
                case 'N': {
                    continue block12;
                }
                case 'B': {
                    result.add(r.nextBoolean());
                    continue block12;
                }
                case 'I': {
                    result.add(r.nextInt());
                    continue block12;
                }
                case 'L': {
                    result.add(new Long(r.nextInt()));
                    continue block12;
                }
                case 'F': {
                    result.add(new Float(r.nextInt()));
                    continue block12;
                }
                case 'D': {
                    result.add(new Double(r.nextInt()));
                    continue block12;
                }
                case 'K': 
                case 'S': {
                    result.add(TestValidatingIO.nextString(r, TestValidatingIO.extractInt(cs)));
                    continue block12;
                }
                case 'b': 
                case 'f': {
                    result.add(TestValidatingIO.nextBytes(r, TestValidatingIO.extractInt(cs)));
                    continue block12;
                }
                case 'U': 
                case 'c': 
                case 'e': {
                    TestValidatingIO.extractInt(cs);
                }
                case '[': 
                case ']': 
                case 's': 
                case '{': 
                case '}': {
                    continue block12;
                }
            }
            Assert.fail();
        }
        return result.toArray();
    }

    private static int extractInt(InputScanner sc) {
        int r = 0;
        while (!sc.isDone() && Character.isDigit(sc.cur())) {
            r = r * 10 + sc.cur() - 48;
            sc.next();
        }
        return r;
    }

    private static byte[] nextBytes(Random r, int length) {
        byte[] bb = new byte[length];
        r.nextBytes(bb);
        return bb;
    }

    private static String nextString(Random r, int length) {
        char[] cc = new char[length];
        for (int i = 0; i < length; ++i) {
            cc[i] = (char)(65 + r.nextInt(26));
        }
        return new String(cc);
    }

    private static void check(Schema sc, byte[] bytes, String calls, Object[] values, int skipLevel, Encoding encoding) throws IOException {
        BinaryDecoder bvi = null;
        switch (encoding) {
            case BINARY: 
            case BLOCKING_BINARY: {
                bvi = DecoderFactory.get().binaryDecoder(bytes, null);
                break;
            }
            case JSON: {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                bvi = new JsonDecoder(sc, (InputStream)in);
            }
        }
        ValidatingDecoder vi = new ValidatingDecoder(sc, (Decoder)bvi);
        TestValidatingIO.check((Decoder)vi, calls, values, skipLevel);
    }

    public static void check(Decoder vi, String calls, Object[] values, int skipLevel) throws IOException {
        InputScanner cs = new InputScanner(calls.toCharArray());
        int p = 0;
        int level = 0;
        long[] counts = new long[100];
        boolean[] isArray = new boolean[100];
        boolean[] isEmpty = new boolean[100];
        block21: while (!cs.isDone()) {
            char c = cs.cur();
            cs.next();
            switch (c) {
                case 'N': {
                    vi.readNull();
                    break;
                }
                case 'B': {
                    Assert.assertEquals((Object)values[p++], (Object)vi.readBoolean());
                    break;
                }
                case 'I': {
                    Assert.assertEquals((Object)values[p++], (Object)vi.readInt());
                    break;
                }
                case 'L': {
                    Assert.assertEquals((Object)values[p++], (Object)vi.readLong());
                    break;
                }
                case 'F': {
                    if (!(values[p] instanceof Float)) {
                        Assert.fail();
                    }
                    float f = ((Float)values[p++]).floatValue();
                    Assert.assertEquals((float)f, (float)vi.readFloat(), (float)Math.abs(f / 1000.0f));
                    break;
                }
                case 'D': {
                    if (!(values[p] instanceof Double)) {
                        Assert.fail();
                    }
                    double d = (Double)values[p++];
                    Assert.assertEquals((double)d, (double)vi.readDouble(), (double)Math.abs(d / 1000.0));
                    break;
                }
                case 'S': {
                    TestValidatingIO.extractInt(cs);
                    if (level == skipLevel) {
                        vi.skipString();
                        ++p;
                        break;
                    }
                    String s = (String)values[p++];
                    Assert.assertEquals((Object)new Utf8(s), (Object)vi.readString(null));
                    break;
                }
                case 'K': {
                    TestValidatingIO.extractInt(cs);
                    if (level == skipLevel) {
                        vi.skipString();
                        ++p;
                        break;
                    }
                    String s = (String)values[p++];
                    Assert.assertEquals((Object)new Utf8(s), (Object)vi.readString(null));
                    break;
                }
                case 'b': {
                    TestValidatingIO.extractInt(cs);
                    if (level == skipLevel) {
                        vi.skipBytes();
                        ++p;
                        break;
                    }
                    byte[] bb = (byte[])values[p++];
                    ByteBuffer bb2 = vi.readBytes(null);
                    byte[] actBytes = new byte[bb2.remaining()];
                    System.arraycopy(bb2.array(), bb2.position(), actBytes, 0, bb2.remaining());
                    Assert.assertArrayEquals((byte[])bb, (byte[])actBytes);
                    break;
                }
                case 'f': {
                    int len = TestValidatingIO.extractInt(cs);
                    if (level == skipLevel) {
                        vi.skipFixed(len);
                        ++p;
                        break;
                    }
                    byte[] bb = (byte[])values[p++];
                    byte[] actBytes = new byte[len];
                    vi.readFixed(actBytes);
                    Assert.assertArrayEquals((byte[])bb, (byte[])actBytes);
                    break;
                }
                case 'e': {
                    int e = TestValidatingIO.extractInt(cs);
                    if (level == skipLevel) {
                        vi.readEnum();
                        break;
                    }
                    Assert.assertEquals((long)e, (long)vi.readEnum());
                    break;
                }
                case '[': {
                    if (level == skipLevel) {
                        p += TestValidatingIO.skip(cs, vi, true);
                        break;
                    }
                    counts[++level] = vi.readArrayStart();
                    isArray[level] = true;
                    isEmpty[level] = counts[level] == 0L;
                    continue block21;
                }
                case '{': {
                    if (level == skipLevel) {
                        p += TestValidatingIO.skip(cs, vi, false);
                        break;
                    }
                    counts[++level] = vi.readMapStart();
                    isArray[level] = false;
                    isEmpty[level] = counts[level] == 0L;
                    continue block21;
                }
                case ']': {
                    Assert.assertEquals((long)0L, (long)counts[level]);
                    if (!isEmpty[level]) {
                        Assert.assertEquals((long)0L, (long)vi.arrayNext());
                    }
                    --level;
                    break;
                }
                case '}': {
                    Assert.assertEquals((long)0L, (long)counts[level]);
                    if (!isEmpty[level]) {
                        Assert.assertEquals((long)0L, (long)vi.mapNext());
                    }
                    --level;
                    break;
                }
                case 's': {
                    if (counts[level] == 0L) {
                        counts[level] = isArray[level] ? vi.arrayNext() : vi.mapNext();
                    }
                    int n = level;
                    counts[n] = counts[n] - 1L;
                    continue block21;
                }
                case 'c': {
                    TestValidatingIO.extractInt(cs);
                    continue block21;
                }
                case 'U': {
                    int idx = TestValidatingIO.extractInt(cs);
                    Assert.assertEquals((long)idx, (long)vi.readIndex());
                    continue block21;
                }
                case 'R': {
                    ((ResolvingDecoder)vi).readFieldOrder();
                    continue block21;
                }
                default: {
                    Assert.fail();
                }
            }
        }
        Assert.assertEquals((long)values.length, (long)p);
    }

    private static int skip(InputScanner cs, Decoder vi, boolean isArray) throws IOException {
        char end;
        char c = end = isArray ? (char)']' : '}';
        if (isArray) {
            Assert.assertEquals((long)0L, (long)vi.skipArray());
        } else if (end == '}') {
            Assert.assertEquals((long)0L, (long)vi.skipMap());
        }
        int level = 0;
        int p = 0;
        while (!cs.isDone()) {
            char c2 = cs.cur();
            cs.next();
            switch (c2) {
                case '[': 
                case '{': {
                    ++level;
                    break;
                }
                case ']': 
                case '}': {
                    if (c2 == end && level == 0) {
                        return p;
                    }
                    --level;
                    break;
                }
                case 'B': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'K': 
                case 'L': 
                case 'S': 
                case 'b': 
                case 'e': 
                case 'f': {
                    ++p;
                }
            }
        }
        throw new RuntimeException("Don't know how to skip");
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(TestValidatingIO.convertTo2dArray(encodings, skipLevels, TestValidatingIO.testSchemas()));
    }

    public static Object[][] convertTo2dArray(Object[][] ... values) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        Iterator<Object[]> iter = TestValidatingIO.cartesian(values);
        while (iter.hasNext()) {
            Object[] objects = iter.next();
            ret.add(objects);
        }
        Object[][] retArrays = new Object[ret.size()][];
        for (int i = 0; i < ret.size(); ++i) {
            retArrays[i] = (Object[])ret.get(i);
        }
        return retArrays;
    }

    public static Iterator<Object[]> cartesian(final Object[][] ... values) {
        return new Iterator<Object[]>(){
            private int[] pos;
            {
                this.pos = new int[values.length];
            }

            @Override
            public boolean hasNext() {
                return this.pos[0] < values[0].length;
            }

            @Override
            public Object[] next() {
                int i;
                Object[][] v = new Object[values.length][];
                for (i = 0; i < v.length; ++i) {
                    v[i] = values[i][this.pos[i]];
                }
                for (i = v.length - 1; i >= 0; --i) {
                    int n = i;
                    this.pos[n] = this.pos[n] + 1;
                    if (this.pos[n] != values[i].length) break;
                    if (i == 0) continue;
                    this.pos[i] = 0;
                }
                return TestValidatingIO.concat(v);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Object[] concat(Object[] ... oo) {
        int l = 0;
        for (Object[] o : oo) {
            l += o.length;
        }
        Object[] result = new Object[l];
        l = 0;
        for (Object[] o : oo) {
            System.arraycopy(o, 0, result, l, o.length);
            l += o.length;
        }
        return result;
    }

    static Object[][] paste(Object[][] ... in) {
        Object[][] result = new Object[in[0].length][];
        Object[][] cc = new Object[in.length][];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < cc.length; ++j) {
                cc[j] = in[j][i];
            }
            result[i] = TestValidatingIO.concat(cc);
        }
        return result;
    }

    public static Object[][] testSchemas() {
        return new Object[][]{{"\"null\"", "N"}, {"\"boolean\"", "B"}, {"\"int\"", "I"}, {"\"long\"", "L"}, {"\"float\"", "F"}, {"\"double\"", "D"}, {"\"string\"", "S0"}, {"\"string\"", "S10"}, {"\"bytes\"", "b0"}, {"\"bytes\"", "b10"}, {"{\"type\":\"fixed\", \"name\":\"fi\", \"size\": 1}", "f1"}, {"{\"type\":\"fixed\", \"name\":\"fi\", \"size\": 10}", "f10"}, {"{\"type\":\"enum\", \"name\":\"en\", \"symbols\":[\"v1\", \"v2\"]}", "e1"}, {"{\"type\":\"array\", \"items\": \"boolean\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"long\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"float\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"double\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"string\"}", "[]"}, {"{\"type\":\"array\", \"items\": \"bytes\"}", "[]"}, {"{\"type\":\"array\", \"items\":{\"type\":\"fixed\", \"name\":\"fi\", \"size\": 10}}", "[]"}, {"{\"type\":\"array\", \"items\": \"boolean\"}", "[c1sB]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[c1sI]"}, {"{\"type\":\"array\", \"items\": \"long\"}", "[c1sL]"}, {"{\"type\":\"array\", \"items\": \"float\"}", "[c1sF]"}, {"{\"type\":\"array\", \"items\": \"double\"}", "[c1sD]"}, {"{\"type\":\"array\", \"items\": \"string\"}", "[c1sS10]"}, {"{\"type\":\"array\", \"items\": \"bytes\"}", "[c1sb10]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[c1sIc1sI]"}, {"{\"type\":\"array\", \"items\": \"int\"}", "[c2sIsI]"}, {"{\"type\":\"array\", \"items\":{\"type\":\"fixed\", \"name\":\"fi\", \"size\": 10}}", "[c2sf10sf10]"}, {"{\"type\":\"map\", \"values\": \"boolean\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"long\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"float\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"double\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"string\"}", "{}"}, {"{\"type\":\"map\", \"values\": \"bytes\"}", "{}"}, {"{\"type\":\"map\", \"values\": {\"type\":\"array\", \"items\":\"int\"}}", "{}"}, {"{\"type\":\"map\", \"values\": \"boolean\"}", "{c1sK5B}"}, {"{\"type\":\"map\", \"values\": \"int\"}", "{c1sK5I}"}, {"{\"type\":\"map\", \"values\": \"long\"}", "{c1sK5L}"}, {"{\"type\":\"map\", \"values\": \"float\"}", "{c1sK5F}"}, {"{\"type\":\"map\", \"values\": \"double\"}", "{c1sK5D}"}, {"{\"type\":\"map\", \"values\": \"string\"}", "{c1sK5S10}"}, {"{\"type\":\"map\", \"values\": \"bytes\"}", "{c1sK5b10}"}, {"{\"type\":\"map\", \"values\": {\"type\":\"array\", \"items\":\"int\"}}", "{c1sK5[c3sIsIsI]}"}, {"{\"type\":\"map\", \"values\": \"boolean\"}", "{c1sK5Bc2sK5BsK5B}"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"boolean\"}]}", "B"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"int\"}]}", "I"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"long\"}]}", "L"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"float\"}]}", "F"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"double\"}]}", "D"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"string\"}]}", "S10"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f\", \"type\":\"bytes\"}]}", "b10"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"int\"},{\"name\":\"f2\", \"type\":\"double\"},{\"name\":\"f3\", \"type\":\"string\"}]}", "IDS10"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f0\", \"type\":\"null\"},{\"name\":\"f1\", \"type\":\"boolean\"},{\"name\":\"f2\", \"type\":\"int\"},{\"name\":\"f3\", \"type\":\"long\"},{\"name\":\"f4\", \"type\":\"float\"},{\"name\":\"f5\", \"type\":\"double\"},{\"name\":\"f6\", \"type\":\"string\"},{\"name\":\"f7\", \"type\":\"bytes\"}]}", "NBILFDS10b25"}, {"{\"type\":\"record\",\"name\":\"outer\",\"fields\":[{\"name\":\"f1\", \"type\":{\"type\":\"record\", \"name\":\"inner\", \"fields\":[{\"name\":\"g1\", \"type\":\"int\"}, {\"name\":\"g2\", \"type\":\"double\"}]}},{\"name\":\"f2\", \"type\":\"string\"},{\"name\":\"f3\", \"type\":\"inner\"}]}", "IDS10ID"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":{\"type\":\"array\", \"items\":\"int\"}}]}", "L[c1sI]"}, {"{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":{\"type\":\"map\", \"values\":\"int\"}}]}", "L{c1sK5I}"}, {"{\"type\":\"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":\"null\"}]}}", "[c2sLNsLN]"}, {"{\"type\":\"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":{\"type\":\"array\", \"items\":\"int\"}}]}}", "[c2sL[c1sI]sL[c2sIsI]]"}, {"{\"type\":\"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":{\"type\":\"map\", \"values\":\"int\"}}]}}", "[c2sL{c1sK5I}sL{c2sK5IsK5I}]"}, {"{\"type\":\"array\", \"items\":{\"type\":\"record\",\"name\":\"r\",\"fields\":[{\"name\":\"f1\", \"type\":\"long\"},{\"name\":\"f2\", \"type\":[\"null\", \"int\"]}]}}", "[c2sLU0NsLU1I]"}, {"[\"boolean\"]", "U0B"}, {"[\"int\"]", "U0I"}, {"[\"long\"]", "U0L"}, {"[\"float\"]", "U0F"}, {"[\"double\"]", "U0D"}, {"[\"string\"]", "U0S10"}, {"[\"bytes\"]", "U0b10"}, {"[\"null\", \"int\"]", "U0N"}, {"[\"boolean\", \"int\"]", "U0B"}, {"[\"boolean\", \"int\"]", "U1I"}, {"[\"boolean\", {\"type\":\"array\", \"items\":\"int\"} ]", "U0B"}, {"[\"boolean\", {\"type\":\"array\", \"items\":\"int\"} ]", "U1[c1sI]"}, {"{\"type\": \"record\", \"name\": \"Node\", \"fields\": [{\"name\":\"label\", \"type\":\"string\"},{\"name\":\"children\", \"type\":{\"type\": \"array\", \"items\": \"Node\" }}]}", "S10[c1sS10[]]"}, {"{\"type\": \"record\", \"name\": \"Lisp\", \"fields\": [{\"name\":\"value\", \"type\":[\"null\", \"string\",{\"type\": \"record\", \"name\": \"Cons\", \"fields\": [{\"name\":\"car\", \"type\":\"Lisp\"},{\"name\":\"cdr\", \"type\":\"Lisp\"}]}]}]}", "U0N"}, {"{\"type\": \"record\", \"name\": \"Lisp\", \"fields\": [{\"name\":\"value\", \"type\":[\"null\", \"string\",{\"type\": \"record\", \"name\": \"Cons\", \"fields\": [{\"name\":\"car\", \"type\":\"Lisp\"},{\"name\":\"cdr\", \"type\":\"Lisp\"}]}]}]}", "U1S10"}, {"{\"type\": \"record\", \"name\": \"Lisp\", \"fields\": [{\"name\":\"value\", \"type\":[\"null\", \"string\",{\"type\": \"record\", \"name\": \"Cons\", \"fields\": [{\"name\":\"car\", \"type\":\"Lisp\"},{\"name\":\"cdr\", \"type\":\"Lisp\"}]}]}]}", "U2U1S10U0N"}, {"{\"type\": \"record\", \"name\": \"Node\", \"fields\": [{\"name\":\"children\", \"type\":{\"type\": \"array\", \"items\": \"Node\" }}]}", "[c1s[c1s[c1s[c1s[c1s[c1s[c1s[c1s[c1s[c1s[c1s[]]]]]]]]]]]]"}};
    }

    static void dump(byte[] bb) {
        int col = 0;
        for (byte b : bb) {
            if (col % 16 == 0) {
                System.out.println();
            }
            ++col;
            System.out.print(Integer.toHexString(b & 0xFF) + " ");
        }
        System.out.println();
    }

    static void print(Encoding encoding, int skipLevel, Schema writerSchema, Schema readerSchema, Object[] writtenValues, Object[] expectedValues) {
        LOG.debug("{} Skip Level {}", (Object)encoding, (Object)skipLevel);
        TestValidatingIO.printSchemaAndValues("Writer", writerSchema, writtenValues);
        TestValidatingIO.printSchemaAndValues("Reader", readerSchema, expectedValues);
    }

    private static void printSchemaAndValues(String schemaType, Schema schema, Object[] values) {
        LOG.debug("{} Schema {}", (Object)schemaType, (Object)schema);
        for (Object value : values) {
            LOG.debug("{} -> {}", value, (Object)value.getClass().getSimpleName());
        }
    }

    public static class InputScanner {
        private final char[] chars;
        private int cpos = 0;
        public static final String __PARANAMER_DATA = "<init> char[] chars \n";

        public InputScanner(char[] chars) {
            this.chars = chars;
        }

        public boolean next() {
            if (this.cpos < this.chars.length) {
                ++this.cpos;
            }
            return this.cpos != this.chars.length;
        }

        public char cur() {
            return this.chars[this.cpos];
        }

        public boolean isDone() {
            return this.cpos == this.chars.length;
        }
    }

    static enum Encoding {
        BINARY,
        BLOCKING_BINARY,
        JSON;

        public static final String __PARANAMER_DATA = "";
    }
}

