/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ValidatingEncoder;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestResolvingGrammarGenerator {
    private final Schema schema;
    private final JsonNode data;
    public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String jsonSchema,jsonData \n";

    public TestResolvingGrammarGenerator(String jsonSchema, String jsonData) throws IOException {
        this.schema = Schema.parse((String)jsonSchema);
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        this.data = mapper.readTree((Reader)new StringReader(jsonData));
    }

    @Test
    public void test() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        EncoderFactory factory = EncoderFactory.get();
        ValidatingEncoder e = factory.validatingEncoder(this.schema, (Encoder)factory.binaryEncoder((OutputStream)baos, null));
        ResolvingGrammarGenerator.encode((Encoder)e, (Schema)this.schema, (JsonNode)this.data);
        e.flush();
    }

    @Test
    public void testRecordMissingRequiredFieldError() throws Exception {
        Schema schemaWithoutField = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"MyRecord").namespace("ns")).fields().name("field1").type().stringType().noDefault().endRecord();
        Schema schemaWithField = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"MyRecord").namespace("ns")).fields().name("field1").type().stringType().noDefault().name("field2").type().stringType().noDefault().endRecord();
        GenericData.Record record = new GenericRecordBuilder(schemaWithoutField).set("field1", (Object)"someValue").build();
        byte[] data = this.writeRecord(schemaWithoutField, record);
        try {
            this.readRecord(schemaWithField, data);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (AvroTypeException typeException) {
            Assert.assertEquals((String)"Incorrect exception message", (Object)"Found ns.MyRecord, expecting ns.MyRecord, missing required field field2", (Object)typeException.getMessage());
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        List<Object[]> ret = Arrays.asList({"{ \"type\": \"record\", \"name\": \"r\", \"fields\": [  { \"name\" : \"f1\", \"type\": \"int\" },  { \"name\" : \"f2\", \"type\": \"float\" } ] } }", "{ \"f2\": 10.4, \"f1\": 10 } "}, {"{ \"type\": \"enum\", \"name\": \"e\", \"symbols\": [ \"s1\", \"s2\"] } }", " \"s1\" "}, {"{ \"type\": \"enum\", \"name\": \"e\", \"symbols\": [ \"s1\", \"s2\"] } }", " \"s2\" "}, {"{ \"type\": \"fixed\", \"name\": \"f\", \"size\": 10 }", "\"hello\""}, {"{ \"type\": \"array\", \"items\": \"int\" }", "[ 10, 20, 30 ]"}, {"{ \"type\": \"map\", \"values\": \"int\" }", "{ \"k1\": 10, \"k3\": 20, \"k3\": 30 }"}, {"[ \"int\", \"long\" ]", "10"}, {"\"string\"", "\"hello\""}, {"\"bytes\"", "\"hello\""}, {"\"int\"", "10"}, {"\"long\"", "10"}, {"\"float\"", "10.0"}, {"\"double\"", "10.0"}, {"\"boolean\"", "true"}, {"\"boolean\"", "false"}, {"\"null\"", "null"});
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeRecord(Schema schema, GenericData.Record record) throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter writer = new DataFileWriter((DatumWriter)datumWriter);
        try {
            writer.create(schema, (OutputStream)byteStream);
            writer.append((Object)record);
        }
        finally {
            writer.close();
        }
        return byteStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericData.Record readRecord(Schema schema, byte[] data) throws Exception {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        GenericDatumReader datumReader = new GenericDatumReader(schema);
        DataFileStream reader = new DataFileStream((InputStream)byteStream, (DatumReader)datumReader);
        try {
            GenericData.Record record = (GenericData.Record)reader.next();
            return record;
        }
        finally {
            reader.close();
        }
    }
}

