/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.io.parsing.Symbol;
import org.junit.Assert;
import org.junit.Test;

public class TestResolvingGrammarGenerator2 {
    Schema point2dFullname = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Point").namespace("written")).fields().requiredDouble("x").requiredDouble("y").endRecord();
    Schema point3dNoDefault = (Schema)SchemaBuilder.record((String)"Point").fields().requiredDouble("x").requiredDouble("y").requiredDouble("z").endRecord();
    Schema point2d = (Schema)SchemaBuilder.record((String)"Point2D").fields().requiredDouble("x").requiredDouble("y").endRecord();
    Schema point3d = (Schema)SchemaBuilder.record((String)"Point3D").fields().requiredDouble("x").requiredDouble("y").name("z").type().doubleType().doubleDefault(0.0).endRecord();
    Schema point3dMatchName = (Schema)SchemaBuilder.record((String)"Point").fields().requiredDouble("x").requiredDouble("y").name("z").type().doubleType().doubleDefault(0.0).endRecord();
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testFixed() throws IOException {
        new ResolvingGrammarGenerator().generate(Schema.createFixed((String)"MyFixed", null, null, (int)10), Schema.create((Schema.Type)Schema.Type.BYTES));
        new ResolvingGrammarGenerator().generate(Schema.create((Schema.Type)Schema.Type.BYTES), Schema.createFixed((String)"MyFixed", null, null, (int)10));
    }

    @Test(expected=SchemaValidationException.class)
    public void testUnionResolutionNoStructureMatch() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault));
        new SchemaValidatorBuilder().canBeReadStrategy().validateAll().validate(this.point2dFullname, Arrays.asList(read));
    }

    @Test
    public void testUnionResolutionFirstStructureMatch2d() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault, this.point2d, this.point3d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assert.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assert.assertEquals((long)2L, (long)action.rindex);
    }

    @Test
    public void testUnionResolutionFirstStructureMatch3d() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault, this.point3d, this.point2d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assert.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assert.assertEquals((long)2L, (long)action.rindex);
    }

    @Test
    public void testUnionResolutionNamedStructureMatch() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point2d, this.point3dMatchName, this.point3d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assert.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assert.assertEquals((long)2L, (long)action.rindex);
    }

    @Test
    public void testUnionResolutionFullNameMatch() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point2d, this.point3dMatchName, this.point3d, this.point2dFullname));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assert.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assert.assertEquals((long)4L, (long)action.rindex);
    }
}

