/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.message;

import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterables;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Ordering;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.junit.Assert;
import org.junit.Test;

public class TestBinaryMessageEncoding {
    public static final Schema SCHEMA_V1 = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredInt("id").optionalString("msg").endRecord();
    public static final GenericRecordBuilder V1_BUILDER = new GenericRecordBuilder(SCHEMA_V1);
    public static final List<GenericData.Record> V1_RECORDS = Arrays.asList(V1_BUILDER.set("id", (Object)1).set("msg", (Object)"m-1").build(), V1_BUILDER.set("id", (Object)2).set("msg", (Object)"m-2").build(), V1_BUILDER.set("id", (Object)4).set("msg", (Object)"m-4").build(), V1_BUILDER.set("id", (Object)6).set("msg", (Object)"m-6").build());
    public static final Schema SCHEMA_V2 = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"TestRecord").fields().requiredLong("id").name("message").aliases(new String[]{"msg"})).type().optional().stringType()).optionalDouble("data").endRecord();
    public static final GenericRecordBuilder V2_BUILDER = new GenericRecordBuilder(SCHEMA_V2);
    public static final List<GenericData.Record> V2_RECORDS = Arrays.asList(V2_BUILDER.set("id", (Object)3L).set("message", (Object)"m-3").set("data", (Object)12.3).build(), V2_BUILDER.set("id", (Object)5L).set("message", (Object)"m-5").set("data", (Object)23.4).build(), V2_BUILDER.set("id", (Object)7L).set("message", (Object)"m-7").set("data", (Object)34.5).build(), V2_BUILDER.set("id", (Object)8L).set("message", (Object)"m-8").set("data", (Object)35.6).build());
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testByteBufferRoundTrip() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        GenericData.Record copy = (GenericData.Record)decoder.decode(encoder.encode((Object)V2_RECORDS.get(0)));
        Assert.assertTrue((String)"Copy should not be the same object", (copy != V2_RECORDS.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Record should be identical after round-trip", (Object)V2_RECORDS.get(0), (Object)copy);
    }

    @Test
    public void testSchemaEvolution() throws Exception {
        ArrayList buffers = Lists.newArrayList();
        List records = Ordering.usingToString().sortedCopy(Iterables.concat(V1_RECORDS, V2_RECORDS));
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        BinaryMessageEncoder v2Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        for (GenericData.Record record : records) {
            if (record.getSchema() == SCHEMA_V1) {
                buffers.add(v1Encoder.encode((Object)record));
                continue;
            }
            buffers.add(v2Encoder.encode((Object)record));
        }
        HashSet allAsV2 = Sets.newHashSet(V2_RECORDS);
        allAsV2.add(V2_BUILDER.set("id", (Object)1L).set("message", (Object)"m-1").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)2L).set("message", (Object)"m-2").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)4L).set("message", (Object)"m-4").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)6L).set("message", (Object)"m-6").clear("data").build());
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        HashSet decodedUsingV2 = Sets.newHashSet();
        for (ByteBuffer buffer : buffers) {
            decodedUsingV2.add(v2Decoder.decode(buffer));
        }
        Assert.assertEquals((Object)allAsV2, (Object)decodedUsingV2);
    }

    @Test(expected=MissingSchemaException.class)
    public void testCompatibleReadFailsWithoutSchema() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
        v2Decoder.decode(v1Buffer);
    }

    @Test
    public void testCompatibleReadWithSchema() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
        GenericData.Record record = (GenericData.Record)v2Decoder.decode(v1Buffer);
        Assert.assertEquals((Object)V2_BUILDER.set("id", (Object)6L).set("message", (Object)"m-6").clear("data").build(), (Object)record);
    }

    @Test
    public void testCompatibleReadWithSchemaFromLookup() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        SchemaStore.Cache schemaCache = new SchemaStore.Cache();
        schemaCache.addSchema(SCHEMA_V1);
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2, (SchemaStore)schemaCache);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(2));
        GenericData.Record record = (GenericData.Record)v2Decoder.decode(v1Buffer);
        Assert.assertEquals((Object)V2_BUILDER.set("id", (Object)4L).set("message", (Object)"m-4").clear("data").build(), (Object)record);
    }

    @Test
    public void testBufferReuse() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1, false);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assert.assertEquals((Object)b0.array(), (Object)b1.array());
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V1);
        Assert.assertEquals((String)"Buffer was reused, decode(b0) should be record 1", (Object)V1_RECORDS.get(1), (Object)decoder.decode(b0));
    }

    @Test
    public void testBufferCopy() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assert.assertNotEquals((Object)b0.array(), (Object)b1.array());
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V1);
        Assert.assertEquals((String)"Buffer was copied, decode(b0) should be record 0", (Object)V1_RECORDS.get(0), (Object)decoder.decode(b0));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testByteBufferMissingPayload() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.limit(12);
        decoder.decode(buffer);
    }

    @Test(expected=BadHeaderException.class)
    public void testByteBufferMissingFullHeader() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.limit(8);
        decoder.decode(buffer);
    }

    @Test(expected=BadHeaderException.class)
    public void testByteBufferBadMarkerByte() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[0] = 0;
        decoder.decode(buffer);
    }

    @Test(expected=BadHeaderException.class)
    public void testByteBufferBadVersionByte() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[1] = 0;
        decoder.decode(buffer);
    }

    @Test(expected=MissingSchemaException.class)
    public void testByteBufferUnknownSchema() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[4] = 0;
        decoder.decode(buffer);
    }
}

